/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ExceptionUtils {
    public AtomicInteger sqlNonTransientConnectionExceptionTimes = new AtomicInteger(0);
    @Autowired
    Environment environment;
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    public Throwable filterSQLException(Throwable e) {
        if (e.getCause() instanceof SQLException) {
            SQLException cause = (SQLException)e.getCause();
            try {
                Field superCause = Throwable.class.getDeclaredField("cause");
                Field superDetailMessage = Throwable.class.getDeclaredField("detailMessage");
                superCause.setAccessible(true);
                superCause.set(e, cause.getNextException());
                superDetailMessage.setAccessible(true);
                superDetailMessage.set(e, cause.getNextException().getMessage());
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return e;
    }

    public void dealSQLNonTransientConnectionException(Throwable e) {
        String dumpPath = this.environment.getProperty("lcdp.modeldriven.SQLConnectionCloseException.dumpPath");
        if (StringUtils.isNotEmpty((CharSequence)dumpPath)) {
            if (e.getCause() instanceof SQLNonTransientConnectionException) {
                if (e.getCause().getMessage().contains("Connection is closed")) {
                    if (this.sqlNonTransientConnectionExceptionTimes.getAndIncrement() <= 1) {
                        try {
                            this.generateHeapDump(dumpPath);
                            this.generateThreadDump(dumpPath);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    log.debug("<<<<< SQLNonTransientConnectionException message is :" + e.getCause().getMessage());
                }
            } else if (e.getCause() != null && e.getCause().getCause() instanceof SQLNonTransientConnectionException) {
                if (e.getCause().getCause().getMessage().contains("Connection is closed")) {
                    if (this.sqlNonTransientConnectionExceptionTimes.getAndIncrement() <= 1) {
                        try {
                            this.generateHeapDump(dumpPath);
                            this.generateThreadDump(dumpPath);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    log.debug("<<<<< SQLNonTransientConnectionException message is :" + e.getCause().getCause().getMessage());
                }
            }
        }
    }

    private void generateHeapDump(String path) throws IOException {
        String filePath = path + File.separator + System.currentTimeMillis() + ".hprof";
        String jmapCommand = "jmap -dump:format=b,file=" + filePath + " " + ExceptionUtils.getPid();
        log.debug("<<<< Heap dump generate with command:  " + jmapCommand);
        Runtime.getRuntime().exec(jmapCommand);
        log.info("<<<< Heap dump generated in " + filePath);
    }

    private void generateThreadDump(String path) throws IOException {
        String filePath = path + File.separator + System.currentTimeMillis() + ".txt";
        String jstackCommand = "jstack -l " + ExceptionUtils.getPid() + " > " + filePath;
        log.debug("<<<< Thread dump generate with command:  " + jstackCommand);
        Runtime.getRuntime().exec(jstackCommand);
        log.info("<<<< Thread dump generated in " + filePath);
    }

    private static String getPid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }
}

