/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelIndexUtil {
    public static boolean isNotEqualContext(ModelIndexDTO draftModelIndex, ModelIndexDTO publishedModelIndex) {
        return !draftModelIndex.isEqualContext(publishedModelIndex);
    }

    public static Map<String, Object> getUniques(List<ModelIndexDTO> modelIndexDTOs) {
        HashMap<String, Object> uniquesPublishedRemain = new HashMap<String, Object>();
        modelIndexDTOs.stream().filter(modelIndex -> IndexTypeEnum.getIndexType(modelIndex.getType()) == IndexTypeEnum.UNIQUE_INDEX).forEach(modelIndex -> uniquesPublishedRemain.put(modelIndex.getId(), modelIndex));
        return uniquesPublishedRemain;
    }

    public static List<String> getIndexNames(List<ModelIndexDTO> modelIndexDTOs) {
        ArrayList<String> indexNames = new ArrayList<String>();
        Map<String, Object> getIndexes = ModelIndexUtil.getIndexes(modelIndexDTOs);
        getIndexes.keySet().stream().forEach(modelIndex -> indexNames.add((String)modelIndex));
        return indexNames;
    }

    public static List<ModelIndexDTO> getModelTableAllIndexes(ModelSchemaDTO modelSchema) {
        ArrayList<ModelIndexDTO> allIndexes = new ArrayList<ModelIndexDTO>();
        List<ModelIndexDTO> schemaIndexes = modelSchema.getIndex();
        allIndexes.addAll(schemaIndexes);
        ModelTable modelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema);
        List<ModelIndexDTO> tableColumnUniqueIndexes = ModelIndexUtil.getColumnUniqueIndexes(modelTable);
        allIndexes.addAll(tableColumnUniqueIndexes);
        return allIndexes;
    }

    public static Map<String, Object> getIndexes(List<ModelIndexDTO> modelIndexDTOs) {
        HashMap<String, Object> uniquesPublishedRemain = new HashMap<String, Object>();
        modelIndexDTOs.stream().forEach(modelIndex -> uniquesPublishedRemain.put(modelIndex.getId(), modelIndex));
        return uniquesPublishedRemain;
    }

    public static List<ModelIndexDTO> covertModelIndex(List<TableIndex> tableIndexes) {
        ArrayList<ModelIndexDTO> modelIndexes = new ArrayList<ModelIndexDTO>();
        tableIndexes.stream().forEach(tableIndex -> modelIndexes.add(ModelSchemaUtil.convertTableIndexToModelIndex(tableIndex)));
        return modelIndexes;
    }

    public static List<ModelIndexDTO> getColumnUniqueIndexes(ModelTable modelTable) {
        ArrayList<ModelIndexDTO> columnUniqueIndexes = new ArrayList<ModelIndexDTO>();
        modelTable.getColumns().stream().filter(tableColumn -> tableColumn.isPK() == false && tableColumn.getUnique() != false).forEach(tableColumn -> {
            String columnName = tableColumn.getColumnName();
            ArrayList<String> members = new ArrayList<String>();
            members.add(columnName);
            ModelIndexDTO columnUniqueIndex = new ModelIndexDTO();
            columnUniqueIndex.setId(columnName);
            columnUniqueIndex.setMember(members);
            columnUniqueIndex.setType(IndexTypeEnum.UNIQUE_INDEX.getIndexChar());
            columnUniqueIndexes.add(columnUniqueIndex);
        });
        return columnUniqueIndexes;
    }
}

