/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.exceptions.DWMetadataNotFoundException;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionBase;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionEmpty;
import com.digiwin.data.permission.DWRowPermissionGroup;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.utils.BMDataEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.customize.utils.BMDataModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.ColumnNullableEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.model.TableSqlParamDTO;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMetadataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.utils.DWTenantUtils;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelSqlGenerator.class);
    private static final SimpleDateFormat bindedSqlDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static SqlParam generateCreateTableSql(ModelTable modelTable) {
        ArrayList params = new ArrayList();
        String tableName = modelTable.getName();
        String tableComment = modelTable.getComment();
        String indexSql = ModelSqlGenerator.generateIndexes(modelTable.getIndexes());
        String columnsSql = modelTable.getColumns().stream().map(column -> String.format("`%s` %s %s %s %s COMMENT '%s' ", column.getColumnName(), ModelSqlGenerator.getTypeDDL(column), ModelSqlGenerator.getNullableEnum(column.nullable()).getSqlChar(), ModelSqlGenerator.columnUniqueValue(column.getUnique()), ModelSqlGenerator.getSqlByAutoIncrementOrDefaultValue(column), column.getComment())).collect(Collectors.joining(" , "));
        String primaryKeysSql = ModelSqlGenerator.generatePrimaryKeys(modelTable.getColumns());
        ArrayList<String> constraints = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)indexSql)) {
            constraints.add(indexSql);
        }
        constraints.add(primaryKeysSql);
        String constraintsSql = String.join((CharSequence)" , ", constraints);
        String createTableSql = String.format("CREATE TABLE IF NOT EXISTS `%s` ( %s , %s ) COMMENT '%s' COLLATE '%s'", tableName, columnsSql, constraintsSql, tableComment, "utf8mb4_bin");
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(createTableSql);
        sqlParam.setParams(params.toArray());
        return sqlParam;
    }

    public static SqlParam generateAlterTableSql(String tableName, String tableComment) {
        String modifyTableCommentSql = String.format("ALTER TABLE `%s` COMMENT '%s' ", tableName, tableComment);
        return new SqlParam(modifyTableCommentSql, new Object[0]);
    }

    public static SqlParam generateAlterTableCollationSql(String tableName, String collation) {
        String modifyTableCommentSql = String.format("ALTER TABLE `%s` COLLATE '%s' ", tableName, collation);
        return new SqlParam(modifyTableCommentSql, new Object[0]);
    }

    public static SqlParam generateAlterTableCollationSql(String tableName) {
        SqlParam alterTableSqlParam = ModelSqlGenerator.generateAlterTableCollationSql(tableName, "utf8mb4_bin");
        return alterTableSqlParam;
    }

    public static LinkedList<SqlParam> generateAlterIndexSql(String tableName, AlterIndexEnum alterIndexEnum, TableIndex tableIndex) {
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        String targetIndexId = tableIndex.getName();
        ModelIndexDTO targetModelIndex = ModelSchemaUtil.convertTableIndexToModelIndex(tableIndex);
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        ModelTableSchemaCache modelTableSchemaCache = publishedTableCache.getOrDefault(tableName, new ModelTableSchemaCache());
        Map<String, Object> publishedRemainIndexes = modelTableSchemaCache.getPublishedRemainIndexes();
        switch (alterIndexEnum) {
            case ADD: {
                String indexAddSpecification = ModelSqlGenerator.generateIndexes(tableIndex);
                String indexAddSql = String.format("ALTER TABLE `%s` %s %s", tableName, alterIndexEnum.getSqlChar(), indexAddSpecification);
                sqlParams.add(new SqlParam(indexAddSql, new Object[0]));
                publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                log.info("publishedRemainIndexes add {}({})", (Object)targetIndexId, (Object)targetModelIndex);
                break;
            }
            case MODIFY: {
                String alterSpecification = ModelSqlGenerator.generateIndexes(tableIndex);
                if (publishedRemainIndexes.containsKey(targetIndexId)) {
                    String indexDropByModifySql = String.format("ALTER TABLE `%s` DROP INDEX `%s`", tableName, targetIndexId);
                    String indexAddByModifySql = String.format("ALTER TABLE `%s` ADD %s", tableName, alterSpecification);
                    sqlParams.add(new SqlParam(indexDropByModifySql, new Object[0]));
                    sqlParams.add(new SqlParam(indexAddByModifySql, new Object[0]));
                    publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                    log.info("publishedRemainIndexes modify {} ({})", (Object)targetIndexId, (Object)targetModelIndex);
                    break;
                }
                String indexAddByModifySql = String.format("ALTER TABLE `%s` ADD %s", tableName, alterSpecification);
                sqlParams.add(new SqlParam(indexAddByModifySql, new Object[0]));
                publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                log.info("publishedRemainIndexes add {} when modify", (Object)targetIndexId);
                break;
            }
            case DROP: {
                if (publishedRemainIndexes.containsKey(targetIndexId)) {
                    String dropColumnSql = String.format("ALTER TABLE `%s` DROP INDEX `%s` ", tableName, targetIndexId);
                    sqlParams.add(new SqlParam(dropColumnSql, null));
                    publishedRemainIndexes.remove(targetIndexId);
                    log.info("publishedRemainIndexes: remove {}", (Object)targetIndexId);
                    break;
                }
                log.warn("publishedRemainIndexes: ignored to drop {}", (Object)targetIndexId);
                break;
            }
            default: {
                throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            }
        }
        return sqlParams;
    }

    public static LinkedList<SqlParam> generateAlterColumnsSql(String tableName, AlterColumnEnum alterColumnEnum, TableColumn tableColumn) {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> extraMap = modelDrivenContext.getExtraMap();
        List existedTableNames = (List)extraMap.get("existedTables");
        boolean existedTable = false;
        if (Objects.nonNull(existedTableNames) && existedTableNames.contains(tableName)) {
            existedTable = true;
        }
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        switch (alterColumnEnum) {
            case ADD_COLUMN: {
                String addColumnSql = String.format("ALTER TABLE `%s` %s `%s` %s %s %s %s COMMENT '%s' ", tableName, alterColumnEnum.getSqlChar(), tableColumn.getColumnName(), ModelSqlGenerator.getTypeDDL(tableColumn), ModelSqlGenerator.getNullableEnum(tableColumn.nullable()).getSqlChar(), ModelSqlGenerator.columnUniqueValue(tableColumn.getUnique()), ModelSqlGenerator.getDefaultValue(tableColumn, existedTable), tableColumn.getComment());
                sqlParams.add(new SqlParam(addColumnSql, new Object[0]));
                break;
            }
            case MODIFY_COLUMN: {
                String modifyColumnSql = String.format("ALTER TABLE `%s` %s `%s` %s %s %s COMMENT '%s' %s ", tableName, alterColumnEnum.getSqlChar(), tableColumn.getColumnName(), ModelSqlGenerator.getTypeDDL(tableColumn), ModelSqlGenerator.getNullableEnum(tableColumn.nullable()).getSqlChar(), ModelSqlGenerator.getDefaultValue(tableColumn), tableColumn.getComment(), ModelSqlGenerator.getCollation(tableColumn.getDataType(), existedTable, alterColumnEnum));
                sqlParams.add(new SqlParam(modifyColumnSql, new Object[0]));
                break;
            }
            case DROP_COLUMN: {
                String dropColumnSql = String.format("ALTER TABLE `%s` %s `%s` ", tableName, alterColumnEnum.getSqlChar(), tableColumn.getColumnName());
                sqlParams.add(new SqlParam(dropColumnSql, new Object[0]));
                break;
            }
            default: {
                throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            }
        }
        return sqlParams;
    }

    public static SqlParam generateAlterColumnRemoveAutoIncreAndPkSql(String tableName, AlterColumnEnum alterColumnEnum, TableColumn tableColumn) {
        switch (alterColumnEnum) {
            case MODIFY_COLUMN: {
                String modifyColumnSql = String.format("ALTER TABLE `%s` %s `%s` %s NULL COMMENT '%s' , DROP PRIMARY KEY", tableName, alterColumnEnum.getSqlChar(), tableColumn.getColumnName(), ModelSqlGenerator.getTypeDDL(tableColumn), tableColumn.getComment());
                return new SqlParam(modifyColumnSql, new Object[0]);
            }
        }
        throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
    }

    public static SqlParam generateDropTableSql(String tableName) {
        Drop dropScript = new Drop();
        Table dropTable = new Table(tableName);
        dropScript.setName(dropTable);
        dropScript.setType("TABLE");
        dropScript.setIfExists(true);
        String sql = dropScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(sql);
        return sqlParam;
    }

    public static SqlParam generateRenameTableSql(String tableName) {
        Table alterTable = new Table(tableName);
        Alter alterScript = new Alter();
        alterScript.setTable(alterTable);
        AlterExpression renameTableNameExpression = new AlterExpression();
        renameTableNameExpression.setOperation(AlterOperation.RENAME_TABLE);
        Long timeStamp = new Timestamp(System.currentTimeMillis() / 1000L).getTime();
        renameTableNameExpression.setNewTableName(String.join((CharSequence)"_", "md", timeStamp.toString(), tableName));
        alterScript.addAlterExpression(renameTableNameExpression);
        String sql = alterScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(sql);
        return sqlParam;
    }

    public static SqlParam generateInsertRdbmsTableSql(ModelTable modelTable) {
        return new SqlParam("insert into dw_rdbms_tables  (table_name, table_display_name, table_description, delete_constraint) values(?, ?, ?, 'N') ON DUPLICATE KEY UPDATE table_name=?, table_display_name=?, table_description=?", new Object[]{modelTable.getName(), modelTable.getComment(), modelTable.getComment(), modelTable.getName(), modelTable.getComment(), modelTable.getComment()});
    }

    public static List<SqlParam> generateInsertOrUpdateRdbmsFieldSql(ModelTable modelTable) {
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        for (TableColumn tableColumn : modelTable.getColumns()) {
            SqlParam sqlParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(modelTable.getName(), tableColumn);
            returnValue.add(sqlParam);
        }
        return returnValue;
    }

    public static SqlParam generateInsertOrUpdateRdbmsFieldSql(String tableName, TableColumn tableColumn) {
        String isPk = ModelSqlGenerator.booleanToYN(tableColumn.isPK());
        String defaultValue = tableColumn.getDefaultValue() != null ? tableColumn.getDefaultValue() : "null";
        Integer size = ModelSqlGenerator.getUpdateSize(tableColumn.getSize(), tableColumn.getDataType().getDefaultSize());
        Integer scale = ModelSqlGenerator.getUpdateSize(tableColumn.getScale(), tableColumn.getDataType().getDefaultScale());
        String nullable = ModelSqlGenerator.booleanToYN(tableColumn.nullable());
        String autoIncrement = ModelSqlGenerator.booleanToYN(tableColumn.getAutoIncrement() != false || tableColumn.getAutoIncrement() != false);
        Object[] sqlParamParams = new Object[]{tableName, tableColumn.getSeq(), tableColumn.getColumnName(), isPk, tableColumn.getDataType().getName(), tableColumn.getComment(), defaultValue, nullable, size, scale, autoIncrement, tableName, tableColumn.getSeq(), tableColumn.getColumnName(), isPk, tableColumn.getDataType().getName(), tableColumn.getComment(), defaultValue, nullable, size, scale, autoIncrement};
        return new SqlParam("insert into dw_rdbms_fields  (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, default_value, nullable, is_version, size, scale, is_auto_increment)  values (?, ?, ?, ?, ?, 'Y', ?, ?, ?, 'N', ?, ?, ?)  ON DUPLICATE KEY UPDATE table_name=?, seq=?, field_name=?, is_key=?, field_type=?, status_code='N', field_display_name=?, default_value=?, nullable=?, is_version='N', size=?, scale=?, is_auto_increment=? ", sqlParamParams);
    }

    public static SqlParam generateInsertServiceMappingSql(ModelTable modelTable) {
        String tableName = modelTable.getName();
        String modelDrivenProdPrefix = (String)ModelDrivenContext.getContext().getExtraMap().getOrDefault("modelDrivenProdPrefix", "");
        String prefixEaiId = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, tableName);
        String insertServiceMappingSql = "insert into dw_service_mapping(table_name, expose_eai_id) values(?, ?) ON DUPLICATE KEY UPDATE table_name=? ,expose_eai_id=? ";
        SqlParam returnValue = new SqlParam(insertServiceMappingSql, new Object[]{tableName, prefixEaiId, tableName, prefixEaiId});
        return returnValue;
    }

    public static SqlParam generateInsertServiceMappingSql(ModelDTO model) {
        ModelSchemaDTO modelSchema = model.getSchema();
        ModelTable modelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema, false);
        String tableName = modelTable.getName();
        String appProd = model.getAppInfo().getProd();
        String eaiIdOfServiceMapping = BMDataEaiServiceNameUtil.getEaiIdOfServiceMapping(tableName, appProd);
        log.debug("[ModelSqlGenerator][generateInsertServiceMappingSql] *** BMD *** get eaiIdOfServiceMapping {}", (Object)eaiIdOfServiceMapping);
        String targetProd = model.getAppInfo().getTargetProd();
        String bmInsertServiceMappingSql = "insert into dw_service_mapping(table_name, expose_eai_id, target_prod) values(?, ?, ?) ON DUPLICATE KEY UPDATE table_name=? , expose_eai_id=? , target_prod=?";
        SqlParam returnValue = new SqlParam(bmInsertServiceMappingSql, new Object[]{tableName, eaiIdOfServiceMapping, targetProd, tableName, eaiIdOfServiceMapping, targetProd});
        return returnValue;
    }

    public static SqlParam generateDeleteServiceMappingSql(ModelTable modelTable) {
        String tableName = modelTable.getName();
        String deleteRdbmsTableSql = String.format("delete from %s where table_name = ?", "dw_service_mapping");
        return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName});
    }

    public static SqlParam generateInsertModelSql(ModelDTO model) {
        String code = model.getCode();
        String modelSchemaStr = ModelDataUtil.getModelSchemaJsonData();
        String tenantSidColumnName = DWTenantUtils.getTenantColumnName();
        Object tenantSid = DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey());
        Object tenantUserSid = DWServiceContext.getContext().getProfile().get("userSid");
        String insertServiceMappingSql = String.format("insert into dw_lcdp_model (code, description, model_schema, target_tenant_id, app_id, %s , create_user_sid , create_time ) values(?, ?, ?, ?, ?, ?, ? ,?)", tenantSidColumnName);
        return new SqlParam(insertServiceMappingSql, new Object[]{code, model.getDescription(), modelSchemaStr, model.getTargetTenantId(), model.getAppId(), tenantSid, tenantUserSid, new Date()});
    }

    public static LinkedList<SqlParam> generateUpdateModelInfoSql(List<ModelTable> modelTables, String code) {
        LinkedList<SqlParam> updateSqlParams = ModelSqlGenerator.generateDeleteModelInfoSql(code);
        updateSqlParams.addAll(ModelSqlGenerator.generateInsertModelInfoSql(modelTables, code));
        return updateSqlParams;
    }

    public static LinkedList<SqlParam> generateDeleteModelInfoSql(String code) {
        String tenantSidColumnName = DWTenantUtils.getTenantColumnName();
        Object tenantSid = DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey());
        String appId = ApTokenUtil.getCurrentAppId();
        String insertModelInfoSql = String.format("delete from dw_lcdp_model_info where code=? and app_id=? and %s=?", tenantSidColumnName);
        Object[] sqlParamParams = new Object[]{code, appId, tenantSid};
        SqlParam sqlParam = new SqlParam(insertModelInfoSql, sqlParamParams);
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        sqlParams.add(sqlParam);
        return sqlParams;
    }

    public static List<SqlParam> generateInsertModelInfoSql(List<ModelTable> modelTables, String code) {
        ArrayList<SqlParam> sqlParams = new ArrayList<SqlParam>();
        for (ModelTable modelTable : modelTables) {
            SqlParam sqlParam = ModelSqlGenerator.generateInsertModelInfoSql(modelTable, code);
            sqlParams.add(sqlParam);
        }
        return sqlParams;
    }

    public static SqlParam generateInsertModelInfoSql(ModelTable modelTable, String code) {
        String tenantSidColumnName = DWTenantUtils.getTenantColumnName();
        Object tenantSid = DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey());
        String tenantId = ApTokenUtil.getCurrentTenantId();
        Object tenantUserSid = DWServiceContext.getContext().getProfile().get("userSid");
        String appId = ApTokenUtil.getCurrentAppId();
        String tableName = modelTable.getName();
        String insertModelInfoSql = String.format("insert into dw_lcdp_model_info (code, table_name, app_id, tenant_id, create_user_sid, create_time, %s ) values( ?, ?, ?, ?, ?, ?, ? ) ON DUPLICATE KEY UPDATE app_id=?, tenant_id=?, update_user_sid=?, %s =? ", tenantSidColumnName, tenantSidColumnName);
        Object[] sqlParamParams = new Object[]{code, tableName, appId, tenantId, tenantUserSid, new Date(), tenantSid, appId, tenantId, tenantUserSid, tenantSid};
        SqlParam sqlParam = new SqlParam(insertModelInfoSql, sqlParamParams);
        return sqlParam;
    }

    public static List<SqlParam> generateUpdateModelSql(ModelDTO model) {
        String code = model.getCode();
        String modelSchemaStr = ModelDataUtil.getModelSchemaJsonData();
        Object tenantUserSid = DWServiceContext.getContext().getProfile().get("userSid");
        Object[] params = new Object[]{model.getDescription(), modelSchemaStr, tenantUserSid, code, model.getAppId()};
        String updateModelSql = "update dw_lcdp_model set description=?, model_schema=? , update_user_sid=? where code=? and app_id=? ";
        SqlParam modelSqlParam = new SqlParam(updateModelSql, params);
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        returnValue.add(modelSqlParam);
        return returnValue;
    }

    public static SqlParam generateUpdateRdbmsTableSql(ModelTable modelTable) {
        String updateRdbmsTableSql = "update dw_rdbms_tables  set table_display_name = ? , table_description = ? where table_name = ?";
        return new SqlParam(updateRdbmsTableSql, new Object[]{modelTable.getComment(), modelTable.getComment(), modelTable.getName()});
    }

    public static SqlParam generateUpdateRdbmsFieldSql(String tableName, TableColumn tableColumn) {
        String isPk = ModelSqlGenerator.booleanToYN(tableColumn.isPK());
        String defaultValue = tableColumn.getDefaultValue() != null ? tableColumn.getDefaultValue() : "null";
        Integer size = ModelSqlGenerator.getUpdateSize(tableColumn.getSize(), tableColumn.getDataType().getDefaultSize());
        Integer scale = ModelSqlGenerator.getUpdateSize(tableColumn.getScale(), tableColumn.getDataType().getDefaultScale());
        String nullable = ModelSqlGenerator.booleanToYN(tableColumn.nullable());
        String autoIncrement = ModelSqlGenerator.booleanToYN(tableColumn.getAutoIncrement() != false || tableColumn.getAutoIncrement() != false);
        String updateRdbmsFieldSql = "update dw_rdbms_fields  set field_name = ?, is_key = ?, field_type = ? , field_display_name = ?, default_value = ?, nullable = ?, size = ? , scale = ? , is_auto_increment = ? where table_name = ? and field_name = ?";
        return new SqlParam(updateRdbmsFieldSql, new Object[]{tableColumn.getColumnName(), isPk, tableColumn.getDataType().getName(), tableColumn.getComment(), defaultValue, nullable, size, scale, autoIncrement, tableName, tableColumn.getColumnName()});
    }

    public static SqlParam generateUpdateRdbmsFieldRemovePrimarySql(String tableName) {
        String updateRdbmsFieldSql = "update dw_rdbms_fields set is_key = ? where table_name = ?";
        return new SqlParam(updateRdbmsFieldSql, new Object[]{"N", tableName});
    }

    public static SqlParam generateInsertOrUpdateRdbmsFieldWithRemoveAutoIncrementSql(String tableName, TableColumn tableColumn) {
        String insertRdbmsFieldSql = "insert into dw_rdbms_fields (table_name, seq, field_name, field_display_name, nullable, is_auto_increment)  values (?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE table_name=?, default_value=?, nullable=?, is_auto_increment=?";
        Object[] sqlParamParams = new Object[]{tableName, 0, tableColumn.getColumnName(), tableColumn.getColumnName(), "N", "N", tableName, null, "N", "N"};
        return new SqlParam(insertRdbmsFieldSql, sqlParamParams);
    }

    public static SqlParam generateDeleteRdbmsTableSql(String tableName) {
        String deleteRdbmsTableSql = "delete from dw_rdbms_tables where table_name = ?";
        return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName});
    }

    public static SqlParam generateDeleteRdbmsFieldSql(ModelTable modelTable) {
        String tableName = modelTable.getName();
        String deleteRdbmsFieldSql = "delete from dw_rdbms_fields where table_name = ?";
        return new SqlParam(deleteRdbmsFieldSql, new Object[]{tableName});
    }

    public static SqlParam generateDeleteRdbmsFieldSql(String tableName, String columnName) {
        if (columnName == null || columnName.isEmpty()) {
            String deleteRdbmsTableSql = "delete from dw_rdbms_fields where table_name = ?";
            return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName});
        }
        String deleteRdbmsTableSql = "delete from dw_rdbms_fields where table_name = ? and field_name = ?";
        return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName, columnName});
    }

    public static SqlParam generateDeleteRdbmsRelationForChildTableSql(String primaryTableName, String childTableName) {
        String sql = "delete from dw_rdbms_relations where primary_table_no = ? and reference_table_no = ?";
        return new SqlParam(sql, new Object[]{primaryTableName, childTableName});
    }

    public static String generatePrimaryKeys(List<TableColumn> customColumns) {
        String sql = "PRIMARY KEY (%s)";
        return String.format(sql, customColumns.stream().filter(com.digiwin.app.ddl.model.Field::isPK).map(customColumn -> "`" + customColumn.getColumnName() + "`").collect(Collectors.joining(",")));
    }

    public static String generateConstrainChainValue(List<String> tablePks) {
        String returnValue = tablePks.stream().map(customColumn -> "`" + customColumn + "`").collect(Collectors.joining(","));
        return returnValue;
    }

    private static String generateIndexes(List<TableIndex> indexes) {
        String indexSql = indexes.stream().map(tableIndex -> ModelSqlGenerator.generateIndexes(tableIndex)).collect(Collectors.joining(","));
        return indexSql;
    }

    public static String generateIndexes(TableIndex tableIndex) {
        String indexCommand = tableIndex.getType().getIndexCommandChar();
        String indexName = tableIndex.getName();
        String memberStr = tableIndex.getMember().stream().map(member -> "`" + member + "`").collect(Collectors.joining(","));
        String conditionSql = String.format(" %s `%s` ( %s ) ", indexCommand, indexName, memberStr);
        return conditionSql;
    }

    private static String booleanToYN(boolean bool) {
        return bool ? "Y" : "N";
    }

    private static String columnUniqueValue(boolean bool) {
        return bool ? "UNIQUE" : "";
    }

    public static ColumnNullableEnum getNullableEnum(boolean bool) {
        return bool ? ColumnNullableEnum.NULL : ColumnNullableEnum.NOT_NULL;
    }

    public static Integer getUpdateSize(Integer updatedInteger, Integer defaultInteger) {
        if (Objects.isNull(updatedInteger)) {
            if (Objects.isNull(defaultInteger)) {
                return 0;
            }
            return defaultInteger;
        }
        return updatedInteger;
    }

    public static String getTypeDDL(TableColumn field) {
        DataTypeEnum dataType = field.getDataType();
        String type = dataType.getType();
        String name = dataType.getName();
        Integer size = field.getSize();
        if (Objects.isNull(size)) {
            size = dataType.getDefaultSize();
        }
        String[] dataTypeNameWithoutSize = new String[]{"JSON", "LONGTEXT", "TEXT"};
        if ("TEXT".equals(type)) {
            if (Arrays.stream(dataTypeNameWithoutSize).anyMatch(name::equals)) {
                return name + " ";
            }
        }
        String[] timeTypeNameWithSize = new String[]{"DATETIME", "TIME", "TIMESTAMP"};
        if ("TIME".equals(type) && Arrays.stream(timeTypeNameWithSize).anyMatch(timeType -> name.equals(timeType) && field.getSize() != null)) {
            return String.format("%s(%s) ", name, size);
        }
        if ("TIME".equals(type)) {
            return name + " ";
        }
        if ("REAL".equals(type)) {
            Integer scale = field.getScale();
            if (Objects.isNull(scale)) {
                scale = dataType.getDefaultScale();
            }
            return String.format("%s(%s,%s) ", name, size, scale);
        }
        return String.format("%s(%s) ", name, size);
    }

    public static String getCombinedSql(SqlParam sqlParam) throws JSQLParserException {
        String sql = sqlParam.getSql();
        Object[] params = sqlParam.getParams();
        Statement statement = CCJSqlParserUtil.parse((String)sql, null);
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            ItemsList itemsList = insert.getItemsList();
            List duplicateUpdateExpressionList = insert.getDuplicateUpdateExpressionList();
            if (itemsList instanceof ExpressionList) {
                Object value;
                int i;
                ExpressionList list = (ExpressionList)itemsList;
                List listExp = list.getExpressions();
                int paramIndex = 0;
                for (Expression expression : listExp) {
                    if (expression instanceof JdbcParameter) {
                        i = ((JdbcParameter)expression).getIndex();
                        value = params[i - 1];
                        sql = sql.replaceFirst("\\?", value == null ? "null" : (value instanceof String ? "'" + value + "'" : (value instanceof Date ? "'" + bindedSqlDateTimeFormat.format(value) + "'" : value.toString())));
                        log.debug("process paramIndex({}) org({}) , new({}), new sql({})", new Object[]{paramIndex, "?", value == null ? "null" : "'" + value.toString() + "'", sql});
                    } else if (expression instanceof StringValue) {
                        SimpleNode node = expression.getASTNode();
                        log.debug("process paramIndex({}) node({})", (Object)paramIndex, node.jjtGetValue());
                    } else if (expression instanceof NullValue) {
                        log.debug("process paramIndex({}) node({})", (Object)paramIndex, (Object)"NULL/null");
                    }
                    ++paramIndex;
                }
                if (CollectionUtils.isNotEmpty((Collection)duplicateUpdateExpressionList)) {
                    int paramLength = list.getExpressions().stream().filter(item -> item.toString().equals("?")).toArray().length;
                    int duplicateUpdateLenthg = duplicateUpdateExpressionList.stream().filter(item -> item.toString().equals("?")).toArray().length;
                    for (i = 0; i < duplicateUpdateLenthg; ++i) {
                        value = params[paramLength + i];
                        sql = sql.replaceFirst("\\?", value == null ? "null" : (value instanceof String ? "'" + value + "'" : (value instanceof Date ? "'" + bindedSqlDateTimeFormat.format(value) + "'" : value.toString())));
                    }
                }
            }
        }
        if (statement instanceof Select) {
            int i = 0;
            while (sql.indexOf("?") != -1) {
                Object value = params[i];
                ++i;
                sql = sql.replaceFirst("\\?", value == null ? "null" : (value instanceof String ? "'" + value + "'" : (value instanceof Date ? "'" + bindedSqlDateTimeFormat.format(value) + "'" : value.toString())));
            }
        }
        return sql;
    }

    public static Map<String, Object> getModelSql(ModelDTO model) throws Exception {
        List<ModelSchemaDTO> childrenModelSchema;
        List<ModelSchemaDTO> childrenSchemas;
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        ModelSchemaDTO modelSchema = model.getSchema();
        String code = model.getCode();
        ArrayList sqlList = new ArrayList();
        ArrayList<String> bindedSql = new ArrayList<String>();
        SqlParam createModelSqlParam = ModelSqlGenerator.generateInsertModelSql(model);
        bindedSql.add(ModelSqlGenerator.getCombinedSql(createModelSqlParam));
        ModelTable mainModelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema, false);
        SqlParam createMainModelInfoSqlParam = ModelSqlGenerator.generateInsertModelInfoSql(mainModelTable, model.getCode());
        bindedSql.add(ModelSqlGenerator.getCombinedSql(createMainModelInfoSqlParam));
        SqlParam createServiceMappingSqlParam = new SqlParam();
        BMProperties bmProperties = BMProperties.getProperties();
        createServiceMappingSqlParam = bmProperties != null && bmProperties.isEnabled() && bmProperties.getRole() == BMRole.bmd ? BMDataModelSqlGenerator.generateInsertServiceMappingSql() : ModelSqlGenerator.generateInsertServiceMappingSql(mainModelTable);
        bindedSql.add(ModelSqlGenerator.getCombinedSql(createServiceMappingSqlParam));
        SqlParam createTableSqlParam = ModelSqlGenerator.generateCreateTableSql(mainModelTable);
        bindedSql.add(createTableSqlParam.getSql());
        SqlParam insertRdbmsTableSqlParam = ModelSqlGenerator.generateInsertRdbmsTableSql(mainModelTable);
        bindedSql.add(ModelSqlGenerator.getCombinedSql(insertRdbmsTableSqlParam));
        List<SqlParam> insertRdbmsFieldSqlParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(mainModelTable);
        if (CollectionUtils.isNotEmpty(insertRdbmsFieldSqlParam)) {
            insertRdbmsFieldSqlParam.forEach(sqlParam -> {
                try {
                    bindedSql.add(ModelSqlGenerator.getCombinedSql(sqlParam));
                }
                catch (JSQLParserException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(childrenSchemas = modelSchema.getChildren()) && CollectionUtils.isNotEmpty(childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas))) {
            for (ModelSchemaDTO childModelSchemaDTO : childrenModelSchema) {
                ModelTable childModelTable = ModelSchemaUtil.getCurrentLevelModelTable(childModelSchemaDTO, false);
                SqlParam createClildTableSqlParam = ModelSqlGenerator.generateCreateTableSql(childModelTable);
                bindedSql.add(createClildTableSqlParam.getSql());
                SqlParam insertClildModelInfoSqlParam = ModelSqlGenerator.generateInsertModelInfoSql(childModelTable, code);
                bindedSql.add(ModelSqlGenerator.getCombinedSql(insertClildModelInfoSqlParam));
                SqlParam insertChildRdbmsTableSqlParam = ModelSqlGenerator.generateInsertRdbmsTableSql(childModelTable);
                bindedSql.add(ModelSqlGenerator.getCombinedSql(insertChildRdbmsTableSqlParam));
                List<SqlParam> insertChildRdbmsFieldSqlParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(childModelTable);
                if (!CollectionUtils.isNotEmpty(insertRdbmsFieldSqlParam)) continue;
                insertChildRdbmsFieldSqlParam.forEach(sqlParam -> {
                    try {
                        bindedSql.add(ModelSqlGenerator.getCombinedSql(sqlParam));
                    }
                    catch (JSQLParserException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        returnValue.put(code, sqlList);
        returnValue.put("bindedSql", bindedSql);
        return returnValue;
    }

    public static String getSqlByAutoIncrementOrDefaultValue(TableColumn tableColumn) {
        String autoIncrementString = ModelSqlGenerator.getSqlByAutoIncrementOrDefaultValue(tableColumn, false);
        return autoIncrementString;
    }

    public static String getSqlByAutoIncrementOrDefaultValue(TableColumn tableColumn, boolean isModifyColumn) {
        String autoIncrementCmd = ModelSqlGenerator.getAutoIncrementAndPrimaryKeyByAction(isModifyColumn);
        String autoIncrementString = tableColumn.getAutoIncrement() != false ? autoIncrementCmd : ModelSqlGenerator.getDefaultValue(tableColumn);
        return autoIncrementString;
    }

    public static String getAutoIncrementAndPrimaryKeyByAction(boolean isModifyColumn) {
        String autoIncrementCmd = "AUTO_INCREMENT";
        if (isModifyColumn) {
            autoIncrementCmd = autoIncrementCmd + " " + "PRIMARY KEY";
        }
        return autoIncrementCmd;
    }

    public static String getDefaultValue(TableColumn tableColumn) {
        return tableColumn.getDataType() == DataTypeEnum.BIT ? (tableColumn.getDefaultValue() != null ? (tableColumn.getDefaultValue().toUpperCase().equals("1") ? "DEFAULT TRUE" : "DEFAULT FALSE") : "") : (tableColumn.getDefaultValue() != null ? "DEFAULT '" + (tableColumn.getDefaultValue().equals("\"\"") ? "" : tableColumn.getDefaultValue()) + "'" : "");
    }

    public static String getCollation(DataTypeEnum dataType, boolean existedTable, AlterColumnEnum alterColumnEnum) {
        String returnValue = "";
        String name = dataType.getName();
        String type = dataType.getType();
        if (existedTable && alterColumnEnum == AlterColumnEnum.MODIFY_COLUMN) {
            if (!Arrays.stream(ModelDBConstants.MYSQL_SQL_COLLATE_IGNORE_DATA_NAME).anyMatch(name::equals)) {
                if (!Arrays.stream(ModelDBConstants.MYSQL_SQL_COLLATE_IGNORE_DATA_TYPE).anyMatch(type::equals)) {
                    returnValue = String.format(" COLLATE '%s' ", "utf8mb4_bin");
                }
            }
        }
        return returnValue;
    }

    public static String getDefaultValue(TableColumn tableColumn, boolean existedTable) {
        if (existedTable) {
            String columnName = tableColumn.getColumnName();
            if (columnName.equals("create_date")) {
                return "DEFAULT current_timestamp()";
            }
            if (columnName.equals("modified_date")) {
                return "DEFAULT NULL ON UPDATE current_timestamp()";
            }
        }
        return ModelSqlGenerator.getDefaultValue(tableColumn);
    }

    public static TableSqlParamDTO getCreateTable(ModelTable modelTable) {
        TableSqlParamDTO tableSqlParamDTO = new TableSqlParamDTO();
        SqlParam createRdbmsTableParam = ModelSqlGenerator.generateInsertRdbmsTableSql(modelTable);
        tableSqlParamDTO.getDmlSqlParams().add(createRdbmsTableParam);
        List<SqlParam> createRdbmsFieldsParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(modelTable);
        tableSqlParamDTO.getDmlSqlParams().addAll(createRdbmsFieldsParam);
        SqlParam createTableSqlParam = ModelSqlGenerator.generateCreateTableSql(modelTable);
        tableSqlParamDTO.getDdlSqlParams().add(createTableSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Insert Rdbms SQL: {}", (Object)modelTable.getName(), (Object)tableSqlParamDTO.toString());
            log.debug(">>>>> gen Create Table SQL: {}", (Object)modelTable.getName(), (Object)createTableSqlParam);
        }
        return tableSqlParamDTO;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getDropChildTables(List<ModelTable> childTableNames) {
        LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        for (ModelTable modelTable : childTableNames) {
            ArrayList<SqlParam> dmlSqlParams = new ArrayList<SqlParam>();
            ArrayList<SqlParam> ddlSqlParams = new ArrayList<SqlParam>();
            LinkedHashMap<String, ArrayList<SqlParam>> childDDMLValue = new LinkedHashMap<String, ArrayList<SqlParam>>();
            String childTableName = modelTable.getName();
            SqlParam deleteRdbmsTableParam = ModelSqlGenerator.generateDeleteRdbmsTableSql(childTableName);
            dmlSqlParams.add(deleteRdbmsTableParam);
            SqlParam deleteRdbmsFieldsParam = ModelSqlGenerator.generateDeleteRdbmsFieldSql(modelTable);
            dmlSqlParams.add(deleteRdbmsFieldsParam);
            childDDMLValue.put("dml", dmlSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Delete Rdbms Table Params: modelTable = {}", (Object)childTableName);
                log.debug(">>>>> gen Delete Rdbms Table SQL: {}", (Object)deleteRdbmsTableParam);
                log.debug(">>>>> gen Delete Rdbms Fields Params: modelTable = {}", (Object)modelTable.getName());
                log.debug(">>>>> gen Delete Rdbms Fields SQL: {}", dmlSqlParams);
            }
            SqlParam dropTableSqlParam = ModelSqlGenerator.generateDropTableSql(childTableName);
            ddlSqlParams.add(dropTableSqlParam);
            childDDMLValue.put("ddl", ddlSqlParams);
            returnValue.put(childTableName, childDDMLValue);
        }
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getCreateChildTablesCommand(String primaryTableName, String primaryKeyName, List<ModelTable> childrenTables, String foreignKeyName) {
        LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        for (ModelTable modelTable : childrenTables) {
            LinkedHashMap childDDMLValue = new LinkedHashMap();
            String childTableName = modelTable.getName();
            ArrayList<SqlParam> dmlSqlParams = new ArrayList<SqlParam>();
            ArrayList<SqlParam> ddlSqlParams = new ArrayList<SqlParam>();
            SqlParam insertRdbmsTableParam = ModelSqlGenerator.generateInsertRdbmsTableSql(modelTable);
            dmlSqlParams.add(insertRdbmsTableParam);
            List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(modelTable);
            dmlSqlParams.addAll(insertOrUpdateRdbmsFieldsParam);
            childDDMLValue.put("dml", dmlSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Insert Rdbms Table Params: modelTable = {}", (Object)modelTable.getName());
                log.debug(">>>>> gen Insert Rdbms Table SQL: {}", (Object)insertRdbmsTableParam);
                log.debug(">>>>> gen Insert Rdbms Fields Params: modelTable = {}", (Object)modelTable);
                log.debug(">>>>> gen Insert Rdbms Fields SQL: {}", dmlSqlParams);
            }
            SqlParam createTableSqlParam = ModelSqlGenerator.generateCreateTableSql(modelTable);
            ddlSqlParams.add(createTableSqlParam);
            childDDMLValue.put("ddl", ddlSqlParams);
            returnValue.put(childTableName, childDDMLValue);
        }
        return returnValue;
    }

    public static Map<String, Object> getAlterIndexesInfo(String tableName, AlterIndexEnum alterIndexEnum, List<TableIndex> tableIndexes, LinkedList<SqlParam> alterDDLSqlParam) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        tableIndexes.forEach(tableIndex -> {
            LinkedList<Object> alterTableSqlParams = new LinkedList();
            alterTableSqlParams = ModelSqlGenerator.generateAlterIndexSql(tableName, alterIndexEnum, tableIndex);
            alterDDLSqlParam.addAll(alterTableSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter indexes Params: tableName = {}, alterIndexEnum = {}, tableIndex = {}", new Object[]{tableName, alterIndexEnum, tableIndex});
                log.debug(">>>>> gen Alter indexes SQL: {}", alterTableSqlParams);
            }
        });
        return returnValue;
    }

    public static LinkedHashMap<String, List<SqlParam>> getAlterTableInfo(ModelTable modelTable) {
        LinkedHashMap<String, List<SqlParam>> returnValue = new LinkedHashMap<String, List<SqlParam>>();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        returnValue.put("dml", alterDMLSqlParam);
        returnValue.put("ddl", alterDDLSqlParam);
        String tableName = modelTable.getName();
        String tableComment = modelTable.getComment();
        SqlParam alterTableSqlParam = ModelSqlGenerator.generateAlterTableSql(tableName, tableComment);
        alterDDLSqlParam.add(alterTableSqlParam);
        SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateUpdateRdbmsTableSql(modelTable);
        alterDMLSqlParam.add(alterRdbmsSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Table Params: tableName = {}, tableComment = {} ", (Object)tableName, (Object)tableComment);
            log.debug(">>>>> gen Alter Table SQL: {}", (Object)alterTableSqlParam);
            log.debug(">>>>> gen Update Rdbms Tables Params: customTables = {}", (Object)modelTable);
            log.debug(">>>>> gen Update Rdbms Tables SQL: sql = {}, params = {}", (Object)alterRdbmsSqlParam.getSql(), (Object)alterRdbmsSqlParam.getParams());
        }
        return returnValue;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getAlterColumnUniqueIndexes(List<ModelFieldDTO> draftModelFields, List<ModelFieldDTO> publishedModelFields) {
        log.debug("getAlterColumnUniqueIndexes");
        List addColumnUniqueIndexByModify = draftModelFields.stream().filter(draftModelField -> ModelSchemaUtil.checkRelatedType(draftModelField) && !draftModelField.getAutoIncrement() && !ModelDBConstants.UNIQUE_INDEX_EXCLUDED_DATATYPE.contains(draftModelField.getFieldType()) && publishedModelFields.stream().anyMatch(publishedModelField -> Objects.equals(draftModelField.getFieldId(), publishedModelField.getFieldId()) && draftModelField.getUnique() && !publishedModelField.getUnique())).map(ModelSchemaUtil::convertModelFieldToTableUniqueIndex).collect(Collectors.toList());
        List dropColumnUniqueIndexByModify = draftModelFields.stream().filter(draftModelField -> ModelSchemaUtil.checkRelatedType(draftModelField) && !draftModelField.getAutoIncrement() && !ModelDBConstants.UNIQUE_INDEX_EXCLUDED_DATATYPE.contains(draftModelField.getFieldType()) && publishedModelFields.stream().anyMatch(publishedModelField -> Objects.equals(draftModelField.getFieldId(), publishedModelField.getFieldId()) && !draftModelField.getUnique() && publishedModelField.getUnique())).map(ModelSchemaUtil::convertModelFieldToTableUniqueIndex).collect(Collectors.toList());
        HashMap<AlterIndexEnum, List<TableIndex>> alterColumnUniqueIndexes = new HashMap<AlterIndexEnum, List<TableIndex>>();
        alterColumnUniqueIndexes.put(AlterIndexEnum.ADD, addColumnUniqueIndexByModify);
        alterColumnUniqueIndexes.put(AlterIndexEnum.DROP, dropColumnUniqueIndexByModify);
        if (log.isDebugEnabled()) {
            log.debug("publishing model (comparing fields) ->  modifyIndexes = {}, dropIndexes = {}", addColumnUniqueIndexByModify.stream().map(idx -> idx.getName()).collect(Collectors.toList()), dropColumnUniqueIndexByModify.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        }
        return alterColumnUniqueIndexes;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getAlterIndexesMap(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema) {
        List<TableIndex> dropColumnUniqueIndexes;
        if (draftModelSchema == null || CollectionUtils.isEmpty(draftModelSchema.getFields()) || publishedModelSchema == null || CollectionUtils.isEmpty(publishedModelSchema.getFields())) {
            return null;
        }
        List<ModelIndexDTO> draftModelIndexes = draftModelSchema.getIndex();
        List<ModelIndexDTO> publishedModelIndexes = publishedModelSchema.getIndex();
        log.debug("[getAlterIndexesMap] comparing indexes -> draftModelIndexes = {}, publishedModelIndexes = {}", draftModelIndexes, publishedModelIndexes);
        List addIndexes = draftModelIndexes.stream().filter(draftModelIndex -> publishedModelIndexes.stream().noneMatch(publishedModelIndex -> Objects.equals(draftModelIndex.getId(), publishedModelIndex.getId()))).map(ModelSchemaUtil::convertModelIndexToTableIndex).collect(Collectors.toList());
        List modifyIndexes = draftModelIndexes.stream().filter(draftModelIndex -> publishedModelIndexes.stream().anyMatch(publishedModelIndex -> Objects.equals(draftModelIndex.getId(), publishedModelIndex.getId()) && !draftModelIndex.equals(publishedModelIndex))).map(ModelSchemaUtil::convertModelIndexToTableIndex).collect(Collectors.toList());
        List dropIndexes = publishedModelIndexes.stream().filter(publishedModelIndex -> draftModelIndexes.stream().noneMatch(draftModelIndex -> Objects.equals(publishedModelIndex.getId(), draftModelIndex.getId()))).map(ModelSchemaUtil::convertModelIndexToTableIndex).collect(Collectors.toList());
        Map<AlterIndexEnum, List<TableIndex>> alterColumnsUniqueMap = ModelSqlGenerator.getAlterColumnUniqueIndexes(draftModelSchema.getFields(), publishedModelSchema.getFields());
        List<TableIndex> addColumnUniqueIndexes = alterColumnsUniqueMap.get((Object)AlterIndexEnum.ADD);
        if (CollectionUtils.isNotEmpty(addColumnUniqueIndexes)) {
            addIndexes.addAll(addColumnUniqueIndexes);
        }
        if (CollectionUtils.isNotEmpty(dropColumnUniqueIndexes = alterColumnsUniqueMap.get((Object)AlterIndexEnum.DROP))) {
            dropIndexes.addAll(dropColumnUniqueIndexes);
        }
        HashMap<AlterIndexEnum, List<TableIndex>> alterTableIndexesMap = new HashMap<AlterIndexEnum, List<TableIndex>>();
        alterTableIndexesMap.put(AlterIndexEnum.ADD, addIndexes);
        alterTableIndexesMap.put(AlterIndexEnum.MODIFY, modifyIndexes);
        alterTableIndexesMap.put(AlterIndexEnum.DROP, dropIndexes);
        if (log.isDebugEnabled()) {
            log.debug("publishing model table({}) (comparing indexes) -> addIndexes = {}, modifyIndexes = {}, dropIndexes = {}", new Object[]{draftModelSchema.getName(), addIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), modifyIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), dropIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList())});
        }
        return alterTableIndexesMap;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getExistedTableAlterIndexesMap(List<TableIndex> draftTableIndexes, List<TableIndex> existedTableIndexes, List<TableColumn> draftTableFields, List<TableColumn> existedTableFields) {
        List<TableIndex> dropUniqueIndexesFromColumn;
        List<TableIndex> modifyUniqueIndexesFromColumn;
        if (log.isDebugEnabled()) {
            log.debug("publishing model (comparing indexes) -> draftModelIndexes = {}, existedTableIndexes = {}", draftTableIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), existedTableIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        }
        List addIndexes = draftTableIndexes.stream().filter(draftModelIndex -> existedTableIndexes.stream().noneMatch(existedTableIndex -> Objects.equals(DBTableUtil.removeBackQuoteSymbol(draftModelIndex.getName()), DBTableUtil.removeBackQuoteSymbol(existedTableIndex.getName())))).collect(Collectors.toList());
        List modifyIndexes = draftTableIndexes.stream().filter(draftModelIndex -> existedTableIndexes.stream().anyMatch(existedTableIndex -> Objects.equals(DBTableUtil.removeBackQuoteSymbol(draftModelIndex.getName()), DBTableUtil.removeBackQuoteSymbol(existedTableIndex.getName())) && !Objects.equals(draftModelIndex, existedTableIndex))).collect(Collectors.toList());
        ArrayList<TableIndex> dropIndexes = new ArrayList<TableIndex>();
        Map<AlterIndexEnum, List<TableIndex>> alterColumnsUniqueMap = ModelSqlGenerator.getExistedTableAlterColumnUniqueIndexes(draftTableFields, existedTableFields);
        List<TableIndex> addUniqueIndexesFromColumn = alterColumnsUniqueMap.get((Object)AlterIndexEnum.ADD);
        if (CollectionUtils.isNotEmpty(addUniqueIndexesFromColumn)) {
            addIndexes.addAll(addUniqueIndexesFromColumn);
        }
        if (CollectionUtils.isNotEmpty(modifyUniqueIndexesFromColumn = alterColumnsUniqueMap.get((Object)AlterIndexEnum.MODIFY))) {
            modifyIndexes.addAll(modifyUniqueIndexesFromColumn);
        }
        if (CollectionUtils.isNotEmpty(dropUniqueIndexesFromColumn = alterColumnsUniqueMap.get((Object)AlterIndexEnum.DROP))) {
            dropIndexes.addAll(dropUniqueIndexesFromColumn);
        }
        HashMap<AlterIndexEnum, List<TableIndex>> alterTableIndexesMap = new HashMap<AlterIndexEnum, List<TableIndex>>();
        alterTableIndexesMap.put(AlterIndexEnum.ADD, addIndexes);
        alterTableIndexesMap.put(AlterIndexEnum.MODIFY, modifyIndexes);
        alterTableIndexesMap.put(AlterIndexEnum.DROP, dropIndexes);
        log.debug("publishing model (comparing model indexes) -> addIndexes = {}, modifyIndexes = {}, dropIndexes = {}", new Object[]{addIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), modifyIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), dropIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList())});
        return alterTableIndexesMap;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getExistedTableAlterColumnUniqueIndexes(List<TableColumn> draftTableColumns, List<TableColumn> existedTableColumns) {
        log.debug("[ModelSqlGenerator] getAlterColumnUniqueIndexes");
        List addColumnUniqueIndexByModify = draftTableColumns.stream().filter(draftTableColumn -> ModelSchemaUtil.checkRelatedType(draftTableColumn) && draftTableColumn.getAutoIncrement() == false && !ModelDBConstants.UNIQUE_INDEX_EXCLUDED_DATATYPE.contains(draftTableColumn.getDataType().getName()) && BooleanUtils.isTrue((Boolean)draftTableColumn.getUnique()) && existedTableColumns.stream().anyMatch(existedTableColumn -> Objects.equals(DBTableUtil.removeBackQuoteSymbol(draftTableColumn.getColumnName()), DBTableUtil.removeBackQuoteSymbol(existedTableColumn.getColumnName())) && BooleanUtils.isFalse((Boolean)existedTableColumn.getUnique()))).map(ModelSchemaUtil::convertTableColumnToTableUniqueIndex).collect(Collectors.toList());
        List dropColumnUniqueIndexByModify = draftTableColumns.stream().filter(draftTableColumn -> ModelSchemaUtil.checkRelatedType(draftTableColumn) && draftTableColumn.getAutoIncrement() == false && !ModelDBConstants.UNIQUE_INDEX_EXCLUDED_DATATYPE.contains(draftTableColumn.getDataType().getName()) && BooleanUtils.isFalse((Boolean)draftTableColumn.getUnique()) && existedTableColumns.stream().anyMatch(existedTableColumn -> Objects.equals(DBTableUtil.removeBackQuoteSymbol(draftTableColumn.getColumnName()), DBTableUtil.removeBackQuoteSymbol(existedTableColumn.getColumnName())) && BooleanUtils.isTrue((Boolean)existedTableColumn.getUnique()))).map(ModelSchemaUtil::convertTableColumnToTableUniqueIndex).collect(Collectors.toList());
        HashMap<AlterIndexEnum, List<TableIndex>> alterColumnUniqueIndexes = new HashMap<AlterIndexEnum, List<TableIndex>>();
        alterColumnUniqueIndexes.put(AlterIndexEnum.ADD, addColumnUniqueIndexByModify);
        alterColumnUniqueIndexes.put(AlterIndexEnum.DROP, dropColumnUniqueIndexByModify);
        if (log.isDebugEnabled()) {
            log.debug("publishing model (comparing column unique index) ->  add = {}, drop = {}", addColumnUniqueIndexByModify.stream().map(idx -> idx.getName()).collect(Collectors.toList()), dropColumnUniqueIndexByModify.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        }
        return alterColumnUniqueIndexes;
    }

    public static SqlParam getDropPrimaryKeySql(String tableName) {
        String dropPrimaryKeySql = String.format("ALTER TABLE `%s` DROP PRIMARY KEY", tableName);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)tableName, (Object)dropPrimaryKeySql);
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropPrimaryKeySql);
        sqlParam.setParams(new Object[0]);
        return sqlParam;
    }

    public static SqlParam getAddPrimaryKeyOnly(ModelTable modelTable) {
        String primaryKeysSql = ModelSqlGenerator.generatePrimaryKeys(modelTable.getColumns());
        String dropAndAddTablePrimarySql = String.format("ALTER TABLE `%s` ADD %s ", modelTable.getName(), primaryKeysSql);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)modelTable.getName(), (Object)dropAndAddTablePrimarySql);
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropAndAddTablePrimarySql);
        sqlParam.setParams(new Object[0]);
        return sqlParam;
    }

    public static SqlParam getAlterPrimaryKeySql(ModelTable modelTable) {
        String primaryKeysSql = ModelSqlGenerator.generatePrimaryKeys(modelTable.getColumns());
        String dropAndAddTablePrimarySql = String.format("ALTER TABLE `%s` DROP PRIMARY KEY, ADD %s ", modelTable.getName(), primaryKeysSql);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)modelTable.getName(), (Object)dropAndAddTablePrimarySql);
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropAndAddTablePrimarySql);
        sqlParam.setParams(new Object[0]);
        return sqlParam;
    }

    public static List<SqlParam> getAlterPrimaryKeySql(ModelTable draftSimpleModelTable, ModelTable publishedSimpleModelTable, Map<AlterColumnEnum, List<TableColumn>> alterColumnsMap) {
        List<String> draftModelPks = ModelSchemaUtil.getPrimaryKeys(draftSimpleModelTable.getColumns());
        List<String> publishedModelPks = ModelSchemaUtil.getPrimaryKeys(publishedSimpleModelTable.getColumns());
        List<TableColumn> dropTableColumns = alterColumnsMap.get((Object)AlterColumnEnum.MODIFY_COLUMN);
        List dropPKTableColumns = dropTableColumns.stream().filter(dropTableColumn -> dropTableColumn.isPK()).collect(Collectors.toList());
        AtomicBoolean isChangePk = new AtomicBoolean(false);
        alterColumnsMap.forEach((alterColumnEnum, tableColumns) -> {
            if (!isChangePk.get() && !CollectionUtils.isEmpty((Collection)tableColumns)) {
                tableColumns.stream().forEach(tableColumn -> {
                    if (tableColumn.isPK().booleanValue()) {
                        isChangePk.set(true);
                    }
                });
            }
        });
        ArrayList<SqlParam> sqlParams = new ArrayList<SqlParam>();
        if (isChangePk.get()) {
            String dropAndAddTablePrimarySql = String.format("ALTER TABLE `%s` DROP %s ", draftSimpleModelTable.getName(), "PRIMARY KEY");
            List<TableColumn> draftColumns = draftSimpleModelTable.getColumns();
            if (CollectionUtils.isNotEmpty(draftColumns)) {
                String primaryKeysSql = ModelSqlGenerator.generatePrimaryKeys(draftColumns);
                dropAndAddTablePrimarySql = String.format(dropAndAddTablePrimarySql + " , ADD %s ", primaryKeysSql);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)draftSimpleModelTable.getName(), (Object)dropAndAddTablePrimarySql);
            }
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSql(dropAndAddTablePrimarySql);
            sqlParam.setParams(new Object[0]);
            sqlParams.add(sqlParam);
        }
        return sqlParams;
    }

    public static List<SqlParam> getAlterAutoIncrementSql(ModelTable modelTable) {
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        TableColumn tableColumn = modelTable.getColumns().stream().filter(currentTableColumn -> currentTableColumn.getAutoIncrement()).findFirst().get();
        if (Objects.nonNull((Object)tableColumn)) {
            String modifyColumnSql = String.format("ALTER TABLE `%s` %s `%s`  %s %s %s COMMENT '%s'", modelTable.getName(), AlterColumnEnum.MODIFY_COLUMN.getSqlChar(), tableColumn.getColumnName(), ModelSqlGenerator.getTypeDDL(tableColumn), ModelSqlGenerator.getNullableEnum(tableColumn.nullable()).getSqlChar(), "AUTO_INCREMENT", tableColumn.getComment());
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)modelTable.getName(), (Object)modifyColumnSql);
            }
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSql(modifyColumnSql);
            sqlParam.setParams(new Object[0]);
            sqlParams.add(sqlParam);
        }
        return sqlParams;
    }

    public static void removePk(List<String> pks, String dropPk) {
        pks.remove(dropPk);
    }

    public static List<SqlParam> genDropOrAddPrimaryKey(String tableName, List<String> remainPks, boolean isDropFirst) {
        if (log.isDebugEnabled()) {
            log.debug("[genDropOrAddPrimaryKey] tableName({}), remainPks({}), isDropFirst({})", new Object[]{tableName, remainPks, isDropFirst});
        }
        List sqlPks = remainPks.stream().map(pk -> "`" + pk + "`").collect(Collectors.toList());
        Table alterTable = new Table("`" + tableName + "`");
        Alter alterPkScript = new Alter();
        alterPkScript.setTable(alterTable);
        ArrayList<AlterExpression> alterExpressions = new ArrayList<AlterExpression>();
        if (isDropFirst) {
            AlterExpression dropPkNameExpression = new AlterExpression();
            dropPkNameExpression.setOperation(AlterOperation.DROP_PRIMARY_KEY);
            alterExpressions.add(dropPkNameExpression);
            if (log.isDebugEnabled()) {
                log.debug("[genDropOrAddPrimaryKey] tableName = {}, after drop pk", (Object)tableName);
            }
        }
        if (CollectionUtils.isNotEmpty(sqlPks)) {
            AlterExpression addPkNameExpression = new AlterExpression();
            addPkNameExpression.setOperation(AlterOperation.ADD);
            addPkNameExpression.addPkColumns(sqlPks);
            alterExpressions.add(addPkNameExpression);
            if (log.isDebugEnabled()) {
                log.debug("[genDropOrAddPrimaryKey] tableName = {}, add Pks = {}", (Object)tableName, sqlPks);
            }
        }
        alterPkScript.setAlterExpressions(alterExpressions);
        String dropAndAddTablePrimarySql = alterPkScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropAndAddTablePrimarySql);
        sqlParam.setParams(new Object[0]);
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        returnValue.add(sqlParam);
        return returnValue;
    }

    public static List<SqlParam> genDropAndAddPrimaryKeyByDropColumnsSql(ModelTable publishedModelTable, List<TableColumn> draftHavePkOfDropTableColumns) {
        String tableName = publishedModelTable.getName();
        List<String> publishedPks = ModelSchemaUtil.getPrimaryKeys(publishedModelTable.getColumns());
        List<String> dropPks = ModelSchemaUtil.getPrimaryKeys(draftHavePkOfDropTableColumns);
        if (log.isDebugEnabled()) {
            log.debug("[genDropAndAddPrimaryKeyByDropColumnsSql] tableName = {}, draft dropPks = {}, publishedPks = {}", new Object[]{tableName, dropPks, publishedPks});
        }
        dropPks.stream().forEach(dropPk -> publishedPks.remove(dropPk));
        List sqlPks = publishedPks.stream().map(pk -> "`" + pk + "`").collect(Collectors.toList());
        Table alterTable = new Table("`" + tableName + "`");
        Alter alterPkScript = new Alter();
        alterPkScript.setTable(alterTable);
        ArrayList<AlterExpression> alterExpressions = new ArrayList<AlterExpression>();
        AlterExpression dropPkNameExpression = new AlterExpression();
        dropPkNameExpression.setOperation(AlterOperation.DROP_PRIMARY_KEY);
        alterExpressions.add(dropPkNameExpression);
        if (CollectionUtils.isNotEmpty(sqlPks)) {
            AlterExpression addPkNameExpression = new AlterExpression();
            addPkNameExpression.setOperation(AlterOperation.ADD);
            addPkNameExpression.addPkColumns(sqlPks);
            alterExpressions.add(addPkNameExpression);
            if (log.isDebugEnabled()) {
                log.debug("[genDropAndAddPrimaryKeyByDropColumnsSql] tableName = {}, after drop pk, add Pks = {}", (Object)tableName, sqlPks);
            }
        }
        alterPkScript.setAlterExpressions(alterExpressions);
        String dropAndAddTablePrimarySql = alterPkScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropAndAddTablePrimarySql);
        sqlParam.setParams(new Object[0]);
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        returnValue.add(sqlParam);
        return returnValue;
    }

    public static LinkedList<SqlParam> genAlterTableUniqueIndex(ModelTable modelTable, List<String> newIndexMember, ModelIndexDTO publishedModelIndexDTO) {
        LinkedList<SqlParam> returnValue = new LinkedList<SqlParam>();
        String tableName = modelTable.getName();
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        ModelTableSchemaCache modelTableSchemaCache = publishedTableCache.get(tableName);
        Map<String, Object> publishedRemainIndexes = modelTableSchemaCache.getPublishedRemainIndexes();
        String uniqueId = publishedModelIndexDTO.getId();
        if (publishedRemainIndexes.containsKey(publishedModelIndexDTO.getId())) {
            String dropAndAddModelIndexSql = String.format("ALTER TABLE `%s` DROP INDEX `%s` ", tableName, uniqueId);
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSql(dropAndAddModelIndexSql);
            sqlParam.setParams(new Object[0]);
            returnValue.add(sqlParam);
            publishedRemainIndexes.remove(uniqueId);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter unique index: tableName:{}, sql:{}, dropped index:({})", new Object[]{tableName, dropAndAddModelIndexSql, publishedModelIndexDTO});
            }
        } else {
            log.warn(">>>>> ignored to gen Alter unique index: tableName = {}, unique id = {}, cause remain({})", new Object[]{tableName, uniqueId, publishedRemainIndexes});
        }
        return returnValue;
    }

    public static void updateAlterColumnsInfoOnly(String tableName, AlterColumnEnum alterColumnEnum, List<TableColumn> modelColumns, LinkedList<SqlParam> targetDDLSqlParam, LinkedList<SqlParam> targetDMLSqlParam) {
        modelColumns.forEach(modelColumn -> {
            LinkedList<SqlParam> alterTableSqlParam = ModelSqlGenerator.generateAlterColumnsSql(tableName, alterColumnEnum, modelColumn);
            targetDDLSqlParam.addAll(alterTableSqlParam);
            if (alterColumnEnum == AlterColumnEnum.DROP_COLUMN) {
                SqlParam deleteRdbmsFieldSql = ModelSqlGenerator.generateDeleteRdbmsFieldSql(tableName, modelColumn.getColumnName());
                targetDMLSqlParam.add(deleteRdbmsFieldSql);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, alterColumnEnum = {}, customColumn = {}", new Object[]{tableName, alterColumnEnum, modelColumn});
                log.debug(">>>>> gen Alter Columns SQL: {}", alterTableSqlParam);
            }
        });
    }

    public static String getUserRowPermissionConditionSql(DWUserPermission userPermission, PlainSelect select) throws Exception {
        String sql = null;
        Field rowPermissionField = DWUserPermission.class.getDeclaredField("rowPermission");
        rowPermissionField.setAccessible(true);
        Object userRowPermission = rowPermissionField.get(userPermission);
        if (userPermission.isSuperadmin()) {
            log.debug(String.format("[report permission] superadmin", new Object[0]));
            return "";
        }
        if (userRowPermission != null) {
            if (userRowPermission instanceof DWRowPermissionGroup) {
                ModelSqlGenerator.dealDWRowPermissionGroup(userRowPermission, select);
            } else if (userRowPermission instanceof DWRowPermissionEmpty) {
                sql = " 1 <> 1";
            } else {
                DWRowPermissionBase dwRowPermissionSingleFieldValue = (DWRowPermissionBase)userRowPermission;
                dwRowPermissionSingleFieldValue.setFilterField(select.getFromItem().getAlias() == null ? select.getFromItem().toString() + "." + dwRowPermissionSingleFieldValue.getFilterField() : select.getFromItem().getAlias().toString() + "." + dwRowPermissionSingleFieldValue.getFilterField());
            }
            log.debug(String.format("[report permission] row permission sql: {} permission type is :{}", new Object[0]), (Object)((DWRowPermissionBase)userRowPermission).getSQLContainValues((DWRowPermissionMatchOption)new DWRowPermissionDefaultMatchOption(true)), rowPermissionField.get(userPermission));
        } else {
            log.debug(String.format("[report permission] has no row permission", new Object[0]));
        }
        if (sql == null && "".equals(sql = userPermission.getRowPermission().getSQLContainValues((DWRowPermissionMatchOption)new DWRowPermissionDefaultMatchOption(true)))) {
            sql = " 1 <> 1";
        }
        return sql;
    }

    private static void dealDWRowPermissionGroup(Object rowPermission, PlainSelect select) {
        DWRowPermissionGroup rowPermissionGroup = (DWRowPermissionGroup)rowPermission;
        List dwRowPermissions = rowPermissionGroup.getFilterValue();
        Iterator it = dwRowPermissions.iterator();
        while (it.hasNext()) {
            Object filterVaule = it.next();
            if (filterVaule instanceof DWRowPermissionGroup) {
                ModelSqlGenerator.dealDWRowPermissionGroup(filterVaule, select);
                continue;
            }
            DWRowPermissionBase dwRowPermissionFilterValue = (DWRowPermissionBase)filterVaule;
            if (!ModelSqlGenerator.verifyRowPermission(dwRowPermissionFilterValue)) {
                it.remove();
                continue;
            }
            dwRowPermissionFilterValue.setFilterField(select.getFromItem().getAlias() == null ? select.getFromItem().toString() + "." + dwRowPermissionFilterValue.getFilterField() : select.getFromItem().getAlias().toString() + "." + dwRowPermissionFilterValue.getFilterField());
        }
    }

    private static boolean verifyRowPermission(DWRowPermissionBase rowPermission) {
        String filterTable = rowPermission.getFilterTable();
        String filterField = rowPermission.getFilterField();
        try {
            DWMetadata<?> masterTableRdbmsMetadata = ModelDrivenMetadataUtil.loadRdbmsMetadata(filterTable);
            return masterTableRdbmsMetadata.getFields().stream().anyMatch(field -> ((DWRdbmsField)field).getName().equals(filterField));
        }
        catch (DWMetadataNotFoundException e) {
            return false;
        }
    }
}

