/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.model.TableColumn;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ModelSqlParserUtil {
    public static List<String> getTables(String sql) throws JSQLParserException {
        Statement ccjStatement = CCJSqlParserUtil.parse((String)sql);
        Select selectStatement = (Select)ccjStatement;
        TablesNamesFinder tableFinder = new TablesNamesFinder();
        List tables = tableFinder.getTableList((Statement)selectStatement);
        return tables;
    }

    public static CreateTable fetchCCJCreateTable(List data) throws JSQLParserException {
        Map rowMap = (Map)data.get(0);
        String createTableSql = (String)rowMap.get("Create Table");
        Statement statement = CCJSqlParserUtil.parse((String)createTableSql);
        CreateTable ccjCreateTable = (CreateTable)statement;
        return ccjCreateTable;
    }

    public static boolean fetchCCJNullable(List<String> cjColumnDefSpecs) {
        String columnSpecsString = "";
        if (CollectionUtils.isNotEmpty(cjColumnDefSpecs)) {
            columnSpecsString = cjColumnDefSpecs.stream().collect(Collectors.joining(" "));
        }
        return !StringUtils.containsIgnoreCase((CharSequence)columnSpecsString, (CharSequence)"not null");
    }

    public static void processSizeScale(ColumnDefinition columnDefinition, TableColumn tableColumn) {
        List argumentsStringList = columnDefinition.getColDataType().getArgumentsStringList();
        if (CollectionUtils.isNotEmpty((Collection)argumentsStringList)) {
            if (argumentsStringList.size() == 1 && NumberUtils.isDigits((String)((String)argumentsStringList.get(0)))) {
                tableColumn.setSize(Integer.valueOf((String)argumentsStringList.get(0)));
            }
            if (argumentsStringList.size() == 2) {
                if (NumberUtils.isDigits((String)((String)argumentsStringList.get(0)))) {
                    tableColumn.setSize(Integer.valueOf((String)argumentsStringList.get(0)));
                }
                if (NumberUtils.isDigits((String)((String)argumentsStringList.get(1)))) {
                    tableColumn.setScale(Integer.valueOf((String)argumentsStringList.get(1)));
                }
            }
        }
    }
}

