/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.config.NacosServiceRegisterEvent;
import com.digiwin.loadbalance.service.UpdateMetadataService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class NacosRegisterUtils {
    private static final Logger _log = LoggerFactory.getLogger(NacosRegisterUtils.class);
    @Autowired(required=false)
    UpdateMetadataService updateMetadataService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public void autoRegisterNacos(List<DWEAIHeader> newEaiHeaders) throws Exception {
        NacosServiceRegisterEvent nacosServiceRegisterEvent = new NacosServiceRegisterEvent(newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)nacosServiceRegisterEvent);
    }

    public void nacosServiceRegister(List<String> eaiIds) throws Exception {
        HashMap eaiIdsMap = new HashMap();
        eaiIds.forEach(eaiId -> eaiIdsMap.put(eaiId, new int[]{132}));
        this.updateMetadataService.updateInstanceMetadata(eaiIdsMap);
        this.updateMetadataService.updateServiceMetadataIfNeed();
        _log.debug("<<< nacos service register successfully , service ids :{}", eaiIds);
    }

    public static String generateBMDEaiId(String bmEaiId, String targetProd, String bmProd) {
        String[] bmEaiIdArr = bmEaiId.split("\\.");
        String bmEaiIdSuffix = String.join((CharSequence)".", Arrays.copyOfRange(bmEaiIdArr, 2, bmEaiIdArr.length));
        String[] split = targetProd.toLowerCase().replaceAll("\\-", "\\.").split("\\.");
        CharSequence[] prods = Arrays.copyOf(split, split.length - 1);
        String replace = String.join((CharSequence)".", Stream.of(String.join((CharSequence)".", prods), bmEaiIdSuffix).collect(Collectors.toList()));
        List getMatch = Stream.of(".detail.get", ".list.get", ".valid", ".invalid").collect(Collectors.toList());
        int index = -1;
        String matchStr = "";
        for (int i = 0; i < getMatch.size(); ++i) {
            int lastIndex = replace.lastIndexOf((String)getMatch.get(i));
            if (lastIndex == -1) continue;
            index = lastIndex;
            matchStr = (String)getMatch.get(i);
            break;
        }
        if (index != -1) {
            return replace.substring(0, index) + (matchStr.endsWith("get") ? ".get" : ".update");
        }
        return replace;
    }
}

