/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.eai;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BMDataEaiHeaderBuilder
implements EaiHeaderBuilder {
    private static final Logger log = LoggerFactory.getLogger(BMDataEaiHeaderBuilder.class);
    private static final String _CLASSTAG = "[" + BMDataEaiHeaderBuilder.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-crud-eai-builder")
    ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    @Autowired
    @Qualifier(value="dw-modeldriven-eai-repo")
    ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo;
    @Autowired
    @Qualifier(value="lcdp-bmd-eai-method-repo")
    BMDataEaiMethodRepository bmdEaiMethodRepository;

    @Override
    public List<DWEAIHeader> getEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> standardEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        String targetProdOfSite = BMCenterUtil.getProdOfSite();
        this.clearEaiHeaders();
        int serviceMapCount = 1;
        for (DWServiceMapping eaiService : serviceMappings) {
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
            log.debug("{}[{}] serviceMapping: prod({}), eaiService({}), userExposePrefixEaiId({}) processing...", new Object[]{_CLASSTAG, serviceMapCount, eaiProd, eaiService.toString(), userExposePrefixEaiId});
            String targetProdOfDWServiceMapping = eaiService.getTargetProd();
            if (StringUtils.isBlank((CharSequence)targetProdOfDWServiceMapping)) {
                List<DWEAIHeader> stdEaiHeaders = this.modelStandardEAIHeaderBuilder.getStdEaiHeaders(setMappingMethod, eaiService);
                standardEaiHeaders.addAll(stdEaiHeaders);
            } else if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) && targetProdOfSite.equalsIgnoreCase(targetProdOfDWServiceMapping)) {
                List<DWEAIHeader> bmdEaiHeaders = this.getBMDataEaiHeaders(setMappingMethod, eaiService, this.bmdEaiMethodRepository);
                log.debug("{}[{}] targetProd matched, actual({}), expected(site:{}), add eaiservice({})", new Object[]{_CLASSTAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite, bmdEaiHeaders.stream().map(eaiHeader -> eaiHeader.getEAIServiceId()).collect(Collectors.toList())});
                this.bmdEaiMethodRepository.addEaiHeaders(bmdEaiHeaders);
            } else {
                log.info("{}[{}] targetProd not match, actual({}), expected(site:{})", new Object[]{_CLASSTAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite});
            }
            ++serviceMapCount;
        }
        if (mappingModelInfos.size() > 0) {
            List<MappingModelInfo> stdMappingModelInfos;
            Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
            Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
            List<MappingModelInfo> bmdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bmdMappingModelInfos)) {
                List<DWEAIHeader> bmdChildrenListGetHeaders = this.getBMDataListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, bmdMappingModelInfos);
                this.bmdEaiMethodRepository.addEaiHeaders(bmdChildrenListGetHeaders);
            }
            if (CollectionUtils.isNotEmpty(stdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> StringUtils.isBlank((CharSequence)mappingModelInfo.getTargetProd())).collect(Collectors.toList()))) {
                List<DWEAIHeader> stdListGetHeaders = this.modelStandardEAIHeaderBuilder.getStdListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, stdMappingModelInfos, null);
                standardEaiHeaders.addAll(stdListGetHeaders);
            }
        }
        List addEaiNames = standardEaiHeaders.stream().filter(newEaiHeader -> BMConstants.BMD_OLD_MODEL_SERVIC_NAME.stream().noneMatch(existedName -> StringUtils.equals((CharSequence)existedName, (CharSequence)newEaiHeader.getEAIServiceId()))).map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        BMConstants.BMD_OLD_MODEL_SERVIC_NAME.addAll(addEaiNames);
        this.bmdEaiMethodRepository.addEaiHeaders(standardEaiHeaders);
        return standardEaiHeaders;
    }

    public List<DWEAIHeader> getBMDataEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository bmdEaiMethodRepo) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = bmdEaiMethodRepo.getEaiMethodRepo();
        log.info("{} enter BMD master eai service", (Object)_CLASSTAG);
        String eaiTableName = eaiService.getTableName();
        String bmdEaiId = EaiServiceNameUtil.covertToServiceName(eaiTableName);
        String bmdPrefixExposeEaiId = String.join((CharSequence)".", targetProdOfCode, bmdEaiId);
        log.debug("{} *** BMD *** serviceMapping: expose_eai_id prefix({}) from target prod ({}->{}), table_name({})", new Object[]{_CLASSTAG, bmdPrefixExposeEaiId, targetProdOfDWServiceMapping, targetProdOfCode, eaiTableName});
        for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
            ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
            Optional<Class<?>> eaiClazz = Optional.of(mdEaiMethodDTO.getMethod().getDeclaringClass());
            String eaiServiceIdForServiceMapping = String.join((CharSequence)".", bmdPrefixExposeEaiId, "std", mdEaiMethodDTO.getEaiServicePostfix());
            DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
            setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
            newEaiHeaders.add(headerV);
        }
        log.debug("{}[getBMDataEaiHeaders] serviceMapping: gen headerV expose_eai_id({})", (Object)_CLASSTAG, newEaiHeaders.stream().map(eaiHeader -> eaiHeader.getEAIServiceId()).collect(Collectors.toList()));
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getBMDataListGetHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{}EaiServiceUtil] enter children .list.get", (Object)_CLASSTAG);
            int modelinfoCount = 1;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String targetProdOfDWServiceMapping = mappingModelInfo.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] code({}) serviceMapping-child: target_prod({}), child table({}), tableName({})", new Object[]{_CLASSTAG, modelinfoCount++, mappingModelInfo.getCode(), targetProdOfCode, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String bmdEaiId = EaiServiceNameUtil.covertToServiceName(childTableName);
                    String childEaiServiceIdForServiceMapping = String.join((CharSequence)".", targetProdOfCode, bmdEaiId, "std", "get");
                    log.info("{} *** BMD *** code({}), serviceMapping-child: childEaiServiceIdForServiceMapping({})", new Object[]{_CLASSTAG, mappingModelInfo.getCode(), childEaiServiceIdForServiceMapping});
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("{}[getBMDataListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)_CLASSTAG, (Object)childTableListGetHeaders.size());
        } else {
            log.warn("{}[getBMDataListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{_CLASSTAG, 0, listGetMethod});
        }
        return childTableListGetHeaders;
    }

    public List<DWEAIHeader> convertBMDataEAIHeader(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository eaiMethodRepo, List<BindApi> bindApiListConfig) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = eaiMethodRepo.getEaiMethodRepo();
        for (BindApi bindApi : bindApiListConfig) {
            String apiName = bindApi.getApiName();
            String apiType = bindApi.getApiType();
            List mdServiceNames = mdEaiMethods.keySet().stream().collect(Collectors.toList());
            Optional<String> optMatchServiceName = mdServiceNames.stream().filter(mdServiceName -> mdServiceName.contains("." + apiType)).findFirst();
            if (optMatchServiceName.isPresent()) {
                String actualEaiId = optMatchServiceName.get();
                ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethods.get(actualEaiId);
                Optional<Class<?>> eaiClazz = Optional.of(mdEaiMethodDTO.getMethod().getDeclaringClass());
                DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz.get());
                setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                newEaiHeaders.add(headerV);
                continue;
            }
            log.info("{}[convertBMDataEAIHeader] can't find lcdp base method, bindApi({}) ", (Object)_CLASSTAG, (Object)bindApi);
        }
        return newEaiHeaders;
    }

    @Override
    public void clearEaiHeaders() {
        this.bmdEaiMethodRepository.getEaiHeaders().clear();
        log.debug("{} bmdEaiMethodRepository clearEaiHeaders", (Object)_CLASSTAG);
    }
}

