/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.eai;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.model.BMEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BMEaiHeaderBuilder
implements EaiHeaderBuilder {
    private static final Logger log = LoggerFactory.getLogger(BMEaiHeaderBuilder.class);
    private static final String _CLASSTAG = "[" + BMEaiHeaderBuilder.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-crud-eai-builder")
    ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    @Autowired
    @Qualifier(value="dw-modeldriven-eai-repo")
    ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo;
    @Autowired
    @Qualifier(value="lcdp-bm-eai-method-repo")
    BMEaiMethodRepository bmEaiMethodRepository;
    @Autowired
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;

    @Override
    public List<DWEAIHeader> getEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        HashMap<String, Object> childrenBindApi = new HashMap<String, Object>();
        int serviceMapCount = 1;
        for (DWServiceMapping eaiService : serviceMappings) {
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            List<BindApi> bindApiListConfig = modelSchema.getBindApiListConfig();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
            log.debug("{}[{}] serviceMapping: prod({}), eaiService({}),userExposePrefixEaiId({}) processing ... ", new Object[]{_CLASSTAG, serviceMapCount, eaiProd, eaiService.toString(), userExposePrefixEaiId});
            List<DWEAIHeader> bmEaiHeaders = this.getBMEaiHeaders(setMappingMethod, eaiService, this.bmEaiMethodRepository, bindApiListConfig);
            newEaiHeaders.addAll(bmEaiHeaders);
            ++serviceMapCount;
        }
        if (mappingModelInfos.size() > 0) {
            Method bmListGetMethod = this.bmEaiMethodRepository.getListGetMethod();
            Optional<Class<?>> bmEaiCrudClazz = this.bmEaiMethodRepository.getEaiClazz();
            List<MappingModelInfo> bmMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
            List<DWEAIHeader> bmSubListGetHeaders = this.getBMListGetHeaders(setMappingMethod, bmEaiCrudClazz, bmListGetMethod, bmMappingModelInfos, childrenBindApi);
            newEaiHeaders.addAll(bmSubListGetHeaders);
            List<MappingModelInfo> stdMappingModelInfo = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() == null).collect(Collectors.toList());
            Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
            List<DWEAIHeader> stdListGetHeaders = this.modelStandardEAIHeaderBuilder.getStdListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, stdMappingModelInfo, childrenBindApi);
            newEaiHeaders.addAll(stdListGetHeaders);
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getBMEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMEaiMethodRepository bmEaiMethodRepo, List<BindApi> bindApiListConfig) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = bmEaiMethodRepo.getEaiMethodRepo();
        Optional<Class<?>> eaiClazz = bmEaiMethodRepo.getEaiClazz();
        log.info("{} enter md master eai service", (Object)_CLASSTAG);
        String eaiTableName = eaiService.getTableName();
        String userExposePrefixEaiId = eaiService.getExposeEaiId();
        String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
        log.debug("{} serviceMapping: prod({}) eaiService({}) process table_name({}) expose_ea_id({})", new Object[]{_CLASSTAG, eaiProd, eaiService.toString(), eaiTableName, userExposePrefixEaiId});
        boolean hasBindApiList = ModelDataUtil.hasBindApiConfig(bindApiListConfig);
        if (hasBindApiList) {
            for (BindApi bindApi : bindApiListConfig) {
                String apiName = bindApi.getApiName();
                String apiType = bindApi.getApiType();
                List mdServiceNames = mdEaiMethods.keySet().stream().collect(Collectors.toList());
                Optional<String> optMatchServiceName = mdServiceNames.stream().filter(mdServiceName -> mdServiceName.contains("." + apiType)).findFirst();
                if (optMatchServiceName.isPresent()) {
                    String actualEaiId = optMatchServiceName.get();
                    ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethods.get(actualEaiId);
                    DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                    newEaiHeaders.add(headerV);
                    this.bmCodes.put(apiName, new BMCode(eaiService.getCode(), eaiService.getTargetProd()));
                    log.debug("{} *** BM *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})(ignored org serviceMapping eaiid prefix({})", new Object[]{_CLASSTAG, hasBindApiList, headerV.getEAIServiceId(), eaiService.getExposeEaiId()});
                    continue;
                }
                log.info("{} can't find lcdp base method, bindApi({}) ", (Object)_CLASSTAG, (Object)bindApi);
            }
        } else {
            for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
                ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
                String eaiServiceIdForServiceMapping = String.join((CharSequence)".", userExposePrefixEaiId, "std", mdEaiMethodDTO.getEaiServicePostfix());
                DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
                setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                newEaiHeaders.add(headerV);
                this.bmCodes.put(eaiServiceIdForServiceMapping, new BMCode(eaiService.getCode(), eaiService.getTargetProd()));
                log.debug("{} *** BM *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})", new Object[]{_CLASSTAG, hasBindApiList, headerV.getEAIServiceId()});
            }
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getBMListGetHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{}[getBMListGetHeaders] enter children .list.get", (Object)_CLASSTAG);
            int modelinfoCount = 1;
            boolean hasChildrenBindApi = MapUtils.isNotEmpty(childrenBindApi);
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] *** BM *** code({}), serviceMapping-child: prod({}), child table({}), tableName({})", new Object[]{_CLASSTAG, mappingModelInfo.getCode(), modelinfoCount++, eaiProd, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = "";
                    if (hasChildrenBindApi && childrenBindApi.containsKey(childTableName)) {
                        Object childBindApiObj = childrenBindApi.get(childTableName);
                        if (childBindApiObj != null && ((List)childBindApiObj).size() > 0) {
                            BindApi childBindApi = (BindApi)((List)childBindApiObj).get(0);
                            childEaiServiceIdForServiceMapping = childBindApi.getApiName();
                            log.debug(" --->> child Bind Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo.getCode()});
                        } else if (childBindApiObj != null && ((List)childBindApiObj).size() == 0) {
                            log.info(" --->> ignored gen DWEAIHeader, cause child BindApi is empty, eaiTableName({}) of code [{}] ", (Object)eaiTableName, (Object)mappingModelInfo.getCode());
                            continue;
                        }
                    } else {
                        childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getBMChildListGetEaiServiceId(eaiProd, childTableName);
                        log.debug(" --->> child bm Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo.getCode()});
                    }
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (log.isDebugEnabled()) {
                        log.debug("  --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    }
                    this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo.getCode(), mappingModelInfo.getTargetProd(), true));
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("{} serviceMapping: children table .list.get count:{}", (Object)_CLASSTAG, (Object)childTableListGetHeaders.size());
        } else {
            log.warn("{} serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{_CLASSTAG, 0, listGetMethod});
        }
        return childTableListGetHeaders;
    }

    @Override
    public void clearEaiHeaders() {
        this.bmEaiMethodRepository.getEaiHeaders().clear();
    }
}

