/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.event;

import com.digiwin.lcdp.modeldriven.event.EaiRegDataInfo;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterProcessor;
import com.digiwin.lcdp.modeldriven.event.EaiServiceRegisterEvent;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class EaiRegisterApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(EaiRegisterApplicationListener.class);
    @Autowired(required=false)
    @Qualifier(value="lcdp-eai-reg-service-processor")
    EaiRegisterProcessor eaiRegisterProcessor;

    @Async(value="lcdp-eai-reg-event-executor")
    @EventListener
    public void onApplicationEvent(EaiServiceRegisterEvent eaiServiceRegisterEvent) {
        log.debug("[EaiRegisterApplicationListener][{}] enter onApplicationEvent", (Object)Thread.currentThread().getName());
        if (Objects.isNull((Object)eaiServiceRegisterEvent)) {
            return;
        }
        EaiRegDataInfo dataInfo = eaiServiceRegisterEvent.getDataInfo();
        String code = dataInfo.getModelCodeName();
        ThreadContext.put((String)"traceId", (String)((String)dataInfo.getExtraInfo().get("traceId")));
        if (log.isDebugEnabled()) {
            log.debug("[EaiRegisterApplicationListener][{}] regEaiService, code={}, dataInfo={}", new Object[]{Thread.currentThread().getName(), code, dataInfo.toString()});
        }
        try {
            this.eaiRegisterProcessor.execute(dataInfo);
            if (log.isDebugEnabled()) {
                log.debug("[EaiRegisterApplicationListener] dataChangeEvent finished. dataInfo==>{} ", dataInfo.getEaiHeaders().stream().map(eai -> eai.getEAIServiceId()).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            log.error("[EaiRegisterApplicationListener] error:{}", (Object)e.fillInStackTrace().toString());
        }
    }
}

