/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.dao.DWBatchCondition;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryInfoBuilder;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMDInvoker;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.utils.BMEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelOidDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMetadataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import com.digiwin.lcdp.modeldriven.utils.ModelTableSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ModelPublishService {
    private static final Logger log = LoggerFactory.getLogger(ModelPublishService.class);
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private ModelTableHelperExpress modelTableHelperExpress;
    @Autowired
    private ModelPublishService modelPublishService;
    @Autowired
    private EaiRegisterUtil eaiRegisterUtil;
    @Autowired
    NacosRegisterUtils nacosRegisterUtils;
    @Autowired(required=false)
    BMDInvoker bmdInvoker;

    public DWDataRow getPublished(ModelOidDTO modelOid) {
        String currentAppId = ApTokenUtil.getCurrentAppId();
        List<Object> pkList = this.getPkList(modelOid);
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfoBuilder().setOids(pkList).create();
        queryInfo.setTableName("dw_lcdp_model");
        DWDataSet dataSet = this.dao.select(queryInfo, option);
        if (dataSet != null && dataSet.getTable("dw_lcdp_model").getRows().size() > 0) {
            DWDataRow dataRow = dataSet.getTable("dw_lcdp_model").getRow(0);
            String publishedAppId = (String)dataRow.get("app_id");
            if (!currentAppId.equals(publishedAppId)) {
                log.warn("code({}) diff appid, draft({}), published({})", new Object[]{modelOid.getCode(), currentAppId, publishedAppId});
            }
            return dataRow;
        }
        return null;
    }

    public DWServiceResult deleteModelSchema(ModelDTO model, Map<String, Object> messageBody) throws Exception {
        HashMap<String, Integer> returnData = new HashMap<String, Integer>();
        String returnMessage = "";
        if (BMProperties.getProperties().isEnabled() && BMProperties.getProperties().getRole() == BMRole.bm) {
            DWEAIResult bmdDeleteResult = (DWEAIResult)this.bmdInvoker.invoker(DWServiceContext.getContext().getRequestHeader(), messageBody);
            String eaiResutlCode = bmdDeleteResult.getCode();
            if (!NumberUtils.isDigits((String)eaiResutlCode) || !eaiResutlCode.equals("0")) {
                Map parameter = bmdDeleteResult.getParameter();
                log.debug("deleteModelSchema: error code({}), parameter({})", (Object)eaiResutlCode, (Object)parameter);
                returnData.putAll(parameter);
            } else {
                returnData.put("model", 1);
            }
        } else {
            String appId = ApTokenUtil.getCurrentAppId();
            model.setAppId(appId);
            String code = model.getCode();
            log.debug("code({}) input model_schema", (Object)model.getCode());
            String tenantId = model.getTargetTenantId();
            ModelOidDTO modelOidDTO = new ModelOidDTO(code, null, tenantId);
            DWDataRow publishedDataRow = this.getPublished(modelOidDTO);
            if (publishedDataRow == null || publishedDataRow.getData().size() == 0) {
                returnMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.delete.datanone"), new Object[0]);
                log.warn(returnMessage);
            } else {
                model.setSchema(ModelSchemaUtil.getModelSchema((String)publishedDataRow.get("model_schema")));
                DWSQLExecutionResult publishedDelete = this.modelPublishService.deletePublished(model, publishedDataRow);
                returnData.put("model", publishedDelete.getDeleteCount());
                returnMessage = ResourceBundleUtils.getString("lcdp.modeldriven.publish.delete.success");
            }
        }
        return DWServiceResultBuilder.build((String)returnMessage, returnData);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Map<String, Object> deleteModelInfoForDeleteModel(ModelDTO model) {
        DWDataSetOperationOption optionDelete = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        optionDelete.getDeleteOption().enableBatchCondition();
        DWBatchCondition batchCondition = new DWBatchCondition();
        String code = model.getCode();
        String appId = model.getAppId();
        batchCondition.addFieldInfo("code", DWQueryValueOperator.Equals, new Object[]{code});
        batchCondition.addFieldInfo("app_id", DWQueryValueOperator.Equals, new Object[]{appId});
        DWDataSet dataSetModelInfo = new DWDataSet();
        dataSetModelInfo.newTable("dw_lcdp_model_info").delete(batchCondition);
        DWSQLExecutionResult returnDaoValue = this.dao.execute(dataSetModelInfo, optionDelete);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        if (log.isDebugEnabled()) {
            log.info("code({}) model_info deleted count({})", (Object)code, (Object)returnDaoValue.getDeleteCount());
        }
        return returnValue;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object deleteModel(ModelDTO model) {
        String code = model.getCode();
        HashMap<String, Integer> returnValue = new HashMap<String, Integer>();
        DWDataSetOperationOption optionDelete = new DWDataSetOperationOption();
        optionDelete.setTenantEnabled(false);
        optionDelete.setManagementFieldEnabled(false);
        optionDelete.getDeleteOption().enableBatchCondition();
        DWBatchCondition batchCondition2 = new DWBatchCondition();
        batchCondition2.addFieldInfo("code", DWQueryValueOperator.Equals, new Object[]{code});
        DWDataSet dataSetModel = new DWDataSet();
        dataSetModel.newTable("dw_lcdp_model").delete(batchCondition2);
        DWSQLExecutionResult deleteModelResult = this.dao.execute(dataSetModel, optionDelete);
        returnValue.put("dw_lcdp_model", deleteModelResult.getDeleteCount());
        if (log.isDebugEnabled()) {
            log.debug("code({}) deleted ({})", (Object)code, returnValue);
        }
        return returnValue;
    }

    public DWEAIResult publishDraft(Map<String, Object> messageBody) throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        String code = draftModel.getCode();
        String modelDescription = draftModel.getDescription();
        String modelTargetTenantId = draftModel.getTargetTenantId();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        DWEAIResult publishResult = EaiResultUtil.getDWEAIResult(returnValue);
        returnValue.put("code", code);
        if (BMProperties.getProperties().isEnabled() && BMProperties.getProperties().getRole() == BMRole.bm) {
            String masterTableName = draftModelSchema.getName();
            String modelDrivenProdPrefix = BMEaiServiceNameUtil.getBMEaiPrefixProdOfServiceMapping();
            log.info("[ModelPublishService][publishDraft] *** BM *** code({}), get modelDrivenProdPrefix {}", (Object)code, (Object)modelDrivenProdPrefix);
            List<DWEAIHeader> newEAIHeaders = this.eaiRegisterUtil.refreshEaiService(draftModelSchema, modelDrivenProdPrefix, code);
            Object regResult = this.eaiRegisterUtil.autoRegisterEAI(newEAIHeaders, code);
            log.info("[ModelPublishService][publishDraft] *** BM *** code({}) finished call register esp service result({})", (Object)code, regResult);
            this.nacosRegisterUtils.nacosServiceRegister(newEAIHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
            log.info("[ModelPublishService][publishDraft] *** BM *** code({}) finished call register nacos service", (Object)code);
            log.info("[ModelPublishService][publishDraft] *** BM *** code({}) call bmd starting...", (Object)code);
            publishResult = (DWEAIResult)this.bmdInvoker.invoker(DWServiceContext.getContext().getRequestHeader(), messageBody);
            log.info("[ModelPublishService][publishDraft] *** BM *** code({}) call bmd finished.", (Object)code);
        } else {
            Map<String, Object> extraMapOfModelContext = modelDrivenContext.getExtraMap();
            List<ModelTable> draftModelTables = ModelSchemaUtil.getModelTables(draftModelSchema, false);
            Map<String, ModelTable> draftModelTableMap = ModelSchemaUtil.getModelTableMap(draftModelTables);
            extraMapOfModelContext.put("draftModelTables", draftModelTableMap);
            List dirtyTableNames = draftModelTableMap.keySet().stream().collect(Collectors.toList());
            ModelOidDTO modelOidDTO = new ModelOidDTO(code, dirtyTableNames, modelTargetTenantId, null);
            DWDataRow publishedDataRow = this.getPublished(modelOidDTO);
            if (publishedDataRow != null) {
                modelDrivenContext.setNewModelPublish(false);
                log.debug("code({}) preparing alter schema", (Object)draftModel.getCode());
                ModelDTO publishedModel = ModelSchemaUtil.getModel(publishedDataRow);
                modelDrivenContext.setPublishedModel(publishedModel);
                ModelSchemaDTO publishedModelSchema = publishedModel.getSchema();
                ModelSchemaUtil.reorganize(publishedModelSchema);
                String publishedModelStr = (String)publishedDataRow.get("model_schema");
                extraMapOfModelContext.put("pModelSchemaStr", publishedModelStr);
                List<ModelTable> publishedModelTables = ModelSchemaUtil.getModelTables(publishedModelSchema, false);
                Map<String, ModelTable> publishedModelTableMap = ModelSchemaUtil.getModelTableMap(publishedModelTables);
                extraMapOfModelContext.put("publishedModelTables", publishedModelTableMap);
                List publishedTableNames = publishedModelTableMap.keySet().stream().collect(Collectors.toList());
                List mixTableNames = (List)CollectionUtils.union(publishedTableNames, dirtyTableNames);
                Map<String, Object> modelTablesOfDb = this.modelTableHelperExpress.getModelTableFromDatabase(mixTableNames);
                extraMapOfModelContext.put("actualModelTablesFromDB", modelTablesOfDb);
                List existedTableNames = modelTablesOfDb.keySet().stream().collect(Collectors.toList());
                extraMapOfModelContext.put("existedTableNames", existedTableNames);
                dirtyTableNames = mixTableNames;
                ModelPublishedEspResult modelPublishedEspResult = this.modelPublishService.alterTableExpress();
                PublishStatusEnum publishStatus = modelPublishedEspResult.getPublishStatusEnum();
                publishResult.setCode(PublishStatusEnum.FAILURE.equals((Object)publishStatus) ? "-1" : "0");
            } else {
                Map<String, Object> modelTablesOfDb = this.modelTableHelperExpress.getModelTableFromDatabase(dirtyTableNames);
                extraMapOfModelContext.put("actualModelTablesFromDB", modelTablesOfDb);
                List existedTableNames = modelTablesOfDb.keySet().stream().collect(Collectors.toList());
                extraMapOfModelContext.put("existedTableNames", existedTableNames);
                log.debug("code({}) preparing create schema", (Object)code);
                ModelPublishedEspResult modelPublishedEspResult = this.modelPublishService.createOrAlterCustomizeTableExpress();
                PublishStatusEnum publishStatus = modelPublishedEspResult.getPublishStatusEnum();
                publishResult.setCode(PublishStatusEnum.FAILURE.equals((Object)publishStatus) ? "-1" : "0");
            }
            ModelDrivenMetadataUtil.removeRdbmsMetadata(code, dirtyTableNames);
        }
        return publishResult;
    }

    @Deprecated
    private List<Object> getPkList(String appId, ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("app_id", appId);
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    private List<Object> getPkList(ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    public ModelPublishedEspResult createOrAlterCustomizeTableExpress() throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        log.debug("[ModelPublishService][createOrAlterCustomizeTableExpress] code({}) useExistedTable={}", (Object)draftModel.getCode(), (Object)draftModel.getUseExistedTable().getTypeChar());
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        ModelSchemaUtil.checkModelSchema(draftModelSchema, true);
        Map draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables");
        List<ModelTable> draftModelTables = draftModelTableMap.values().stream().collect(Collectors.toList());
        AtomicReference<PublishStatusEnum> createStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        DWServiceResult serviceResult = this.modelTableHelperExpress.createCustomizeTableExpress(draftModelSchema.getName(), draftModelTables);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("[createOrAlterCustomizeTableExpress] expected(%b) actual(%b), description:(%s)", createStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            createStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            createStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(createStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    public ModelPublishedEspResult alterTableExpress() throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        ModelDTO publishedModel = modelDrivenContext.getPublishedModel();
        ModelSchemaDTO publishedModelSchema = publishedModel.getSchema();
        String code = draftModel.getCode();
        return this.alterTableExpress(draftModelSchema, publishedModelSchema, code);
    }

    public ModelPublishedEspResult alterTableExpress(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema, String code) throws Exception {
        String masterTableName = draftModelSchema.getName();
        log.debug("=============== express alterTable ====== {} =========", (Object)masterTableName);
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        Map<String, LinkedHashMap<String, List<SqlParam>>> alterMasterTableMap = ModelTableSqlGenerator.filterAlterTableCommand();
        LinkedHashMap<String, List<SqlParam>> alterMap = alterMasterTableMap.get(publishedModelSchema.getName());
        LinkedList alterDDLSqlParam = (LinkedList)alterMap.get("ddl");
        LinkedList alterDMLSqlParam = (LinkedList)alterMap.get("dml");
        alterStatus.set(PublishStatusEnum.CHANGED);
        LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> alterTableMap = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        String tableName = publishedModelSchema.getName();
        Map<String, LinkedHashMap<String, List<SqlParam>>> alterChildrenTableMap = ModelTableSqlGenerator.getChildrenFullLevelAlterTableCommands(tableName, draftModelSchema.getChildren(), publishedModelSchema.getChildren());
        List<SqlParam> updateModelSqlParam = ModelSqlGenerator.generateUpdateModelSql(modelDrivenContext.getDraftModel());
        alterDMLSqlParam.addAll(updateModelSqlParam);
        if (!CollectionUtils.isEmpty((Collection)alterDMLSqlParam) || !CollectionUtils.isEmpty((Collection)alterDDLSqlParam)) {
            alterMap.put("dml", alterDMLSqlParam);
            alterMap.put("ddl", alterDDLSqlParam);
            alterTableMap.put(publishedModelSchema.getName(), alterMap);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        Map draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables");
        List<ModelTable> modelAllTables = draftModelTableMap.values().stream().collect(Collectors.toList());
        LinkedList<SqlParam> UpdateModelInfoParams = ModelSqlGenerator.generateUpdateModelInfoSql(modelAllTables, code);
        alterDMLSqlParam.addAll(UpdateModelInfoParams);
        alterTableMap.putAll(alterChildrenTableMap);
        if (MapUtils.isNotEmpty(alterChildrenTableMap)) {
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        DWServiceResult serviceResult = this.modelTableHelperExpress.alterTableExpress(masterTableName, alterTableMap);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("create: expected(%b) actual(%b), description:(%s)", alterStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            alterStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            alterStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(alterStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    public DWSQLExecutionResult deletePublished(ModelDTO model, DWDataRow publishedDataRow) throws Exception {
        Assert.hasText((String)model.getCode(), (String)"model code must not be null or empty");
        Assert.hasText((String)model.getAppId(), (String)"model appid must not be null or empty");
        String code = model.getCode();
        DWSQLExecutionResult returnResult = new DWSQLExecutionResult();
        if (publishedDataRow != null && MapUtils.isNotEmpty((Map)publishedDataRow.getData())) {
            ModelSchemaDTO modelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
            AtomicReference<PublishStatusEnum> dropStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
            List<String> tableNames = ModelSchemaUtil.getTableNames(modelSchema);
            boolean dropRunStatus = this.modelTableHelperExpress.dropTableExpress(tableNames, model);
            if (dropRunStatus) {
                dropStatus.set(PublishStatusEnum.SUCCESS);
                returnResult.addDeleteCount(code, 1);
            } else {
                dropStatus.set(PublishStatusEnum.FAILURE);
                returnResult.addDeleteCount(code, 0);
            }
            if (log.isDebugEnabled()) {
                log.debug("code({}) drop status: expected({}) actual({})", new Object[]{code, dropStatus, dropRunStatus});
            }
            ModelDrivenMetadataUtil.removeRdbmsMetadata(code, tableNames);
        }
        return returnResult;
    }
}

