/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.DBColumnUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelIndexUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.google.gson.Gson;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSchemaUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelSchemaUtil.class);

    public static List<String> getChildrenName(List<ModelSchemaDTO> childrenSchemas) {
        ArrayList<String> childrenModelSchemaNames = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(childrenSchemas)) {
            for (ModelSchemaDTO tempModelSchema : childrenSchemas) {
                List<ModelSchemaDTO> tempChildrenSchema = tempModelSchema.getChildren();
                List tempChildrenNames = tempChildrenSchema.stream().map(modelSchemaDTO -> modelSchemaDTO.getName()).collect(Collectors.toList());
                childrenModelSchemaNames.addAll(tempChildrenNames);
            }
        }
        return childrenModelSchemaNames;
    }

    public static Map<String, ModelSchemaDTO> getChildrenModelSchemaMap(List<ModelSchemaDTO> childrenSchemas) {
        HashMap<String, ModelSchemaDTO> returnValue = new HashMap<String, ModelSchemaDTO>();
        if (!CollectionUtils.isEmpty(childrenSchemas)) {
            for (ModelSchemaDTO tempModelSchema : childrenSchemas) {
                List<ModelSchemaDTO> childrenSchema = tempModelSchema.getChildren();
                Map tempChildrenSchemeMap = childrenSchema.stream().collect(Collectors.toMap(ModelSchemaDTO::getName, Function.identity()));
                returnValue.putAll(tempChildrenSchemeMap);
            }
        }
        return returnValue;
    }

    public static List<ModelSchemaDTO> getChildrenModelSchema(List<ModelSchemaDTO> childrenSchemas) {
        if (CollectionUtils.isEmpty(childrenSchemas)) {
            return new ArrayList<ModelSchemaDTO>();
        }
        return ModelSchemaUtil.getChildrenModelSchema(childrenSchemas, 1);
    }

    protected static List<ModelSchemaDTO> getChildrenModelSchema(List<ModelSchemaDTO> childrenSchemas, int level) {
        ArrayList<ModelSchemaDTO> childrenModelSchema = new ArrayList<ModelSchemaDTO>();
        List<Object> childrenModelSchemaNames = new ArrayList();
        if (level <= 3 && !CollectionUtils.isEmpty(childrenSchemas)) {
            childrenModelSchemaNames = childrenSchemas.stream().map(modelSchemaDTO -> modelSchemaDTO.getName()).collect(Collectors.toList());
            log.debug("process children at level {} , current childrenModelSchema {}", (Object)level, childrenModelSchemaNames);
            childrenModelSchema.addAll(childrenSchemas);
            for (ModelSchemaDTO childModelSchema : childrenSchemas) {
                List<ModelSchemaDTO> modelSchemaDTOList = ModelSchemaUtil.getChildrenModelSchema(childModelSchema.getChildren(), level + 1);
                childrenModelSchema.addAll(modelSchemaDTOList);
            }
        } else {
            log.debug("end: level {} over maxlevel or empty children({})", (Object)level, (Object)childrenSchemas.size());
        }
        return childrenModelSchema;
    }

    public static List<ModelTable> getModelTables(ModelSchemaDTO modelSchema, boolean includeCollection) {
        if (BooleanUtils.isTrue((Boolean)includeCollection)) {
            return ModelSchemaUtil.getModelTables(modelSchema);
        }
        Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
        ArrayList<ModelTable> modelTables = new ArrayList<ModelTable>();
        for (ModelSchemaDTO tempModelSchema : modelSchemaMap.values()) {
            ModelTable tempModelTable = ModelSchemaUtil.getCurrentLevelModelTable(tempModelSchema, includeCollection);
            modelTables.add(tempModelTable);
        }
        return modelTables;
    }

    public static ModelTable getCurrentLevelModelTable(ModelSchemaDTO modelSchema, boolean includeCollection) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = ModelSchemaUtil.convertToSimpleModelTable(modelSchema, includeCollection);
        return modelTable;
    }

    public static List<ModelTable> getModelTables(ModelSchemaDTO modelSchema) {
        List<ModelSchemaDTO> childrenModelSchema;
        ArrayList<ModelSchemaDTO> modelSchemas = new ArrayList<ModelSchemaDTO>();
        modelSchemas.add(modelSchema);
        ArrayList<ModelTable> modelTables = new ArrayList<ModelTable>();
        List<ModelSchemaDTO> childrenSchemas = modelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenSchemas) && !CollectionUtils.isEmpty(childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas))) {
            modelSchemas.addAll(childrenModelSchema);
        }
        for (ModelSchemaDTO tempModelSchema : modelSchemas) {
            ModelTable tempModelTable = ModelSchemaUtil.getCurrentLevelModelTable(tempModelSchema);
            modelTables.add(tempModelTable);
        }
        return modelTables;
    }

    public static ModelTable getCurrentLevelModelTable(ModelSchemaDTO modelSchema) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema, false);
        return modelTable;
    }

    public static TableIndex convertModelIndexToTable(ModelIndexDTO modelIndex) {
        if (modelIndex == null) {
            return null;
        }
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(modelIndex.getId());
        tableIndex.setMember(modelIndex.getMember());
        if (modelIndex.getType() != null) {
            tableIndex.setType(IndexTypeEnum.getIndexType(modelIndex.getType()));
        }
        return tableIndex;
    }

    public static TableIndex convertModelFieldToTableUniqueIndex(ModelFieldDTO modelField) {
        if (modelField == null) {
            return null;
        }
        ArrayList<String> members = new ArrayList<String>();
        members.add(modelField.getFieldId());
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(modelField.getFieldId());
        tableIndex.setMember(members);
        tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
        return tableIndex;
    }

    public static TableIndex convertTableColumnToTableUniqueIndex(TableColumn tableColumn) {
        if (tableColumn == null) {
            return null;
        }
        String columnName = tableColumn.getColumnName();
        ArrayList<String> members = new ArrayList<String>();
        members.add(columnName);
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(columnName);
        tableIndex.setMember(members);
        tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
        log.debug("[ModelSchemaUtil] found column unique index({})", (Object)columnName);
        return tableIndex;
    }

    public static TableIndex convertModelIndexToTableIndex(ModelIndexDTO modelIndex) {
        TableIndex tableIndex = ModelSchemaUtil.convertModelIndexToTable(modelIndex);
        return tableIndex;
    }

    public static ModelIndexDTO convertTableIndexToModelIndex(TableIndex tableIndex) {
        if (tableIndex == null) {
            return null;
        }
        ModelIndexDTO modelIndexDTO = new ModelIndexDTO();
        modelIndexDTO.setId(tableIndex.getName());
        modelIndexDTO.setMember(tableIndex.getMember());
        if (tableIndex.getType() != null) {
            modelIndexDTO.setType(tableIndex.getType().getIndexChar());
        }
        return modelIndexDTO;
    }

    public static TableColumn convertModelFieldToTableColumn(ModelFieldDTO modelField) {
        if (modelField == null) {
            return null;
        }
        ModelFieldRelationTypeEnum relationTypeEnum = ModelFieldRelationTypeEnum.valueOf(modelField.getType());
        switch (relationTypeEnum) {
            case COLLECTION: {
                log.debug("should ignore: modelField '{}' is {}", (Object)modelField.getFieldId(), (Object)relationTypeEnum.getValue());
            }
        }
        TableColumn tableColumn = DBColumnUtil.convertToTableColumn(modelField);
        return tableColumn;
    }

    public static TableColumn convertToTableColumn(ModelFieldDTO modelField) {
        return DBColumnUtil.convertToTableColumn(modelField);
    }

    @Deprecated
    public static TableColumn getTableColumns(ModelFieldDTO modelField) {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setColumnName(modelField.getFieldId());
        tableColumn.setComment(modelField.getFieldName());
        tableColumn.setDataType(DataTypeEnum.valueOf((String)modelField.getFieldType()));
        tableColumn.setNullable(Optional.ofNullable(modelField.getNotNull()).orElse(true) == false);
        tableColumn.setDefaultValue(modelField.getDefaultValue());
        tableColumn.setAutoIncrement(modelField.getAutoIncrement());
        tableColumn.setPK(modelField.isPk());
        if (!StringUtils.isEmpty((CharSequence)modelField.getSize())) {
            tableColumn.setSize(new Integer(modelField.getSize()));
        }
        if (!StringUtils.isEmpty((CharSequence)modelField.getScale())) {
            tableColumn.setScale(new Integer(modelField.getScale()));
        }
        if (StringUtils.isNotBlank((CharSequence)modelField.getDefaultValueType())) {
            String defaultValueType = modelField.getDefaultValueType();
            if (defaultValueType.equalsIgnoreCase("expression")) {
                tableColumn.setDefaultValueIsExpr(true);
            }
            tableColumn.setDefaultValueType(defaultValueType);
        }
        tableColumn.setUnique(modelField.getUnique());
        tableColumn.setRelationTypeEnum(ModelFieldRelationTypeEnum.valueOf(modelField.getType()));
        return tableColumn;
    }

    public static List<String> getTableNames(ModelSchemaDTO modelSchemaDTO) {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(modelSchemaDTO.getName());
        List<ModelSchemaDTO> childrenSchemas = modelSchemaDTO.getChildren();
        if (CollectionUtils.isNotEmpty(childrenSchemas)) {
            List<ModelSchemaDTO> childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas);
            childrenModelSchema.stream().forEach(cModelSchema -> tableNames.add(cModelSchema.getName()));
        }
        return tableNames;
    }

    public static ModelTable convertToSimpleModelTable(ModelSchemaDTO modelSchema) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = new ModelTable();
        modelTable.setName(modelSchema.getName());
        modelTable.setComment(modelSchema.getComment());
        List<TableColumn> tableColumns = modelSchema.getFields().stream().map(ModelSchemaUtil::convertModelFieldToTableColumn).collect(Collectors.toList());
        modelTable.setColumns(tableColumns);
        return modelTable;
    }

    public static ModelTable convertToSimpleModelTable(ModelSchemaDTO modelSchema, boolean includeCollection) {
        String msPk;
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = new ModelTable();
        modelTable.setName(modelSchema.getName());
        modelTable.setComment(modelSchema.getComment());
        List<TableColumn> allTableColumns = BooleanUtils.isTrue((Boolean)includeCollection) ? modelSchema.getFields().stream().map(ModelSchemaUtil::convertModelFieldToTableColumn).collect(Collectors.toList()) : modelSchema.getFields().stream().filter(tableColumn -> ModelSchemaUtil.checkRelatedType(tableColumn)).map(ModelSchemaUtil::convertToTableColumn).collect(Collectors.toList());
        modelTable.setColumns(allTableColumns);
        List<TableIndex> tableIndexes = new ArrayList<TableIndex>();
        List<ModelIndexDTO> modelIndexes = modelSchema.getIndex();
        if (!CollectionUtils.isEmpty(modelIndexes)) {
            List<ModelIndexDTO> columnUniqueIndexOfModelIndexes = ModelIndexUtil.getColumnUniqueIndexOfModelIndexes(modelIndexes);
            columnUniqueIndexOfModelIndexes.stream().forEach(modelIndex -> allTableColumns.stream().filter(tableColumn -> modelIndex.getId().equals(tableColumn.getColumnName())).findFirst().ifPresent(tableColumn -> tableColumn.setUnique(true)));
            log.debug("[ModelSchemaUtil] modelSchema({}) index({}) reset to column unique", (Object)modelSchema.getName(), columnUniqueIndexOfModelIndexes);
            modelIndexes.removeAll(columnUniqueIndexOfModelIndexes);
            tableIndexes = modelIndexes.stream().map(ModelSchemaUtil::convertModelIndexToTable).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)(msPk = modelSchema.getPk()))) {
            modelTable.setPk(msPk);
            List<String> pks = Arrays.stream(msPk.split(",")).map(String::trim).collect(Collectors.toList());
            TableIndex pkTableIndex = new TableIndex();
            pkTableIndex.setName("PRIMARY KEY");
            pkTableIndex.setMember(pks);
            pkTableIndex.setType(IndexTypeEnum.PRIMARY_KEY);
            tableIndexes.add(pkTableIndex);
        }
        modelTable.setIndexes(tableIndexes);
        return modelTable;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getCreateChildTables(List<ModelSchemaDTO> childModelSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        if (CollectionUtils.isEmpty(childModelSchemas)) {
            return returnValue;
        }
        List<ModelTable> childTables = childModelSchemas.stream().map(childModelSchema -> {
            ModelTable newModelTable = ModelSchemaUtil.getCurrentLevelModelTable(childModelSchema);
            return newModelTable;
        }).collect(Collectors.toList());
        returnValue = ModelSqlGenerator.getCreateChildTablesCommand(null, "code", childTables, null);
        return returnValue;
    }

    public static void checkModelSchema(ModelSchemaDTO modelSchema, boolean isCreate) {
        ModelDataUtil.preCheckSchema(modelSchema);
        List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenModelSchema)) {
            childrenModelSchema.forEach(childFormSchema -> ModelSchemaUtil.checkModelSchema(childFormSchema, isCreate));
        }
    }

    public static boolean checkRelatedType(ModelFieldDTO modelField) {
        return !ModelFieldRelationTypeEnum.valueOf(modelField.getType()).equals((Object)ModelFieldRelationTypeEnum.COLLECTION);
    }

    public static boolean checkRelatedType(TableColumn tableColumn) {
        return tableColumn.getRelationTypeEnum() != ModelFieldRelationTypeEnum.COLLECTION;
    }

    public static Map<AlterColumnEnum, List<TableColumn>> getAlterColumnsMap(ModelTable draftModelTable) {
        String tableName = draftModelTable.getName();
        if (log.isDebugEnabled()) {
            log.debug("publishing model (comparing fields) -> draftModelTable = {}", (Object)tableName);
        }
        List<TableColumn> draftTableColumns = draftModelTable.getColumns();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map dbModelTables = (Map)modelDrivenContext.getExtraMap().get("actualModelTablesFromDB");
        ModelTable actualModelTable = (ModelTable)MapUtils.getObject((Map)dbModelTables, (Object)tableName);
        Assert.notNull((Object)actualModelTable, (String)"master table is not existed in database(get from cache of actualModelTablesFromDB");
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        List<TableColumn> addColumns = ColumnCompareUtil.getAddColumns(draftTableColumns, actualTableColumns);
        List<TableColumn> modifyColumns = ColumnCompareUtil.getModifyColumns(draftTableColumns, actualTableColumns);
        List<TableColumn> dropColumns = null;
        if (!modelDrivenContext.isNewModelPublish()) {
            log.info("modified model -> process drop columns in draftTable({})", (Object)tableName);
            Map publishedModelTables = (Map)ModelDrivenContext.getContext().getExtraMap().get("publishedModelTables");
            ModelTable publishedModelTable = (ModelTable)MapUtils.getObject((Map)publishedModelTables, (Object)tableName, (Object)new ModelTable());
            List<TableColumn> publishTableColumns = publishedModelTable.getColumns();
            dropColumns = ColumnCompareUtil.getDropColumns(draftTableColumns, actualTableColumns, publishTableColumns);
        } else {
            log.info("new model -> ignored process drop columns in draftTable({})", (Object)tableName);
        }
        HashMap<AlterColumnEnum, List<TableColumn>> alterTableColumnsMap = new HashMap<AlterColumnEnum, List<TableColumn>>();
        if (CollectionUtils.isNotEmpty(dropColumns)) {
            alterTableColumnsMap.put(AlterColumnEnum.DROP_COLUMN, dropColumns);
        }
        if (CollectionUtils.isNotEmpty(addColumns)) {
            alterTableColumnsMap.put(AlterColumnEnum.ADD_COLUMN, addColumns);
        }
        if (CollectionUtils.isNotEmpty(modifyColumns)) {
            alterTableColumnsMap.put(AlterColumnEnum.MODIFY_COLUMN, modifyColumns);
        }
        return alterTableColumnsMap;
    }

    public static void updateColumnsSqlParamsWhenNewPublishWithNoApi(String pureTableName, ModelTable draftModelTable, ModelTable actualModelTable, LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmt, LinkedList<SqlParam> ddlSqlParams, LinkedList<SqlParam> dmlSqlParams) {
        List<TableColumn> draftTableColumns = draftModelTable.getColumns();
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        List<TableColumn> org_addColumns = ColumnCompareUtil.getAddColumns(draftTableColumns, actualTableColumns);
        ModelSqlGenerator.updateAlterColumnsInfoOnly(pureTableName, AlterColumnEnum.ADD_COLUMN, org_addColumns, changedAutoIncrmt, ddlSqlParams, dmlSqlParams);
        List<TableColumn> org_modifyColumns = ColumnCompareUtil.getModifyColumns(draftTableColumns, actualTableColumns);
        ModelSqlGenerator.updateAlterColumnsInfoOnly(pureTableName, AlterColumnEnum.MODIFY_COLUMN, org_modifyColumns, changedAutoIncrmt, ddlSqlParams, dmlSqlParams);
    }

    public static void updateColumnsRdbmsSqlParams(String pureTableName, List<TableColumn> filteredTableColumns, LinkedList<SqlParam> targetDMLSqlParams) {
        filteredTableColumns.forEach(tableColumn -> {
            SqlParam insertOrUpdateRdbmsFieldSql = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(pureTableName, tableColumn);
            targetDMLSqlParams.add(insertOrUpdateRdbmsFieldSql);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Insert on duplicate key Rdbms Fields SQL: sql = {}, params = {}", (Object)insertOrUpdateRdbmsFieldSql.getSql(), (Object)insertOrUpdateRdbmsFieldSql.getParams());
            }
        });
    }

    public static ModelSchemaDTO getModelSchema(String modelSchemaJsonStr) {
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)DWGsonProvider.getGson().fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
        return modelSchema;
    }

    public static ModelDTO getModel(DWDataRow dataRow) {
        ModelDTO newModel = new ModelDTO();
        newModel.setTargetTenantId((String)dataRow.get("target_tenant_id"));
        newModel.setCode((String)dataRow.get("code"));
        newModel.setDescription((String)dataRow.get("description"));
        newModel.setAppId((String)dataRow.get("app_id"));
        ModelSchemaDTO modelSchemaDTO = ModelSchemaUtil.parseModelSchema(dataRow);
        newModel.setSchema(modelSchemaDTO);
        return newModel;
    }

    public static ModelSchemaDTO parseModelSchema(DWDataRow dataRow) {
        String code = (String)dataRow.get("code");
        String modelSchemaJsonStr = (String)dataRow.get("model_schema");
        if (StringUtils.isEmpty((CharSequence)modelSchemaJsonStr)) {
            throw new IllegalArgumentException(String.format("\u6a21\u578b %s \u7d00\u9304\u7684\u7d50\u69cb\u70ba\u7a7a", code));
        }
        Gson gson = DWGsonProvider.getGson();
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)gson.fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
        return modelSchema;
    }

    @Deprecated
    public static ModelSchemaDTO parseModelSchema(Map modelMap) {
        String code = (String)modelMap.get("code");
        String modelSchemaJsonStr = (String)modelMap.get("model_schema");
        if (StringUtils.isEmpty((CharSequence)modelSchemaJsonStr)) {
            throw new IllegalArgumentException(String.format("\u6a21\u578b %s \u7d00\u9304\u7684\u7d50\u69cb\u70ba\u7a7a", code));
        }
        ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaJsonStr);
        return modelSchema;
    }

    @Deprecated
    public static ModelDTO getModel(Map modelMap) {
        ModelDTO newModel = new ModelDTO();
        newModel.setCode((String)modelMap.get("code"));
        newModel.setDescription((String)modelMap.get("description"));
        newModel.setAppId((String)modelMap.get("app_id"));
        newModel.setTargetTenantId((String)modelMap.get("target_tenant_id"));
        String modelSchemaJsonStr = (String)modelMap.get("model_schema");
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)DWGsonProvider.getGson().fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
        newModel.setSchema(modelSchema);
        return newModel;
    }

    public static Map<String, ModelSchemaDTO> getModelSchemaMap(ModelSchemaDTO masterModelSchema) {
        HashMap<String, ModelSchemaDTO> result = new HashMap<String, ModelSchemaDTO>();
        result.put(masterModelSchema.getName(), masterModelSchema);
        List<ModelSchemaDTO> childrenModelSchemas = masterModelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenModelSchemas)) {
            childrenModelSchemas.forEach(childrenModelSchema -> result.putAll(ModelSchemaUtil.getModelSchemaMap(childrenModelSchema)));
        }
        return result;
    }

    public static Map<String, ModelTable> getModelTableMap(List<ModelTable> modelTables) {
        HashMap<String, ModelTable> returnValue = new HashMap<String, ModelTable>();
        if (!CollectionUtils.isEmpty(modelTables)) {
            modelTables.forEach(modelTable -> returnValue.put(modelTable.getName(), (ModelTable)modelTable));
        }
        return returnValue;
    }

    public static List<String> getPrimaryKeys(List<TableColumn> customColumns) {
        List<String> pks = customColumns.stream().filter(Field::isPK).map(customColumn -> customColumn.getColumnName()).collect(Collectors.toList());
        return pks;
    }

    public static ModelTableSchemaCache getModelTableSchemaCache(ModelTable actualModelTable) {
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        Map<String, Object> actualRemainTableIndexeMap = ModelIndexUtil.getAllTableIndexes(actualModelTable);
        List<ModelIndexDTO> actualColumnUniqueIndexes = ModelIndexUtil.getColumnUniqueIndexes(actualModelTable);
        actualColumnUniqueIndexes.stream().forEach(columnUniqueIndex -> actualRemainTableIndexeMap.put(columnUniqueIndex.getId(), ModelSchemaUtil.convertModelIndexToTableIndex(columnUniqueIndex)));
        ModelTableSchemaCache publishedTableSchemaCache = new ModelTableSchemaCache();
        publishedTableSchemaCache.setPublishedRemainIndexes(actualRemainTableIndexeMap);
        TableColumn actualAutoIncrmtColumn = DBColumnUtil.getAutoIncrementColumn(actualTableColumns);
        if (actualAutoIncrmtColumn != null) {
            publishedTableSchemaCache.setAutoIncrementColumn(actualAutoIncrmtColumn);
        }
        publishedTableSchemaCache.setTableName(actualModelTable.getName());
        return publishedTableSchemaCache;
    }

    public static void reorganize(ModelSchemaDTO masterModelSchema) {
        Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(masterModelSchema);
        for (String key : modelSchemaMap.keySet()) {
            ModelSchemaDTO modelSchema = modelSchemaMap.get(key);
            List<ModelFieldDTO> modelFields = modelSchema.getFields();
            modelFields.stream().filter(modelField -> ModelDBConstants.MODEL_DATATYPE_NEED_COVERT_JSON.contains(modelField.getFieldType())).forEach(modelField -> modelField.setFieldType(DataTypeEnum.JSON.getName()));
        }
    }
}

