/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenCCJParserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModelSqlParserUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelSqlParserUtil.class);
    private static final String _CLASSTAG = "[" + ModelSqlParserUtil.class.getSimpleName() + "]";

    public static List<String> getTables(String sql) throws JSQLParserException {
        Statement ccjStatement = CCJSqlParserUtil.parse((String)sql);
        Select selectStatement = (Select)ccjStatement;
        TablesNamesFinder tableFinder = new TablesNamesFinder();
        List tables = tableFinder.getTableList((Statement)selectStatement);
        return tables;
    }

    public static CreateTable fetchCCJCreateTable(List data) throws JSQLParserException {
        Map rowMap = (Map)data.get(0);
        String createTableSql = (String)rowMap.get("Create Table");
        Statement statement = CCJSqlParserUtil.parse((String)createTableSql);
        CreateTable ccjCreateTable = (CreateTable)statement;
        return ccjCreateTable;
    }

    public static boolean fetchCCJNullable(List<String> cjColumnDefSpecs) {
        String columnSpecsString = "";
        if (CollectionUtils.isNotEmpty(cjColumnDefSpecs)) {
            columnSpecsString = cjColumnDefSpecs.stream().collect(Collectors.joining(" "));
        }
        return !StringUtils.containsIgnoreCase((CharSequence)columnSpecsString, (CharSequence)"not null");
    }

    public static void processSizeScale(ColumnDefinition columnDefinition, TableColumn tableColumn) {
        List argumentsStringList = columnDefinition.getColDataType().getArgumentsStringList();
        if (CollectionUtils.isNotEmpty((Collection)argumentsStringList)) {
            if (argumentsStringList.size() == 1 && NumberUtils.isDigits((String)((String)argumentsStringList.get(0)))) {
                tableColumn.setSize(Integer.valueOf((String)argumentsStringList.get(0)));
            }
            if (argumentsStringList.size() == 2) {
                if (NumberUtils.isDigits((String)((String)argumentsStringList.get(0)))) {
                    tableColumn.setSize(Integer.valueOf((String)argumentsStringList.get(0)));
                }
                if (NumberUtils.isDigits((String)((String)argumentsStringList.get(1)))) {
                    tableColumn.setScale(Integer.valueOf((String)argumentsStringList.get(1)));
                }
            }
        }
    }

    public static void setDefaultValue(List<String> cjColumnDefSpecs, TableColumn tableColumn) {
        String defaultKey = "DEFAULT";
        String dataTypeName = tableColumn.getDataType().getName();
        if (cjColumnDefSpecs.contains(defaultKey)) {
            String defaultValue;
            int defaultPosition = cjColumnDefSpecs.indexOf(defaultKey);
            String defaultTypeDef = cjColumnDefSpecs.get(defaultPosition + 1);
            if (dataTypeName.toUpperCase().equals(DataTypeEnum.BIT.getName()) && defaultTypeDef != null && defaultTypeDef.startsWith("b'") && defaultTypeDef.endsWith("'")) {
                defaultTypeDef = defaultTypeDef.replaceFirst("b", "");
            }
            if ("NULL".equalsIgnoreCase(defaultValue = DBTableUtil.removeApostropheSymbol(defaultTypeDef))) {
                defaultValue = null;
            }
            tableColumn.setDefaultValue(defaultValue);
            if (StringUtils.containsIgnoreCase((CharSequence)defaultValue, (CharSequence)"current_timestamp")) {
                tableColumn.setDefaultValueIsExpr(true);
                tableColumn.setDefaultValueType("expression");
                log.debug(_CLASSTAG + "columnName({}) {}={}", new Object[]{tableColumn.getColumnName(), defaultKey, defaultValue});
            }
        }
    }

    public static String getComment(CreateTable ccjCreateTable) {
        List createOptStrs = ccjCreateTable.getTableOptionsStrings();
        String commentKey = "COMMENT";
        String comment = "";
        if (createOptStrs.contains(commentKey)) {
            int commentPosition = createOptStrs.indexOf(commentKey);
            comment = DBTableUtil.removeApostropheSymbol((String)createOptStrs.get(commentPosition + 2));
            log.debug(_CLASSTAG + "comment={}", (Object)comment);
        }
        return comment;
    }

    public static List<String> getTableColumnNames(CreateTable ccjCreateTable) {
        List ccjColumnDefinitions = ccjCreateTable.getColumnDefinitions();
        List ccjIndexes = Optional.ofNullable(ccjCreateTable.getIndexes()).orElse(new ArrayList());
        List<TableColumn> existedTableColumns = ModelSqlParserUtil.getTableColumns(ccjColumnDefinitions, ccjIndexes);
        List<String> existedTableColumnNames = existedTableColumns.stream().map(tableColumn -> tableColumn.getColumnName()).collect(Collectors.toList());
        return existedTableColumnNames;
    }

    public static boolean checkColumnUniqueIndex(Index index, String columnName) {
        columnName = DBTableUtil.removeBackQuoteSymbol(columnName);
        String ccjIndexName = DBTableUtil.removeBackQuoteSymbol(index.getName());
        String ccjIndexType = index.getType();
        if (StringUtils.isEmpty((CharSequence)ccjIndexName) || !ccjIndexType.equals("UNIQUE KEY") || index.getColumnsNames().size() > 1) {
            return false;
        }
        return index.getColumnsNames().size() == 1 && ccjIndexName.equals(columnName) && ccjIndexType.equals("UNIQUE KEY");
    }

    public static List<TableIndex> getTableIndexes(List<Index> ccjIndexes) {
        List<TableIndex> existedTableIndexes = ccjIndexes.stream().map(ModelSqlParserUtil::convertToTableIndex).collect(Collectors.toList());
        return existedTableIndexes;
    }

    public static TableIndex convertToTableIndex(Index ccjIndex) {
        String indexTypeName;
        TableIndex tableIndex = new TableIndex();
        String indexName = StringUtils.isNotBlank((CharSequence)ccjIndex.getName()) ? DBTableUtil.removeBackQuoteSymbol(ccjIndex.getName()) : IndexTypeEnum.PRIMARY_KEY.getIndexCommandChar();
        tableIndex.setName(indexName);
        List<String> members = ccjIndex.getColumnsNames().stream().map(member -> DBTableUtil.removeBackQuoteSymbol(member)).collect(Collectors.toList());
        tableIndex.setMember(members);
        switch (indexTypeName = ccjIndex.getType()) {
            case "UNIQUE KEY": {
                tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
                break;
            }
            case "KEY": {
                tableIndex.setType(IndexTypeEnum.INDEX);
                break;
            }
            case "PRIMARY KEY": {
                tableIndex.setType(IndexTypeEnum.PRIMARY_KEY);
                break;
            }
        }
        return tableIndex;
    }

    public static TableColumn convertToTableColumn(ColumnDefinition columnDefinition, List<Index> indexes) {
        if (columnDefinition == null) {
            return null;
        }
        TableColumn tableColumn = new TableColumn();
        String ccjColumnName = columnDefinition.getColumnName();
        List cjColumnDefSpecs = columnDefinition.getColumnSpecs();
        tableColumn.setColumnName(DBTableUtil.removeBackQuoteSymbol(ccjColumnName));
        tableColumn.setComment(ModelDrivenCCJParserUtil.getComment(columnDefinition));
        ColDataType colDataType = columnDefinition.getColDataType();
        tableColumn.setDataType(DataTypeEnum.valueOf((String)colDataType.getDataType().toUpperCase()));
        List dataTypeArgs = colDataType.getArgumentsStringList();
        if (CollectionUtils.isNotEmpty((Collection)cjColumnDefSpecs)) {
            ModelSqlParserUtil.setDefaultValue(cjColumnDefSpecs, tableColumn);
        }
        if (cjColumnDefSpecs.contains("AUTO_INCREMENT")) {
            tableColumn.setAutoIncrement(true);
            tableColumn.setSize(Integer.valueOf((String)dataTypeArgs.get(0)));
            tableColumn.setNullable(false);
        } else {
            boolean columnNullable = ModelSqlParserUtil.fetchCCJNullable(cjColumnDefSpecs);
            tableColumn.setNullable(columnNullable);
            ModelSqlParserUtil.processSizeScale(columnDefinition, tableColumn);
        }
        ArrayList columnUniqueIndexOfIndexes = new ArrayList();
        indexes.stream().forEach(idx -> {
            String ccjIndexName = idx.getName();
            String ccjIndexType = idx.getType();
            if (StringUtils.isEmpty((CharSequence)ccjIndexName) && ccjIndexType.equals("PRIMARY KEY") && idx.getColumnsNames().contains(ccjColumnName)) {
                tableColumn.setPK(true);
            }
            if (ModelSqlParserUtil.checkColumnUniqueIndex(idx, ccjColumnName)) {
                tableColumn.setUnique(true);
                columnUniqueIndexOfIndexes.add(idx);
            }
        });
        indexes.removeAll(columnUniqueIndexOfIndexes);
        return tableColumn;
    }

    public static List<TableColumn> getTableColumns(List<ColumnDefinition> ccjColumnDefinitions, List<Index> ccjIndexes) {
        List<TableColumn> existedTableColumns = ccjColumnDefinitions.stream().map(ccjColumnDef -> ModelSqlParserUtil.convertToTableColumn(ccjColumnDef, ccjIndexes)).collect(Collectors.toList());
        return existedTableColumns;
    }

    public static Map<String, Object> getModifyColumn(String sql) throws Exception {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        String tableName = "";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Alter) {
            Alter alterScript = (Alter)statement;
            Table table = alterScript.getTable();
            String sqlTableName = table.getName();
            tableName = DBTableUtil.removeBackQuoteSymbol(sqlTableName);
            List alterExpressions = alterScript.getAlterExpressions();
            ArrayList<String> alterColumnNames = new ArrayList<String>();
            for (AlterExpression alterExpression : alterExpressions) {
                List dataTypeList;
                if (alterExpression.getOperation() != AlterOperation.MODIFY || !CollectionUtils.isNotEmpty((Collection)(dataTypeList = alterExpression.getColDataTypeList()))) continue;
                String columnName = ((AlterExpression.ColumnDataType)dataTypeList.get(0)).getColumnName();
                alterColumnNames.add(DBTableUtil.removeBackQuoteSymbol(columnName));
            }
            if (CollectionUtils.isNotEmpty(alterColumnNames)) {
                returnValue.put("exceptionAlterDDLTable", tableName);
                returnValue.put("exceptionAlterDDLColumns", alterColumnNames);
            }
            log.debug("get tableName '{}' alter columns({})", (Object)tableName, alterColumnNames);
        }
        return returnValue;
    }
}

