/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelIndexUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTablePartialSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelTableSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelTableSqlGenerator.class);
    private static final String _CLASSTAG = "[" + ModelTableSqlGenerator.class.getSimpleName() + "]";

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> filterAlterTableCommand() throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelSchemaDTO draftModelSchema = modelDrivenContext.getDraftModel().getSchema();
        ModelSchemaDTO publishedModelSchema = modelDrivenContext.getPublishedModel().getSchema();
        return ModelTableSqlGenerator.filterAlterTableCommand(draftModelSchema, publishedModelSchema);
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> filterAlterTableCommand(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema) throws Exception {
        ModelSchemaUtil.checkModelSchema(draftModelSchema, false);
        ModelSchemaUtil.checkModelSchema(publishedModelSchema, false);
        String masterTableName = draftModelSchema.getName();
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        log.debug("=============== filterAlterTableCommand ====== {} =========", (Object)masterTableName);
        List<String> childrenTableNames = ModelDataUtil.getChildrenName(draftModelSchema);
        log.debug("alterTable starting....parent(current) TableName({}) childrenTableNames({}) ", (Object)masterTableName, childrenTableNames);
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        if (!Objects.equals(draftModelSchema.getName(), publishedModelSchema.getName())) {
            throw new DWBusinessException(String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.CannotChangeMasterModelName"), new Object[0]));
        }
        LinkedHashMap alterMap = new LinkedHashMap();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        LinkedList<String> ddlTablePartialSqlParams = new LinkedList<String>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map dbModelTables = (Map)modelDrivenContext.getExtraMap().get("actualModelTablesFromDB");
        ModelTable actualModelTable = null;
        if (!dbModelTables.containsKey(masterTableName)) {
            throw new RuntimeException(String.format("master table(%s) doesn't exist", masterTableName));
        }
        actualModelTable = (ModelTable)dbModelTables.get(masterTableName);
        Map draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables");
        ModelTable masterDraftSimpleModelTable = (ModelTable)draftModelTableMap.get(masterTableName);
        Map publishedModelTableMap = (Map)modelDrivenContext.getExtraMap().get("publishedModelTables");
        ModelTable masterPublishedSimpleModelTable = (ModelTable)publishedModelTableMap.get(masterTableName);
        List<TableColumn> draftTableColumns = masterDraftSimpleModelTable.getColumns();
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        if (!Objects.equals(masterDraftSimpleModelTable.getComment(), actualModelTable.getComment())) {
            List<String> alterComment = ModelTablePartialSqlGenerator.getAlterTableInfoWhenExistedModel(masterDraftSimpleModelTable);
            ddlTablePartialSqlParams.addAll(alterComment);
            SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateUpdateRdbmsTableSql(masterDraftSimpleModelTable);
            alterDMLSqlParam.add(alterRdbmsSqlParam);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        Map<AlterIndexEnum, List<TableIndex>> alterIndexesMap = ModelSqlGenerator.getAlterIndexesMapWithActualModelTable(masterDraftSimpleModelTable, masterPublishedSimpleModelTable, actualModelTable);
        LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmtMap = ColumnCompareUtil.getChangeAutoIncrementColumn(draftTableColumns, actualTableColumns);
        List<String> newPartialTableColumns = ModelTablePartialSqlGenerator.updateColumnsSqlParams(masterDraftSimpleModelTable, actualModelTable, changedAutoIncrmtMap, alterDMLSqlParam);
        newPartialTableColumns.stream().filter(newSql -> ddlTablePartialSqlParams.stream().noneMatch(ddlSqlParam -> Objects.equals(ddlSqlParam, newSql))).forEach(filteredSql -> ddlTablePartialSqlParams.add((String)filteredSql));
        if (MapUtils.isNotEmpty(alterIndexesMap)) {
            alterIndexesMap.forEach((alterIndexEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    List<String> dirtyIndexPartialSqls = ModelTablePartialSqlGenerator.getAlterIndexesInfo(publishedModelSchema.getName(), alterIndexEnum, tableColumns);
                    ddlTablePartialSqlParams.addAll(dirtyIndexPartialSqls);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            });
        }
        List<SqlParam> alterTableDDL = ModelTableSqlGenerator.getCombinedSqls(masterTableName, ddlTablePartialSqlParams);
        alterDDLSqlParam.addAll(alterTableDDL);
        List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(masterDraftSimpleModelTable);
        alterDMLSqlParam.addAll(insertOrUpdateRdbmsFieldsParam);
        if (!CollectionUtils.isEmpty(alterDMLSqlParam) || !CollectionUtils.isEmpty(alterDDLSqlParam)) {
            alterMap.put("ddl", alterDDLSqlParam);
            alterMap.put("dml", alterDMLSqlParam);
            returnValue.put(publishedModelSchema.getName(), alterMap);
        }
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> compareAndGetChildrenAlterData(List<ModelSchemaDTO> draftChildrenSchemas, List<ModelSchemaDTO> publishedChildrenSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> createChildrenTableCommandData;
        List shouldDropChildModelTables;
        List<ModelTable> dropChildModelTables;
        Map<String, LinkedHashMap<String, List<SqlParam>>> dropChildTableCommandData;
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        if (CollectionUtils.isEmpty(draftChildrenSchemas) && CollectionUtils.isEmpty(publishedChildrenSchemas)) {
            return returnValue;
        }
        Map dbModelTables = (Map)ModelDrivenContext.getContext().getExtraMap().get("actualModelTablesFromDB");
        LinkedHashMap tempDDLDML = new LinkedHashMap();
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        ArrayList dmlSqlParams = new ArrayList();
        ArrayList ddlSqlParams = new ArrayList();
        tempDDLDML.put("dml", dmlSqlParams);
        tempDDLDML.put("ddl", ddlSqlParams);
        boolean draftChildrenEmpty = CollectionUtils.isEmpty(draftChildrenSchemas);
        boolean publishedChildrenEmpty = CollectionUtils.isEmpty(publishedChildrenSchemas);
        if (draftChildrenEmpty && !publishedChildrenEmpty && MapUtils.isNotEmpty(dropChildTableCommandData = ModelSqlGenerator.getDropChildTables(dropChildModelTables = (shouldDropChildModelTables = publishedChildrenSchemas.stream().map(publishedModelSchema -> ModelSchemaUtil.getModelTables(publishedModelSchema)).flatMap(Collection::stream).collect(Collectors.toList())).stream().filter(modelTable -> dbModelTables.containsKey(modelTable.getName())).collect(Collectors.toList())))) {
            returnValue.putAll(dropChildTableCommandData);
            dropChildModelTables.stream().forEach(dropModelTable -> {
                ModelTable cfr_ignored_0 = (ModelTable)dbModelTables.remove(dropModelTable.getName());
            });
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        if (!draftChildrenEmpty && publishedChildrenEmpty && MapUtils.isNotEmpty(createChildrenTableCommandData = ModelSchemaUtil.getCreateChildTables(draftChildrenSchemas))) {
            returnValue.putAll(createChildrenTableCommandData);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        if (!draftChildrenEmpty && !publishedChildrenEmpty) {
            List<ModelTable> dropChildModelTables2;
            List shouldDropChildren;
            List<ModelSchemaDTO> newChildren = draftChildrenSchemas.stream().filter(draftChildModelSchema -> publishedChildrenSchemas.stream().noneMatch(publishedChildModelSchema -> Objects.equals(draftChildModelSchema.getName(), publishedChildModelSchema.getName()))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newChildren)) {
                Map<String, LinkedHashMap<String, List<SqlParam>>> createChildrenTableCommandData2 = ModelSchemaUtil.getCreateChildTables(newChildren);
                returnValue.putAll(createChildrenTableCommandData2);
                newChildren.stream().forEach(newModelSchema -> dbModelTables.put(newModelSchema.getName(), ModelSchemaUtil.getCurrentLevelModelTable(newModelSchema)));
                alterStatus.set(PublishStatusEnum.CHANGED);
            }
            if (CollectionUtils.isNotEmpty(shouldDropChildren = publishedChildrenSchemas.stream().filter(draftChildFModelSchema -> draftChildrenSchemas.stream().noneMatch(publishedChildFormSchema -> Objects.equals(draftChildFModelSchema.getName(), publishedChildFormSchema.getName()))).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(dropChildModelTables2 = shouldDropChildren.stream().filter(dropChildModelSchema -> dbModelTables.containsKey(dropChildModelSchema.getName())).map(dropChildModelSchema -> ModelSchemaUtil.convertToSimpleModelTable(dropChildModelSchema)).collect(Collectors.toList()))) {
                Map<String, LinkedHashMap<String, List<SqlParam>>> dropChildrenTableCommandData = ModelSqlGenerator.getDropChildTables(dropChildModelTables2);
                returnValue.putAll(dropChildrenTableCommandData);
                dropChildModelTables2.stream().forEach(dropModelTable -> {
                    ModelTable cfr_ignored_0 = (ModelTable)dbModelTables.remove(dropModelTable.getName());
                });
                alterStatus.set(PublishStatusEnum.CHANGED);
            }
        }
        draftChildrenSchemas.forEach(draftChildModelSchema -> publishedChildrenSchemas.stream().filter(publishedChildFormSchema -> Objects.equals(draftChildModelSchema.getName(), publishedChildFormSchema.getName())).findFirst().ifPresent(publishedChildFormSchema -> {
            try {
                Map<String, LinkedHashMap<String, List<SqlParam>>> childrenAlterData = ModelTableSqlGenerator.filterAlterTableCommand(draftChildModelSchema, publishedChildFormSchema);
                if (MapUtils.isNotEmpty(childrenAlterData)) {
                    returnValue.putAll(childrenAlterData);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            }
            catch (Exception e) {
                String i18nMesg = DWApplicationMessageResourceBundleUtils.getString((String)"published_alter_table_detail_failed", (Object[])new Object[0]);
                log.error(i18nMesg + " -> draftChildModelSchema = {}, publishedChildModelSchema = {}", new Object[]{draftChildModelSchema, publishedChildFormSchema, e});
                throw new RuntimeException(i18nMesg, e);
            }
        }));
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getChildrenFullLevelAlterTableCommands(String tableName, List<ModelSchemaDTO> draftChildrenSchemas, List<ModelSchemaDTO> publishedChildrenSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> returnValue = ModelTableSqlGenerator.getRecursiveAlterChildTableCommand(tableName, draftChildrenSchemas, publishedChildrenSchemas, 1);
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getRecursiveAlterChildTableCommand(String tableName, List<ModelSchemaDTO> draftChildrenSchemas, List<ModelSchemaDTO> publishedChildrenSchemas, int level) throws Exception {
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        log.debug("process level({}), draftChildren size({})", (Object)level, (Object)draftChildrenSchemas.size());
        if (level <= 3) {
            log.debug(_CLASSTAG + "process childModelSchema({})", (Object)tableName);
            Map<String, LinkedHashMap<String, List<SqlParam>>> childrenAlterData = ModelTableSqlGenerator.compareAndGetChildrenAlterData(draftChildrenSchemas, publishedChildrenSchemas);
            returnValue.putAll(childrenAlterData);
            for (ModelSchemaDTO draftChildSchema : draftChildrenSchemas) {
                Map<String, LinkedHashMap<String, List<SqlParam>>> modelSchemaDTOList;
                String draftChildSchemaName = draftChildSchema.getName();
                log.debug("process sub Model Schema, draftChildSchemaName({})", (Object)draftChildSchemaName);
                List matchPublishSchemas = publishedChildrenSchemas.stream().filter(modelSchemaDTO -> modelSchemaDTO.getName().equals(draftChildSchemaName)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(matchPublishSchemas)) {
                    modelSchemaDTOList = ModelTableSqlGenerator.getRecursiveAlterChildTableCommand(draftChildSchemaName, draftChildSchema.getChildren(), ((ModelSchemaDTO)matchPublishSchemas.get(0)).getChildren(), level + 1);
                    returnValue.putAll(modelSchemaDTOList);
                    continue;
                }
                modelSchemaDTOList = ModelTableSqlGenerator.getRecursiveAlterChildTableCommand(tableName, draftChildSchema.getChildren(), new ArrayList<ModelSchemaDTO>(), level + 1);
                returnValue.putAll(modelSchemaDTOList);
            }
        }
        return returnValue;
    }

    public static Map<String, Object> getAlterCommentInfoWithCollation(String tableName, String tableComment, LinkedList<SqlParam> sqlParams) {
        LinkedHashMap alertTableMap = new LinkedHashMap();
        SqlParam alterTableSqlParam = ModelTableSqlGenerator.generateAlterTableSqlWithCollation(tableName, tableComment, "utf8mb4_bin");
        sqlParams.add(alterTableSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Table Params: tableName = {}, tableComment = {}", (Object)tableName, (Object)tableComment);
            log.debug(">>>>> gen Alter Table SQL: {}", (Object)alterTableSqlParam);
        }
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put("success", true);
        returnValue.put("sqlParams", alertTableMap);
        return returnValue;
    }

    public static SqlParam generateAlterTableSqlWithCollation(String tableName, String tableComment, String collation) {
        String modifyTableCommentSql = String.format("ALTER TABLE `%s` %s '%s', COLLATE '%s' ", tableName, "COMMENT", tableComment, collation);
        return new SqlParam(modifyTableCommentSql, new Object[0]);
    }

    public static SqlParam generateAlterTableCollationSql(String tableName, String collation) {
        String modifyTableCommentSql = String.format("ALTER TABLE `%s` COLLATE '%s' ", tableName, collation);
        return new SqlParam(modifyTableCommentSql, new Object[0]);
    }

    public static SqlParam generateAlterTableCollationSql(String tableName) {
        SqlParam alterTableSqlParam = ModelTableSqlGenerator.generateAlterTableCollationSql(tableName, "utf8mb4_bin");
        return alterTableSqlParam;
    }

    public static LinkedList getAlterTableUniqueIndex(String tableName, ModelTable draftModelTable, ModelTable actualModelTable) {
        LinkedList<SqlParam> returnValue = new LinkedList<SqlParam>();
        List<TableIndex> draftTableIndexes = draftModelTable.getIndexes();
        List<ModelIndexDTO> draftModelIndexes = ModelIndexUtil.covertModelIndex(draftTableIndexes);
        List<ModelIndexDTO> draftColumnUniqueIndexes = ModelIndexUtil.getColumnUniqueIndexes(draftModelTable);
        draftModelIndexes.addAll(draftColumnUniqueIndexes);
        List<String> draftModelIndexesNames = ModelIndexUtil.getIndexNames(draftModelIndexes);
        List<TableIndex> existedModelTableIndexes = actualModelTable.getIndexes();
        List<ModelIndexDTO> publishedTableIndexes = ModelIndexUtil.covertModelIndex(existedModelTableIndexes);
        List<ModelIndexDTO> publishedUniqueIndexes = ModelIndexUtil.getColumnUniqueIndexes(actualModelTable);
        publishedTableIndexes.addAll(publishedUniqueIndexes);
        for (ModelIndexDTO publishedModelIndex : publishedTableIndexes) {
            String existedUniqueIndexId = publishedModelIndex.getId();
            if (!draftModelIndexesNames.contains(existedUniqueIndexId)) continue;
            ModelIndexDTO draftMatchModelIndex = draftModelIndexes.stream().filter(draftModelIndex -> draftModelIndex.getId().equals(existedUniqueIndexId)).findFirst().get();
            List<String> draftIndexMember = draftMatchModelIndex.getMember();
            List<String> existedIndexMember = publishedModelIndex.getMember();
            log.info(" tableName =({}), unique index({}) >>> draftMember = {}, existedMember = {}", new Object[]{tableName, existedUniqueIndexId, draftIndexMember, existedIndexMember});
            if (CollectionUtils.isEqualCollection(draftIndexMember, existedIndexMember)) continue;
            LinkedList<SqlParam> uniqueIndexSqlParams = ModelSqlGenerator.genAlterTableUniqueIndex(actualModelTable, new ArrayList<String>(), publishedModelIndex);
            returnValue.addAll(uniqueIndexSqlParams);
            log.info("alterDDLSqlParam add ddl sql:{}", uniqueIndexSqlParams);
        }
        return returnValue;
    }

    public static List<SqlParam> getCombinedSqls(String tableName, List<String> ddlTablePartialSqlParams) {
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        if (CollectionUtils.isNotEmpty(ddlTablePartialSqlParams)) {
            String columnAlter = StringUtil.join(ddlTablePartialSqlParams, (String)",");
            String alterTableSql = "ALTER TABLE `" + tableName + "` " + columnAlter;
            log.debug(_CLASSTAG + " >>> gen ALTER TABLE SQL: {}", (Object)alterTableSql);
            SqlParam combinedDDLSqlParam = new SqlParam(alterTableSql, new Object[0]);
            returnValue.add(combinedDDLSqlParam);
        } else {
            log.debug(_CLASSTAG + " >>> gen nothing cause partial sql is empty");
        }
        return returnValue;
    }
}

