/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.lcdp.modeldriven.extend.dap.documentId.ModelDrivenDocumentIdGenerator;
import com.digiwin.properties.DocumentIdProperties;
import com.digiwin.util.DocumentIdFinder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;

@Configuration
public class DWCustomDocumentIdAutoConfiguration {
    @Bean
    @Lazy
    public ModelDrivenDocumentIdGenerator modelDrivenDocumentIdGenerator() {
        return new ModelDrivenDocumentIdGenerator();
    }

    @Bean
    @ConditionalOnMissingBean(value={DocumentIdFinder.class})
    public DocumentIdFinder documentIdFinder() {
        return new DocumentIdFinder();
    }

    @Bean
    @ConditionalOnMissingBean(value={DocumentIdProperties.class})
    public DocumentIdProperties documentIdProperties(Environment environment) {
        DocumentIdProperties documentIdProperties = new DocumentIdProperties();
        documentIdProperties.setAccurateRuleMatchEnable(Boolean.parseBoolean(environment.getProperty("dwDocumentId.accurateRuleMatch.enabled", "false").trim()));
        documentIdProperties.setSerialLengthOutOfBoundsExceptionEnable(Boolean.parseBoolean(environment.getProperty("dwDocumentId.serialLengthOutOfBoundsException.enabled", "false")));
        return documentIdProperties;
    }
}

