/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterCustomizeHandler;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMDataEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.digiwin.utils.DWTenantUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BMDInvoker {
    private static final String _CLASSTAG = "[" + BMDInvoker.class.getSimpleName() + "]";
    private static final Logger logger = LoggerFactory.getLogger(BMDInvoker.class);
    @Autowired(required=false)
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bm-adapter-handler")
    private BMAdapterCustomizeHandler bmAdapterHandler;
    private static List<String> excludeService = BMConstants.SERVICE_MODEL_PUBLISH;
    private static List<String> serviceWithAppInfo = BMConstants.SERVICE_QUERY_DATA_WITH_APPINFO;

    public Object invoker(Map<String, Object> headers, Map<String, Object> messageBody) throws DWEaiException {
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String serviceName = digiServiceJo.getString("name");
        String[] serviceNameToken = serviceName.split("\\.");
        String serviceType = serviceNameToken[serviceNameToken.length - 1];
        String bmProd = DWApplicationConfigUtils.getProperty((String)"appId");
        String targetProd = null;
        if (excludeService.contains(serviceName)) {
            Map modelData = (Map)((Map)((Map)messageBody.get("std_data")).get("parameter")).get("model");
            String modelStr = DWGsonProvider.getGson().toJson((Object)modelData);
            ModelDTO draftModel = (ModelDTO)DWGsonProvider.getGson().fromJson(modelStr, ModelDTO.class);
            targetProd = draftModel.getAppInfo().getTargetProd();
            if (StringUtils.isBlank((CharSequence)targetProd)) {
                throw new RuntimeException(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.targetProd.NotBlack"));
            }
        } else if (serviceWithAppInfo.contains(serviceName)) {
            Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
            Map appInfo = (Map)params.get("appInfo");
            targetProd = (String)appInfo.get("targetProd");
        } else {
            String bmTargetProds = DWApplicationConfigUtils.getProperty((String)"lcdp.bm.target.prod");
            if (StringUtils.isEmpty((CharSequence)bmTargetProds)) {
                throw new RuntimeException("<<< bmTargetProds properties is not configured");
            }
            List bmTargetProdList = Stream.of(bmTargetProds.split(",")).collect(Collectors.toList());
            if (this.bmCodes.containsKey(serviceName)) {
                BMCode targetBMCode = this.bmCodes.get(serviceName);
                targetProd = targetBMCode.getTargetProd();
            } else {
                targetProd = (String)bmTargetProdList.get(0);
            }
            serviceName = NacosRegisterUtils.generateBMDEaiId(serviceName, targetProd, bmProd);
        }
        if (BMConstants.SERVICE_TYPE_VALID.contains(serviceType)) {
            HashMap<String, String> orgBMDataServiceInfo = new HashMap<String, String>();
            String bmServiceName = digiServiceJo.getString("name");
            bmServiceName = BMDataEaiServiceNameUtil.getBMDataServiceName(bmServiceName, targetProd);
            orgBMDataServiceInfo.put("name", bmServiceName);
            orgBMDataServiceInfo.put("prod", targetProd);
            String bmdOrgService = DWGsonProvider.getGson().toJson(orgBMDataServiceInfo);
            headers.put("digi-modeldriven", bmdOrgService);
            serviceName = String.join((CharSequence)".", "modeldriven.commons.eai", serviceType);
        }
        RequestModel requestModel = new RequestModel();
        requestModel.setServiceProd(targetProd);
        requestModel.setServiceName(serviceName);
        requestModel.setHostProd(targetProd);
        requestModel.setHostVer("1.0.0");
        requestModel.setInvokeType(InvokeTypeEnum.SYNC);
        requestModel.setBodyJsonString(DWGsonProvider.getGson().toJson(messageBody));
        headers.forEach((key, value) -> {
            if (!BMConstants.BM_EXCLUDE_HEADER_ATTRIBUTES.contains(key.toLowerCase())) {
                requestModel.addHeader(key, value.toString());
            }
        });
        Map profile = DWServiceContext.getContext().getProfile();
        if (MapUtils.isEmpty((Map)profile)) {
            requestModel.setTenantId("");
        } else {
            requestModel.setTenantId((String)profile.get(DWTenantUtils.getIamTenantIdKey()));
        }
        ResponseModel responseModel = null;
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            logger.debug(_CLASSTAG + " ---> bmd({}), service({}), stage:begin, time({})", new Object[]{targetProd, serviceName, stopWatch.getTime()});
            responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
            logger.debug(_CLASSTAG + " ---> bmd({}), service({}), stage:response, response({}), time({})", new Object[]{targetProd, serviceName, responseModel, stopWatch.getTime()});
        }
        catch (Exception e) {
            if (e.getCause() == null) {
                logger.warn(_CLASSTAG + " ---> bmd({}), service({}), stage:exception message({})), time({})", new Object[]{"lcdp.bmd.crud.code.get", targetProd, e.getMessage(), stopWatch.getTime()});
            } else {
                logger.warn(_CLASSTAG + " ---> bmd({}), service({}), stage:exception message({}) and cause({}), time({})", new Object[]{"lcdp.bmd.crud.code.get", targetProd, e.getMessage(), e.getCause().getMessage(), stopWatch.getTime()});
            }
            throw new RuntimeException(e);
        }
        finally {
            if (!stopWatch.isStopped()) {
                stopWatch.stop();
            }
        }
        if (!excludeService.contains(serviceName) && !serviceWithAppInfo.contains(serviceName)) {
            return this.bmAdapterHandler.processBMDataResult(responseModel.getBodyJsonString());
        }
        return DWGsonProvider.getGson().fromJson(responseModel.getBodyJsonString(), DWEAIResult.class);
    }

    public DWEAIResult invokeGetBMDCodes(String targetProd) throws Exception {
        String targetServiceName = "lcdp.bmd.crud.code.get";
        RequestModel requestModel = new RequestModel();
        requestModel.setServiceProd(targetProd);
        requestModel.setServiceName(targetServiceName);
        requestModel.setHostProd(targetProd);
        requestModel.setInvokeType(InvokeTypeEnum.SYNC);
        HashMap reqBody = new HashMap();
        HashMap stdData = new HashMap();
        HashMap parameter = new HashMap();
        reqBody.put("std_data", stdData);
        stdData.put("parameter", parameter);
        requestModel.setBodyJsonString(DWGsonProvider.getGson().toJson(reqBody));
        HashMap eocMap = new HashMap();
        requestModel.setEocMap(eocMap);
        ResponseModel responseModel = null;
        requestModel.addHeader("digi-middleware-auth-app", DWApplicationConfigUtils.getProperty((String)"iamApToken"));
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            logger.info(_CLASSTAG + " bmd({}), service({}), stage:begin, time({})", new Object[]{targetProd, targetServiceName, stopWatch.getTime()});
            responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
        }
        catch (Exception e) {
            if (e.getCause() == null) {
                logger.warn(_CLASSTAG + " ---> bmd({}), service({}), stage:exception message({})), time({})", new Object[]{"lcdp.bmd.crud.code.get", targetProd, e.getMessage(), stopWatch.getTime()});
            } else {
                logger.warn(_CLASSTAG + " ---> bmd({}), service({}), stage:exception message({}) and cause({}), time({})", new Object[]{"lcdp.bmd.crud.code.get", targetProd, e.getMessage(), e.getCause().getMessage(), stopWatch.getTime()});
            }
            throw new RuntimeException(e);
        }
        finally {
            if (!stopWatch.isStopped()) {
                stopWatch.stop();
            }
        }
        logger.info(_CLASSTAG + " bmd({}), service({}), stage:finished, time({})", new Object[]{targetProd, targetServiceName, stopWatch.getTime()});
        DWEAIResult eaiResult = (DWEAIResult)DWGsonProvider.getGson().fromJson(responseModel.getBodyJsonString(), DWEAIResult.class);
        return eaiResult;
    }
}

