/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.utils;

import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BMDataEaiServiceNameUtil {
    public static String getEaiIdOfServiceMapping(String tableName, String prod) {
        String prefixOnlyProd = EaiServiceNameUtil.convertEaiIdTypeForServiceMapping(prod);
        String prefixEaiId = EaiServiceNameUtil.getEaiPrefixName(prefixOnlyProd, tableName);
        return prefixEaiId;
    }

    public static String getEaiIdPrefixOfServiceMapping(String targetProd) {
        String[] prodToken = targetProd.toLowerCase().replaceAll("\\-", "\\.").split("\\.");
        CharSequence[] filteredProdToken = Arrays.copyOf(prodToken, prodToken.length - 1);
        String bmdEaiIdPrefix = String.join((CharSequence)".", filteredProdToken);
        return bmdEaiIdPrefix;
    }

    public static String getBMDataServiceName(String bmEaiId, String targetProd) {
        String[] bmEaiIdArr = bmEaiId.split("\\.");
        String bmEaiIdSuffix = String.join((CharSequence)".", Arrays.copyOfRange(bmEaiIdArr, 2, bmEaiIdArr.length));
        String[] split = targetProd.toLowerCase().replaceAll("\\-", "\\.").split("\\.");
        CharSequence[] prods = Arrays.copyOf(split, split.length - 1);
        String bmdServiceName = String.join((CharSequence)".", Stream.of(String.join((CharSequence)".", prods), bmEaiIdSuffix).collect(Collectors.toList()));
        return bmdServiceName;
    }
}

