/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eai.builder;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ModelStandardEaiHeaderBuilder
implements EaiHeaderBuilder {
    private static final Logger log = LoggerFactory.getLogger(ModelStandardEaiHeaderBuilder.class);
    private static final String _CLASSTAG = "[" + ModelStandardEaiHeaderBuilder.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-eai-repo")
    ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo;
    @Autowired(required=false)
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;

    @Override
    public List<DWEAIHeader> getEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        HashMap<String, Object> childrenBindApi = new HashMap<String, Object>();
        int serviceMapCount = 1;
        for (DWServiceMapping eaiService : serviceMappings) {
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            List<BindApi> bindApiListConfig = modelSchema.getBindApiListConfig();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
            log.debug("{} serviceMapping record[{}]: prod({}), eaiService({}) ... process userExposePrefixEaiId({})", new Object[]{_CLASSTAG, serviceMapCount, eaiProd, eaiService.toString(), userExposePrefixEaiId});
            List<Object> stdEaiHeaders = new ArrayList();
            boolean hasBindApiList = ModelDataUtil.hasBindApiConfig(bindApiListConfig);
            if (hasBindApiList) {
                stdEaiHeaders = this.convertStdEAIHeader(setMappingMethod, this.modelDrivenEaiMethodRepo, bindApiListConfig);
                log.info("{} code({}) table_name({}) hasBindApiList({})", new Object[]{_CLASSTAG, modelCode, eaiTableName, bindApiListConfig});
            } else {
                stdEaiHeaders = this.getStdEaiHeaders(setMappingMethod, eaiService, this.modelDrivenEaiMethodRepo);
                if (this.bmCodes != null) {
                    stdEaiHeaders.stream().forEach(stdEaiHeader -> this.bmCodes.put(stdEaiHeader.getEAIServiceId(), new BMCode(modelCode, eaiService.getTargetProd())));
                }
            }
            newEaiHeaders.addAll(stdEaiHeaders);
            List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(modelSchema.getChildren());
            allChildrenSchemas.stream().filter(childModelSchema -> ModelDataUtil.hasBindApiConfig(childModelSchema.getBindApiListConfig())).forEach(childModelSchema -> {
                log.info("{} code({}) table_name({}) children hasBindApiList({})", new Object[]{_CLASSTAG, modelCode, eaiTableName, childModelSchema.getBindApiListConfig()});
                childrenBindApi.put(childModelSchema.getName(), childModelSchema.getBindApiListConfig());
            });
            log.debug("{} code({}) gen EAIHeaders --> master table_name({}), master BindApiList({}), children BindApiList ({})", new Object[]{_CLASSTAG, modelCode, eaiTableName, bindApiListConfig, childrenBindApi});
            ++serviceMapCount;
        }
        if (mappingModelInfos.size() > 0) {
            List<DWEAIHeader> stdListGetHeaders = this.getStdListGetEAIHeaders(setMappingMethod, stdEaiCrudClazz, mappingModelInfos, childrenBindApi);
            newEaiHeaders.addAll(stdListGetHeaders);
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getStdEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService) throws InvocationTargetException, IllegalAccessException {
        return this.getStdEaiHeaders(setMappingMethod, eaiService, this.modelDrivenEaiMethodRepo);
    }

    public List<DWEAIHeader> getStdEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, ModelDrivenEaiMethodRepository mdEaiMethodRepo) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = mdEaiMethodRepo.getEaiMethodRepo();
        Optional<Class<?>> eaiClazz = mdEaiMethodRepo.getEaiClazz();
        String eaiTableName = eaiService.getTableName();
        String userExposePrefixEaiId = eaiService.getExposeEaiId();
        String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
        log.debug("{}[getStdEaiHeaders] serviceMapping: prod({}) eaiService({}) process table_name({}) expose_ea_id({})", new Object[]{_CLASSTAG, eaiProd, eaiService.toString(), eaiTableName, userExposePrefixEaiId});
        for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
            ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
            String eaiServiceIdForServiceMapping = String.join((CharSequence)".", userExposePrefixEaiId, mdEaiMethodDTO.getEaiServicePostfix());
            DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
            setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
            newEaiHeaders.add(headerV);
        }
        log.debug("{}[getStdEaiHeaders] serviceMapping: prod({}) eaiService({}) process table_name({}) expose_eai_id({})", new Object[]{_CLASSTAG, eaiProd, eaiService.toString(), eaiTableName, newEaiHeaders.stream().map(newEaiHeader -> newEaiHeader.getEAIServiceId()).collect(Collectors.toList())});
        return newEaiHeaders;
    }

    private List<DWEAIHeader> convertStdEAIHeader(Method setMappingMethod, ModelDrivenEaiMethodRepository eaiMethodRepo, List<BindApi> bindApiListConfig) throws Exception {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = eaiMethodRepo.getEaiMethodRepo();
        List mdServiceNames = mdEaiMethods.keySet().stream().collect(Collectors.toList());
        Optional<Class<?>> eaiClazz = eaiMethodRepo.getEaiClazz();
        for (BindApi bindApi : bindApiListConfig) {
            String apiName = bindApi.getApiName();
            String apiType = bindApi.getApiType();
            Optional<String> optMatchServiceName = mdServiceNames.stream().filter(mdServiceName -> mdServiceName.contains("." + apiType)).findFirst();
            if (optMatchServiceName.isPresent()) {
                String actualEaiId = optMatchServiceName.get();
                ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethods.get(actualEaiId);
                DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz.get());
                setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                newEaiHeaders.add(headerV);
                continue;
            }
            log.info("[EaiServiceUtil] can't find lcdp base method, bindApi({}) ", (Object)bindApi);
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getStdListGetEAIHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
        List<DWEAIHeader> stdListGetHeaders = this.getStdListGetHeaders(setMappingMethod, eaiClazz, stdListGetMethod, mappingModelInfos, childrenBindApi);
        return stdListGetHeaders;
    }

    public List<DWEAIHeader> getStdListGetHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{}[getStdListGetHeaders] enter children .list.get", (Object)_CLASSTAG);
            int modelinfoCount = 1;
            boolean hasChildrenBindApi = MapUtils.isNotEmpty(childrenBindApi);
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] serviceMapping-child: prod({}), child table({}), tableName({}), code({})", new Object[]{_CLASSTAG, modelinfoCount++, eaiProd, childTableName, eaiTableName, mappingModelInfo.getCode()});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = "";
                    if (hasChildrenBindApi && childrenBindApi.containsKey(childTableName)) {
                        Object childBindApiObj = childrenBindApi.get(childTableName);
                        if (childBindApiObj != null && ((List)childBindApiObj).size() > 0) {
                            BindApi childBindApi = (BindApi)((List)childBindApiObj).get(0);
                            childEaiServiceIdForServiceMapping = childBindApi.getApiName();
                            log.debug(" --->> child Bind Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo.getCode()});
                        } else if (childBindApiObj != null && ((List)childBindApiObj).size() == 0) {
                            log.info(" --->> ignored gen DWEAIHeader, cause child BindApi is empty, eaiTableName({}) of code [{}] ", (Object)eaiTableName, (Object)mappingModelInfo.getCode());
                            continue;
                        }
                    } else {
                        childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                        log.debug(" --->> child Std Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo.getCode()});
                    }
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (log.isDebugEnabled()) {
                        log.debug("  --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    }
                    if (BMProperties.getProperties() == null || BMProperties.getProperties().getRole() != BMRole.bm) continue;
                    this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo.getCode(), mappingModelInfo.getTargetProd(), true));
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("{}[getStdListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)_CLASSTAG, (Object)childTableListGetHeaders.size());
        } else {
            log.warn("{}[getStdListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{_CLASSTAG, 0, listGetMethod});
        }
        return childTableListGetHeaders;
    }

    @Override
    public void clearEaiHeaders() {
    }
}

