/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.environment.version;

import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDDirectoryUtil {
    private static final Logger log = LoggerFactory.getLogger(MDDirectoryUtil.class);

    public static void checkOrMakeDir(String lcdpLibDirFull) {
        File lcdpLibFile = new File(lcdpLibDirFull);
        if (!lcdpLibFile.exists()) {
            lcdpLibFile.mkdirs();
            log.info("created dir:" + lcdpLibFile.getAbsolutePath());
        }
    }

    public static void cleanFiles(String lcdpLibDirFull, String matchPattern) {
        File lcdpLibDir = new File(lcdpLibDirFull);
        if (lcdpLibDir.exists()) {
            Collection listFiles = FileUtils.listFiles((File)lcdpLibDir, (IOFileFilter)new WildcardFileFilter(matchPattern), null);
            listFiles.stream().forEach(file -> file.delete());
            Collection remainListFiles = FileUtils.listFiles((File)lcdpLibDir, (IOFileFilter)new WildcardFileFilter(matchPattern), null);
            log.info("remain files:{}", remainListFiles.stream().map(file -> file.getName()).collect(Collectors.toList()));
        }
    }
}

