/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eoc;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.ServiceModel;
import com.digiwin.lcdp.modeldriven.eoc.EocHttpRequester;
import com.digiwin.lcdp.modeldriven.eoc.EocProperties;
import com.digiwin.lcdp.modeldriven.eoc.pojo.Dept;
import com.digiwin.lcdp.modeldriven.eoc.pojo.DeptAll;
import com.digiwin.lcdp.modeldriven.eoc.pojo.EmpInfo;
import com.digiwin.lcdp.modeldriven.eoc.pojo.EmpInfoData;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ModelDrivenEocService {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenEocService.class);
    @Autowired
    private EocProperties eocProperties;

    public Object getEmpInfo() throws Exception {
        DWEAIResult dwEaiResult = new DWEAIResult();
        String invokePath = this.eocProperties.getApiPathEmpInfo();
        Object userId = DWServiceContext.getContext().getProfile().get("userId");
        HashMap invokeParams = new HashMap();
        invokeParams.put("userId", userId);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL(invokePath);
        serviceModel.setParams(invokeParams);
        serviceModel.setRequestMethod(DWRequestMethod.POST);
        serviceModel.setToken(DWServiceContext.getContext().getToken());
        HttpResponseModel responseModel = (HttpResponseModel)EocHttpRequester.submit(serviceModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        EmpInfoData empInfoData = null;
        if (!Objects.isNull(responseModel) && httpStatusCode == 200) {
            EmpInfo empInfo = ModelDrivenEocService.covertEmpInfo(responseModel);
            if (empInfo.getSuccess().booleanValue() && Objects.nonNull(empInfo.getData())) {
                empInfoData = empInfo.getData();
                return empInfoData;
            }
            String eocCode = empInfo.getCode();
            String eocMessage = empInfo.getMessage();
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("code", eocCode);
            returnData.put("message", eocMessage);
            dwEaiResult = EaiResultUtil.getDWEAIFalseResult(returnData);
            log.debug("userId() get eoc empInfo failed or data null", userId);
            throw new DWException(String.format("user '%s' is missing EOC employ configuration", userId));
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("code", httpStatusCode);
        returnData.put("message", responseModel);
        dwEaiResult = EaiResultUtil.getDWEAIFalseResult(returnData);
        return empInfoData;
    }

    public Object getDeptAll() throws Exception {
        String invokePath = this.eocProperties.getApiPathEmpDeptAll();
        Object userId = DWServiceContext.getContext().getProfile().get("userId");
        HashMap invokeParams = new HashMap();
        invokeParams.put("userId", userId);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL(invokePath);
        serviceModel.setParams(invokeParams);
        serviceModel.setRequestMethod(DWRequestMethod.POST);
        serviceModel.setToken(DWServiceContext.getContext().getToken());
        HttpResponseModel responseModel = (HttpResponseModel)EocHttpRequester.submit(serviceModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        DWEAIResult dwEaiResult = new DWEAIResult();
        if (!Objects.isNull(responseModel) && httpStatusCode == 200) {
            DeptAll deptAll = ModelDrivenEocService.convertDeptAll(responseModel);
            if (deptAll.getSuccess().booleanValue() && Objects.nonNull(deptAll.getData())) {
                List<Dept> depts = deptAll.getData();
                return depts;
            }
            String eocCode = deptAll.getCode();
            String eocMessage = deptAll.getMessage();
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("code", eocCode);
            returnData.put("message", eocMessage);
            dwEaiResult = EaiResultUtil.getDWEAIFalseResult(returnData);
            log.debug("userId() get eoc depts failed or data null", userId);
            throw new DWException(String.format("user '%s' is missing EOC department configuration", userId));
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("code", httpStatusCode);
        returnData.put("message", responseModel);
        dwEaiResult = EaiResultUtil.getDWEAIFalseResult(returnData);
        return dwEaiResult;
    }

    public Object getDeptIdAll() throws Exception {
        List<Object> deptIds = new ArrayList();
        Object deptAllObject = this.getDeptAll();
        if (deptAllObject instanceof List) {
            List deptAll = (List)deptAllObject;
            deptIds = deptAll.stream().map(dept -> dept.getDeptId()).collect(Collectors.toList());
        } else {
            DWEAIResult dweaiResult = (DWEAIResult)deptAllObject;
            log.debug("eoc error code({}), message({})", (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
        }
        return deptIds;
    }

    public static EmpInfo covertEmpInfo(HttpResponseModel responseModel) {
        String bodyStr = responseModel.getResponseBody();
        EmpInfo empInfo = (EmpInfo)DWGsonProvider.getGson().fromJson(bodyStr, EmpInfo.class);
        return empInfo;
    }

    public static DeptAll convertDeptAll(HttpResponseModel responseModel) {
        String bodyStr = responseModel.getResponseBody();
        DeptAll deptAll = (DeptAll)DWGsonProvider.getGson().fromJson(bodyStr, DeptAll.class);
        return deptAll;
    }
}

