/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.event;

import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.persistconn.TokenProvider;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.lcdp.modeldriven.event.EaiRegDataInfo;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EaiRegisterProcessor {
    private static final Logger log = LoggerFactory.getLogger(EaiRegisterProcessor.class);
    @Autowired
    DWHttpClient dwHttpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(EaiRegDataInfo dataInfo) throws Exception {
        List<DWEAIHeader> newEaiHeaders = dataInfo.getEaiHeaders();
        String modelCode = dataInfo.getModelCodeName();
        DWEAIProperties eaiProperties = dataInfo.getEaiProperties();
        List newEaiServiceIds = newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        log.info("code({}) EAI Services start auto-registering ({})...", (Object)modelCode, newEaiServiceIds);
        Map result = EaiInfoUtils.getSrvRegInfo(() -> newEaiServiceIds, (DWEAIProperties)eaiProperties);
        HttpPost post = new HttpPost(EaiInfoUtils.getEAIRegSrvURL());
        post.setEntity((HttpEntity)new DWJsonEntity((Object)result));
        EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
        post.addHeader("digi-action", "reg");
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        String appToken = TokenProvider.getAppToken();
        post.addHeader("digi-middleware-auth-app", appToken);
        try (CloseableHttpResponse response = (CloseableHttpResponse)this.dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));){
            int statusCode;
            InputStream responseStream;
            String responseBody = "";
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null && (responseStream = httpEntity.getContent()) != null) {
                responseBody = IOUtils.toString((InputStream)responseStream, (Charset)StandardCharsets.UTF_8);
            }
            if ((statusCode = response.getStatusLine().getStatusCode()) != 200) {
                log.error("code({}) Something wrong in the process of eai services auto-registration, httpCode:{}, response({})", new Object[]{modelCode, statusCode, responseBody});
            } else {
                log.info("code({}) ESP response ==> httpCode:{}, message:{}", new Object[]{modelCode, statusCode, responseBody});
                log.info("code({}) EAI Services have registered automatically successfully.", (Object)modelCode);
            }
        }
        catch (Exception e) {
            if (e instanceof DWHttpFailedException) {
                String responseMesg = (String)((DWHttpFailedException)e).getEntity(String.class);
                log.error("code({}) eai auto register failed! (DWHttpFailedException, response({}))", (Object)modelCode, (Object)responseMesg);
            } else {
                log.error("code({}) eai auto register failed! ({})", (Object)modelCode, (Object)e);
            }
        }
        finally {
            log.info("code({}) EAI Services finished auto-registering...", (Object)modelCode);
        }
    }
}

