/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.permission;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionElementDeserializer;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.data.service.DWDataPermission;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;

public class ModelDrivenDataPermission
extends DWDataPermission {
    private static Gson customGson = null;

    public static Object getDataPermission(String moduleId, String actionId, String sysId) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        Object userId = profile.get("userId");
        String userToken = DWServiceContext.getContext().getToken();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sysId", sysId);
        params.put("userId", userId);
        params.put("moduleId", moduleId);
        params.put("actionId", actionId);
        params.put("self", true);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL("/api/iam/v2/permission/data");
        serviceModel.setParams(params);
        serviceModel.setToken(userToken);
        HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        String iamResponseBody = iamResponseModel.getResponseBody();
        int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
        if (iamResponseStatusCode != 200) {
            String errorMessage = "IAM\u56de\u50b3\u72c0\u614b\u78bc\u70ba:%s, \u932f\u8aa4\u8a0a\u606f\u70ba:%s";
            throw new DWException(String.format(errorMessage, iamResponseStatusCode, errorMessage));
        }
        Gson gson = ModelDrivenDataPermission.getCustomGson();
        return gson.fromJson(iamResponseBody, DWUserPermission.class);
    }

    private static synchronized Gson getCustomGson() {
        if (customGson == null) {
            GsonBuilder builder = new GsonBuilder().serializeNulls();
            builder.registerTypeAdapter(DWRowPermissionElement.class, (Object)new DWRowPermissionElementDeserializer());
            customGson = builder.create();
        }
        return customGson;
    }
}

