/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.report;

import com.digiwin.lcdp.modeldriven.report.check.ReportCheckResult;
import com.digiwin.lcdp.modeldriven.report.check.SqlHashCodeCheck;
import com.digiwin.lcdp.modeldriven.report.check.SqlTableCheck;
import com.digiwin.lcdp.modeldriven.report.check.SqlTypeCheck;
import com.digiwin.lcdp.modeldriven.report.model.SqlValueFields;
import com.digiwin.lcdp.modeldriven.report.model.ValueReference;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.DigestUtils;

public class ModelDrivenReportUtil {
    public static ReportCheckResult checkSql(SqlValueFields sqlValueFields, ModelTableHelperExpress modelTableHelperExpress) throws JSQLParserException {
        ReportCheckResult checkResult = new ReportCheckResult();
        SqlHashCodeCheck hashCodeCheck = new SqlHashCodeCheck(sqlValueFields);
        if (!hashCodeCheck.getStatus()) {
            checkResult.setSuccess(hashCodeCheck.getStatus());
            checkResult.setMessages(hashCodeCheck.getMessages());
            return checkResult;
        }
        SqlTypeCheck typeCheck = new SqlTypeCheck(sqlValueFields);
        if (!typeCheck.getStatus()) {
            checkResult.setSuccess(typeCheck.getStatus());
            checkResult.setMessages(typeCheck.getMessages());
            return checkResult;
        }
        SqlTableCheck sqlTableCheck = new SqlTableCheck(sqlValueFields);
        sqlTableCheck.process(sqlValueFields, modelTableHelperExpress);
        if (!sqlTableCheck.getStatus()) {
            checkResult.setSuccess(sqlTableCheck.getStatus());
            checkResult.setMessages(sqlTableCheck.getMessages());
            return checkResult;
        }
        return checkResult;
    }

    public static List<ValueReference> getValidValueReference(List<ValueReference> valueReferences, List<String> tableColumnFields) {
        if (CollectionUtils.isEmpty(valueReferences)) {
            return new ArrayList<ValueReference>();
        }
        List<ValueReference> validValueReferences = valueReferences.stream().filter(valueReference -> tableColumnFields.contains(valueReference.getFullPath())).collect(Collectors.toList());
        return validValueReferences;
    }

    public static boolean checkHashCode(String sql, String hashCode) {
        if (StringUtils.isEmpty((CharSequence)hashCode)) {
            return false;
        }
        String actualValue = DigestUtils.md5DigestAsHex((byte[])("digiwin" + sql + "windigi").getBytes()).toLowerCase();
        return StringUtils.equals((CharSequence)actualValue, (CharSequence)hashCode.toLowerCase());
    }
}

