/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.lcdp.modeldriven.pojo.ActivityParamterDTO;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelActivityService {
    private static final Logger log = LoggerFactory.getLogger(ModelActivityService.class);
    @Autowired
    private DWDao dao;

    public Object updateActivities(ActivityParamterDTO activityParamterDTO) {
        List<Map<String, Object>> activities;
        if ("single".equals(activityParamterDTO.getPublishFlag())) {
            if (CollectionUtils.isNotEmpty(activityParamterDTO.getData())) {
                Map<String, Object> activityMap = activityParamterDTO.getData().get(0);
                DWDataSetOperationOption option = new DWDataSetOperationOption();
                option.setTenantEnabled(false);
                option.setManagementFieldEnabled(false);
                DWDataSet dataset = new DWDataSet();
                DWDataTable dataTable = dataset.newTable("dw_lcdp_model_activity");
                if (MapUtils.isNotEmpty(activityMap)) {
                    DWQueryInfo info = new DWQueryInfo("dw_lcdp_model_activity");
                    info.addEqualInfo("activity_id", activityMap.get("activityId"));
                    info.addEqualInfo("application", activityMap.get("application"));
                    DWDataSet dwDataSet = this.dao.select(info, option);
                    DWDataTable table = dwDataSet.getTable("dw_lcdp_model_activity");
                    activityMap.put("activity_id", activityMap.get("activityId"));
                    if (table.getRows().size() > 0) {
                        ModelDataUtil.dealUpdateMgmtFields(activityMap);
                        dataTable.newRow(activityMap).setState("U");
                    } else {
                        ModelDataUtil.dealInsertMgmtFields(activityMap);
                        dataTable.newRow(activityMap).setState("C");
                    }
                    this.dao.execute(dataset, option);
                }
                return EaiResultUtil.getDWEAIResult(null);
            }
        } else if ("batch".equals(activityParamterDTO.getPublishFlag()) && CollectionUtils.isNotEmpty(activities = activityParamterDTO.getData())) {
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.setManagementFieldEnabled(false);
            String deleteSql = "delete from dw_lcdp_model_activity where application = ?";
            this.dao.update((IDWSQLOptions)option, deleteSql, new Object[]{activityParamterDTO.getApplication()});
            DWDataSet dataset = new DWDataSet();
            DWDataTable dataTable = dataset.newTable("dw_lcdp_model_activity");
            activities.forEach(activity -> {
                ModelDataUtil.dealInsertMgmtFields(activity);
                activity.put("activity_id", activity.get("activityId"));
                dataTable.newRow(activity).setState("C");
            });
            this.dao.execute(dataset, option);
            return EaiResultUtil.getDWEAIResult(null);
        }
        return EaiResultUtil.getDWEAIFalseResult(null);
    }
}

