/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBTableUtil {
    private static Log _logger = LogFactory.getLog(DBTableUtil.class);

    public static String removeBackQuoteSymbol(String name) {
        if (name != null) {
            return name.replaceAll("`", "");
        }
        return name;
    }

    public static String removeApostropheSymbol(String name) {
        if (name == null) {
            return name;
        }
        String returnValue = name.replaceAll("'", "");
        return returnValue;
    }

    public static boolean checkChangePkAndAutoIncrement(Map<String, ModelTable> draftModelTableMap, Map<String, Object> modelTablesOfDb) {
        boolean isChangePkAndAutoIncrement = false;
        String checkResultReturnMessage = "dummy";
        for (String tableName : modelTablesOfDb.keySet()) {
            ModelTable draftModelTable = draftModelTableMap.get(tableName);
            ModelTable actualModelTable = (ModelTable)modelTablesOfDb.get(tableName);
            LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmtMap = ColumnCompareUtil.getChangeAutoIncrementColumn(draftModelTable.getColumns(), actualModelTable.getColumns());
            boolean isChangeAutoIncrement = MapUtils.isNotEmpty(changedAutoIncrmtMap);
            if (isChangeAutoIncrement) {
                isChangePkAndAutoIncrement = true;
                checkResultReturnMessage = String.format("no changed. modelTable(%s) isChangeAutoIncrement(%b)", tableName, isChangeAutoIncrement);
                _logger.info((Object)checkResultReturnMessage);
                break;
            }
            LinkedHashMap<AlterIndexEnum, TableIndex> changedPkMap = IndexCompareUtil.getChangePkIndex(draftModelTable, actualModelTable);
            boolean isChangePk = MapUtils.isNotEmpty(changedPkMap);
            if (!isChangePk) continue;
            isChangePkAndAutoIncrement = true;
            checkResultReturnMessage = String.format("no changed. modelTable(%s)  isChangePk(%b)", tableName, isChangePk);
            _logger.info((Object)checkResultReturnMessage);
            break;
        }
        return isChangePkAndAutoIncrement;
    }
}

