/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    public Throwable filterSQLException(Throwable e) {
        try {
            this.dealSQLException(e);
            return e;
        }
        catch (Exception ex) {
            log.error("ExceptionUtils.filterSQLException error!", (Throwable)ex);
            return ex;
        }
    }

    public Throwable dealSQLException(Throwable throwable) throws Exception {
        Field superDetailMessage = Throwable.class.getDeclaredField("detailMessage");
        if (throwable != null) {
            if (throwable.getCause() == null) {
                if (throwable instanceof SQLException && ((SQLException)throwable).getNextException() != null) {
                    superDetailMessage.setAccessible(true);
                    superDetailMessage.set(throwable, this.customizeErrorMessage(((SQLException)throwable).getNextException()));
                }
                return throwable;
            }
            Throwable causeExceptions = this.dealSQLException(throwable.getCause());
            if (causeExceptions == null) {
                return throwable;
            }
            if (causeExceptions instanceof SQLException) {
                SQLException cause = (SQLException)causeExceptions;
                superDetailMessage.setAccessible(true);
                superDetailMessage.set(throwable, cause.getMessage());
                return cause;
            }
        }
        return throwable;
    }

    public String customizeErrorMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (message.indexOf("Duplicate entry") != -1) {
            String i18nDescription;
            int endKeyName;
            int startRowValue = message.indexOf("'");
            int endRowValue = message.indexOf("'", startRowValue + 1);
            String rowValue = message.substring(startRowValue + 1, endRowValue);
            int startKeyName = message.indexOf("'", endRowValue + 1);
            String keyName = message.substring(startKeyName + 1, endKeyName = message.indexOf("'", startKeyName + 1));
            List<String> keyMembers = this.getConstrainMember(keyName);
            if (CollectionUtils.isNotEmpty(keyMembers)) {
                String memberStr = String.join((CharSequence)",", keyMembers);
                i18nDescription = String.format(ResourceBundleUtils.getString("sqlException.duplicateentry.WithConstrainMember"), rowValue, keyName, memberStr);
            } else {
                i18nDescription = String.format(ResourceBundleUtils.getString("sqlException.duplicateentry"), rowValue, keyName);
            }
            StringBuilder builder = new StringBuilder().append("errCode:").append("P.LCDP.102.0001").append("  ").append("description:").append(i18nDescription);
            return builder.toString();
        }
        Map currentModifyColumns = (Map)ModelDrivenContext.getContext().getExtraMap().get("exceptionAlterDDL");
        if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
            String tableName = (String)currentModifyColumns.get("exceptionAlterDDLTable");
            List modifyColumnNames = currentModifyColumns.getOrDefault("exceptionAlterDDLColumns", new ArrayList());
            String alterInfo = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.SqlExceptionShowAlterColumn"), tableName, modifyColumnNames);
            message = message + ", " + alterInfo;
        }
        return message;
    }

    public List<String> getConstrainMember(String keyName) {
        List<String> indexMembers = new ArrayList<String>();
        Map currentModifyColumns = (Map)ModelDrivenContext.getContext().getExtraMap().get("exceptionAlterDDL");
        if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
            String tableName = (String)currentModifyColumns.get("exceptionAlterDDLTable");
            Map draftModelTableMap = (Map)ModelDrivenContext.getContext().getExtraMap().get("draftModelTables");
            ModelTable modelTable = (ModelTable)draftModelTableMap.get(tableName);
            TableIndex tableIndex = modelTable.getIndexes().stream().filter(index -> index.getName().equals(keyName)).findFirst().get();
            if (Objects.nonNull(tableIndex)) {
                indexMembers = tableIndex.getMember();
            }
        }
        return indexMembers;
    }
}

