/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.create.table.Index;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelIndexUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelIndexUtil.class);
    private static final String _CLASSTAG = "[" + ModelIndexUtil.class.getSimpleName() + "]";

    public static boolean isNotEqualContext(ModelIndexDTO draftModelIndex, ModelIndexDTO publishedModelIndex) {
        return !draftModelIndex.isEqualContext(publishedModelIndex);
    }

    public static Map<String, Object> getUniques(List<ModelIndexDTO> modelIndexDTOs) {
        HashMap<String, Object> uniquesPublishedRemain = new HashMap<String, Object>();
        modelIndexDTOs.stream().filter(modelIndex -> IndexTypeEnum.getIndexType(modelIndex.getType()) == IndexTypeEnum.UNIQUE_INDEX).forEach(modelIndex -> uniquesPublishedRemain.put(modelIndex.getId(), modelIndex));
        return uniquesPublishedRemain;
    }

    public static List<String> getIndexNames(List<ModelIndexDTO> modelIndexDTOs) {
        ArrayList<String> indexNames = new ArrayList<String>();
        Map<String, Object> getIndexes = ModelIndexUtil.getIndexes(modelIndexDTOs);
        getIndexes.keySet().stream().forEach(modelIndex -> indexNames.add((String)modelIndex));
        return indexNames;
    }

    public static List<ModelIndexDTO> getModelTableAllIndexes(ModelSchemaDTO modelSchema) {
        ArrayList<ModelIndexDTO> allIndexes = new ArrayList<ModelIndexDTO>();
        List<ModelIndexDTO> schemaIndexes = modelSchema.getIndex();
        allIndexes.addAll(schemaIndexes);
        ModelTable modelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema);
        List<ModelIndexDTO> tableColumnUniqueIndexes = ModelIndexUtil.getColumnUniqueIndexes(modelTable);
        allIndexes.addAll(tableColumnUniqueIndexes);
        return allIndexes;
    }

    public static Map<String, Object> getAllTableIndexes(ModelTable modelTable) {
        HashMap<String, Object> indexMap = new HashMap<String, Object>();
        List<TableIndex> tableIndexes = modelTable.getIndexes();
        tableIndexes.stream().forEach(modelIndex -> indexMap.put(modelIndex.getName(), modelIndex));
        return indexMap;
    }

    public static Map<String, Object> getIndexes(List<ModelIndexDTO> modelIndexDTOs) {
        HashMap<String, Object> uniquesPublishedRemain = new HashMap<String, Object>();
        modelIndexDTOs.stream().forEach(modelIndex -> uniquesPublishedRemain.put(modelIndex.getId(), modelIndex));
        return uniquesPublishedRemain;
    }

    public static List<ModelIndexDTO> covertModelIndex(List<TableIndex> tableIndexes) {
        ArrayList<ModelIndexDTO> modelIndexes = new ArrayList<ModelIndexDTO>();
        tableIndexes.stream().forEach(tableIndex -> modelIndexes.add(ModelSchemaUtil.convertTableIndexToModelIndex(tableIndex)));
        return modelIndexes;
    }

    public static List<ModelIndexDTO> getColumnUniqueIndexes(ModelTable modelTable) {
        ArrayList<ModelIndexDTO> columnUniqueIndexes = new ArrayList<ModelIndexDTO>();
        modelTable.getColumns().stream().filter(tableColumn -> tableColumn.isPK() == false && tableColumn.getUnique() != false).forEach(tableColumn -> {
            ArrayList<String> members = new ArrayList<String>();
            String columnName = tableColumn.getColumnName();
            members.add(columnName);
            ModelIndexDTO columnUniqueIndex = new ModelIndexDTO();
            columnUniqueIndex.setId(columnName);
            columnUniqueIndex.setMember(members);
            columnUniqueIndex.setType(IndexTypeEnum.UNIQUE_INDEX.getIndexChar());
            columnUniqueIndexes.add(columnUniqueIndex);
        });
        return columnUniqueIndexes;
    }

    public static TableIndex convertToTableIndex(Index ccjIndex) {
        String indexTypeName;
        TableIndex tableIndex = new TableIndex();
        String indexName = StringUtils.isNotBlank((CharSequence)ccjIndex.getName()) ? DBTableUtil.removeBackQuoteSymbol(ccjIndex.getName()) : IndexTypeEnum.PRIMARY_KEY.getIndexCommandChar();
        tableIndex.setName(indexName);
        List<String> members = ccjIndex.getColumnsNames().stream().map(member -> DBTableUtil.removeBackQuoteSymbol(member)).collect(Collectors.toList());
        tableIndex.setMember(members);
        switch (indexTypeName = ccjIndex.getType()) {
            case "UNIQUE KEY": {
                tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
                break;
            }
            case "KEY": {
                tableIndex.setType(IndexTypeEnum.INDEX);
                break;
            }
            case "PRIMARY KEY": {
                tableIndex.setType(IndexTypeEnum.PRIMARY_KEY);
                break;
            }
        }
        return tableIndex;
    }

    public static List<ModelIndexDTO> getColumnUniqueIndexOfModelIndexes(List<ModelIndexDTO> modelIndexes) {
        List<ModelIndexDTO> columUniqueIndexes = modelIndexes.stream().filter(modelIndex -> modelIndex.getMember().size() == 1 && modelIndex.getId().equals(modelIndex.getMember().get(0)) && modelIndex.getType().equalsIgnoreCase(IndexTypeEnum.UNIQUE_INDEX.getIndexChar())).collect(Collectors.toList());
        return columUniqueIndexes;
    }
}

