/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.utils.BMDataModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.model.TableSqlParamDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.report.model.DBTableNameCheckResult;
import com.digiwin.lcdp.modeldriven.utils.DBExecuteHandler;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlParserUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelTablePartialSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ModelTableHelperExpress {
    private static final Logger log = LoggerFactory.getLogger(ModelTableHelperExpress.class);
    private static final String _CLASSTAG = "[" + ModelTableHelperExpress.class.getSimpleName() + "]";
    @Autowired
    private EaiRegisterUtil eaiRegisterUtil;
    @Autowired
    EaiHeaderUtil eaiHeaderUtil;
    @Autowired
    DBExecuteHandler dbExecuteService;
    @Autowired(required=false)
    @Qualifier(value="lcdp-bmd-eai-method-repo")
    BMDataEaiMethodRepository bmdEaiMethodRepository;
    @Autowired(required=false)
    private NacosRegisterUtils nacosRegisterUtils;

    public DWServiceResult alterTableExpress(String masterTableName, LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> alterTableMap) throws Exception {
        AtomicReference<PublishStatusEnum> alterRunStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        boolean alterSuccess = false;
        HashMap<String, Object> paramAll = new HashMap<String, Object>();
        LinkedList<SqlParam> ddlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> dmlSqlParams = new LinkedList<SqlParam>();
        for (String tableName : alterTableMap.keySet()) {
            LinkedHashMap<String, List<SqlParam>> tableAlterMap = alterTableMap.get(tableName);
            List<SqlParam> currentTblDmlSqlParams = tableAlterMap.get("dml");
            dmlSqlParams.addAll(currentTblDmlSqlParams);
            List<SqlParam> currentTblDdlSqlParams = tableAlterMap.get("ddl");
            ddlSqlParams.addAll(currentTblDdlSqlParams);
        }
        paramAll.put("dml", dmlSqlParams);
        paramAll.put("ddl", ddlSqlParams);
        DWEAIResult executeResult = this.dbExecuteService.executeAlterTable(paramAll);
        alterRunStatus.set(PublishStatusEnum.CHANGED);
        boolean executeSuccess = false;
        String resultCode = executeResult.getCode();
        if (NumberUtils.isDigits((String)resultCode) && NumberUtils.compare((int)0, (int)NumberUtils.createInteger((String)resultCode)) == 0) {
            executeSuccess = true;
        }
        String description = executeResult.getDescription();
        if (!executeSuccess) {
            SQLException cause = new SQLException(description, executeResult.getSqlCode());
            throw new RuntimeException(cause);
        }
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        String code = draftModel.getCode();
        Map<String, Object> extraMap = modelDrivenContext.getExtraMap();
        String modelDrivenProdPrefix = (String)extraMap.getOrDefault("modelDrivenProdPrefix", "");
        boolean hasBindApiConfig = false;
        String draftModelStr = ModelDataUtil.getDraftModelSchemaFromContextDraftJson();
        String publishedModelSchemaStr = (String)extraMap.get("pModelSchemaStr");
        if (draftModelStr.contains("bindApiListConfig") || publishedModelSchemaStr.contains("bindApiListConfig")) {
            hasBindApiConfig = true;
        }
        ModelSchemaDTO draftModelSchemaDTO = draftModel.getSchema();
        ModelCreateTypeEnum useExistedTable = draftModel.getUseExistedTable();
        ModelDTO publishedModel = modelDrivenContext.getPublishedModel();
        ModelSchemaDTO publishedModelSchemaDTO = publishedModel.getSchema();
        List<DWEAIHeader> publishedEaiHeaders = this.eaiHeaderUtil.genServiceModelInfoData(publishedModelSchemaDTO, modelDrivenProdPrefix, code);
        List<DWHeader> existedEaiHeaders = this.eaiHeaderUtil.getExistedEaiHeaders(publishedEaiHeaders);
        if (CollectionUtils.isNotEmpty(ddlSqlParams) || hasBindApiConfig) {
            boolean isTableCreated = false;
            for (SqlParam sqlParam : ddlSqlParams) {
                String sql = sqlParam.getSql();
                if (!StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"CREATE TABLE")) continue;
                isTableCreated = true;
            }
            if (isTableCreated || hasBindApiConfig) {
                if (!useExistedTable.equals((Object)ModelCreateTypeEnum.EXISTED_TABLE)) {
                    List<DWEAIHeader> draftEaiHeaders = this.eaiHeaderUtil.genServiceModelInfoData(draftModelSchemaDTO, modelDrivenProdPrefix, code);
                    List<DWEAIHeader> addEaiHeaders = this.eaiHeaderUtil.getAddEaiHeaders(draftEaiHeaders, existedEaiHeaders);
                    if (CollectionUtils.isNotEmpty(draftEaiHeaders)) {
                        this.eaiHeaderUtil.addAndUpdateDWEaiHeaders(draftEaiHeaders);
                        log.info(_CLASSTAG + " code({}) starting call register esp service", (Object)code);
                        Object regResult = this.eaiRegisterUtil.autoRegisterEAI(draftEaiHeaders, code);
                        List<DWHeader> dropEAIHeaders = this.eaiHeaderUtil.getDropEaiHeaders(draftEaiHeaders, existedEaiHeaders);
                        this.eaiHeaderUtil.executeDropExistedEaiHeaders(dropEAIHeaders);
                        log.info(_CLASSTAG + " code({}) finished call register esp service result({})", (Object)code, regResult);
                    } else {
                        List<DWHeader> dropEAIHeaders = this.eaiHeaderUtil.getDropEaiHeaders(draftEaiHeaders, existedEaiHeaders);
                        this.eaiHeaderUtil.executeDropExistedEaiHeaders(dropEAIHeaders);
                        log.info(_CLASSTAG + " code({}) just drop DWEAIHeaders ({})", (Object)code, dropEAIHeaders);
                    }
                } else {
                    log.debug(_CLASSTAG + " code({}) isUseExistedTable({})", (Object)code, (Object)useExistedTable);
                }
            }
        }
        return DWServiceResultBuilder.build((boolean)executeSuccess, (String)description, (Object)executeResult);
    }

    public boolean dropTableExpress(List<String> tableNames, ModelDTO model) throws Exception {
        boolean modelActivityExists;
        String code = model.getCode();
        HashMap<String, Object> paramAll = new HashMap<String, Object>();
        LinkedList<SqlParam> ddlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> dmlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> modelDeleteSqls = ModelSqlGenerator.generateDeleteModelSql(code);
        dmlSqlParams.addAll(modelDeleteSqls);
        LinkedList<SqlParam> deleteModelInfoSql = ModelSqlGenerator.generateDeleteModelInfoSql(code);
        dmlSqlParams.addAll(deleteModelInfoSql);
        boolean dataViewExists = this.dbExecuteService.checkTableExist("dw_lcdp_data_view");
        if (dataViewExists) {
            LinkedList<SqlParam> deleteDataViewSql = ModelSqlGenerator.generateDeleteDataViewSql(code);
            dmlSqlParams.addAll(deleteDataViewSql);
        }
        if (modelActivityExists = this.dbExecuteService.checkTableExist("dw_lcdp_model_activity")) {
            LinkedList<SqlParam> deleteActivitySql = ModelSqlGenerator.generateDeleteActivitySql(code);
            dmlSqlParams.addAll(deleteActivitySql);
        }
        for (String targetTableName : tableNames) {
            SqlParam serviceMapping = ModelSqlGenerator.generateDeleteServiceMappingSql(targetTableName);
            dmlSqlParams.add(serviceMapping);
            SqlParam deleteRdbmsTableParam = ModelSqlGenerator.generateDeleteRdbmsTableSql(targetTableName);
            dmlSqlParams.add(deleteRdbmsTableParam);
            SqlParam deleteRdbmsFieldsParam = ModelSqlGenerator.generateDeleteRdbmsFieldSql(targetTableName);
            dmlSqlParams.add(deleteRdbmsFieldsParam);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Delete Rdbms Table Params: code={},tableName = {}", (Object)code, (Object)targetTableName);
                log.debug(">>>>> gen Delete Rdbms Table SQL: {}", (Object)deleteRdbmsTableParam);
                log.debug(">>>>> gen Delete Rdbms SQL: {}", dmlSqlParams);
            }
            SqlParam dropTableSqlParam = ModelSqlGenerator.generateRenameTableSql(targetTableName);
            ddlSqlParams.add(dropTableSqlParam);
        }
        paramAll.put("dml", dmlSqlParams);
        paramAll.put("ddl", ddlSqlParams);
        DWEAIResult executeResult = this.dbExecuteService.executeDeleteTable(paramAll, model);
        boolean executeDeleteSuccess = false;
        String resultCode = executeResult.getCode();
        if (NumberUtils.isDigits((String)resultCode) && NumberUtils.compare((int)0, (int)NumberUtils.createInteger((String)resultCode)) == 0) {
            executeDeleteSuccess = true;
        }
        String description = executeResult.getDescription();
        if (!executeDeleteSuccess) {
            SQLException cause = new SQLException(description, executeResult.getSqlCode());
            throw new RuntimeException(cause);
        }
        return executeDeleteSuccess;
    }

    public DWServiceResult createCustomizeTableExpress(String masterTableName, List<ModelTable> draftModelTables) throws Exception {
        ModelPublishedEspResult executeCreateTableResult;
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> extraMap = modelDrivenContext.getExtraMap();
        Map dbModelTables = extraMap.getOrDefault("actualModelTablesFromDB", new HashMap());
        LinkedList<SqlParam> dmlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> ddlSqlParams = new LinkedList<SqlParam>();
        for (ModelTable draftModelTable : draftModelTables) {
            String currentTableName = draftModelTable.getName();
            log.info(_CLASSTAG + "[createCustomizeTableExpress] ----- process table({}) ----", (Object)currentTableName);
            List<TableColumn> draftTableColumns = draftModelTable.getColumns();
            boolean hasPrimaryKey = draftTableColumns.stream().anyMatch(Field::isPK);
            if (!hasPrimaryKey) {
                throw new IllegalArgumentException(String.format("The table(%s) must include a primary key!", currentTableName));
            }
            SqlParam insertRdbmsTableSqlParam = ModelSqlGenerator.generateInsertRdbmsTableSql(draftModelTable);
            dmlSqlParams.add(insertRdbmsTableSqlParam);
            if (dbModelTables.containsKey(currentTableName)) {
                log.info(_CLASSTAG + "[createCustomizeTableExpress] --> table({}) is existed", (Object)currentTableName);
                LinkedList<String> ddlTablePartialSqlParams = new LinkedList<String>();
                ModelTable actualModelTable = (ModelTable)dbModelTables.get(currentTableName);
                LinkedList<String> partialTableAttributes = ModelTablePartialSqlGenerator.getAlterTableOptionsWhenNewPublish(draftModelTable.getComment());
                ddlTablePartialSqlParams.addAll(partialTableAttributes);
                List<TableColumn> actualTableColumns = actualModelTable.getColumns();
                LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmtMap = ColumnCompareUtil.getChangeAutoIncrementColumn(draftTableColumns, actualTableColumns);
                boolean isChangeAutoIncrement = MapUtils.isNotEmpty(changedAutoIncrmtMap);
                LinkedHashMap<AlterIndexEnum, TableIndex> changedPkMap = IndexCompareUtil.getChangePkIndex(draftModelTable, actualModelTable);
                Map<AlterIndexEnum, List<TableIndex>> alterIndexesMap = ModelSqlGenerator.getCreateAndModifyIndexesMapWithActualModelTable(draftModelTable, actualModelTable);
                if (MapUtils.isNotEmpty(alterIndexesMap)) {
                    alterIndexesMap.forEach((alterIndexEnum, tableColumns) -> {
                        if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                            List<String> dirtyIndexPartialSqls = ModelTablePartialSqlGenerator.getAlterIndexesInfo(currentTableName, alterIndexEnum, tableColumns);
                            ddlTablePartialSqlParams.addAll(dirtyIndexPartialSqls);
                        }
                    });
                }
                boolean isChangePk = MapUtils.isNotEmpty(changedPkMap);
                log.info(_CLASSTAG + "[createCustomizeTableExpress] table({}), isChangeAutoIncrement({}), isChangePk({})", new Object[]{currentTableName, isChangeAutoIncrement, isChangePk});
                List<String> newPartialTableColumns = ModelTablePartialSqlGenerator.updateColumnsSqlParams(draftModelTable, actualModelTable, changedAutoIncrmtMap, dmlSqlParams);
                newPartialTableColumns.stream().filter(newSql -> ddlTablePartialSqlParams.stream().noneMatch(ddlSqlParam -> Objects.equals(ddlSqlParam, newSql))).forEach(filteredSql -> ddlTablePartialSqlParams.add((String)filteredSql));
                List<SqlParam> alterTableDDL = ModelTableSqlGenerator.getCombinedSqls(currentTableName, ddlTablePartialSqlParams);
                ddlSqlParams.addAll(alterTableDDL);
                List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(draftModelTable);
                dmlSqlParams.addAll(insertOrUpdateRdbmsFieldsParam);
                continue;
            }
            log.info(_CLASSTAG + "[createCustomizeTableExpress] table({}) is not existed", (Object)currentTableName);
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getCreateTable(draftModelTable);
            dmlSqlParams.addAll(tableSqlParamDTO.getDmlSqlParams());
            ddlSqlParams.addAll(tableSqlParamDTO.getDdlSqlParams());
        }
        boolean createSuccess = false;
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        String code = draftModel.getCode();
        SqlParam insertModelTableParam = ModelSqlGenerator.generateInsertModelSql(draftModel);
        dmlSqlParams.add(insertModelTableParam);
        LinkedList<SqlParam> insertModelInfoTableParam = ModelSqlGenerator.generateUpdateModelInfoSql(draftModelTables, code);
        dmlSqlParams.addAll(insertModelInfoTableParam);
        ModelCreateTypeEnum useExistedTable = draftModel.getUseExistedTable();
        ModelTable masterModelTable = ModelSchemaUtil.getCurrentLevelModelTable(draftModelSchema);
        BMProperties bmProperties = BMProperties.getProperties();
        SqlParam insertServiceMappingTableParam = null;
        if (useExistedTable != ModelCreateTypeEnum.EXISTED_TABLE) {
            if (bmProperties != null && bmProperties.isEnabled() && bmProperties.getRole() == BMRole.bmd) {
                ModelDrivenContext.getContext().setPublishedModel(draftModel);
                insertServiceMappingTableParam = BMDataModelSqlGenerator.generateInsertServiceMappingSql();
            } else {
                insertServiceMappingTableParam = ModelSqlGenerator.generateInsertServiceMappingSql(masterModelTable);
            }
            if (insertServiceMappingTableParam != null) {
                dmlSqlParams.add(insertServiceMappingTableParam);
            }
        }
        if ((executeCreateTableResult = this.dbExecuteService.executeCreateTableOfCreateModelDriven(ddlSqlParams, dmlSqlParams, draftModel)).getPublishStatusEnum() == PublishStatusEnum.SUCCESS) {
            boolean customizeApi;
            List<BindApi> bingApiListConfig = draftModelSchema.getBindApiListConfig();
            boolean bl = customizeApi = bingApiListConfig != null;
            if (!useExistedTable.equals((Object)ModelCreateTypeEnum.EXISTED_TABLE)) {
                String modelDrivenProdPrefix = (String)extraMap.getOrDefault("modelDrivenProdPrefix", "");
                List<DWEAIHeader> newEAIHeaders = this.eaiRegisterUtil.refreshEaiService(draftModelSchema, modelDrivenProdPrefix, code);
                log.info("code({}) isUseExistedTable({}), starting call register esp/nacos service", (Object)code, (Object)useExistedTable);
                if (bmProperties.isEnabled() && bmProperties.getRole() == BMRole.bmd) {
                    List<DWEAIHeader> newBMDataEaiHeaders = this.bmdEaiMethodRepository.getEaiHeaders();
                    this.eaiHeaderUtil.addAndUpdateDWEaiHeaders(newBMDataEaiHeaders);
                    this.nacosRegisterUtils.nacosServiceRegister(newBMDataEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
                } else {
                    Object regResult = this.eaiRegisterUtil.autoRegisterEAI(newEAIHeaders, code);
                    log.info(_CLASSTAG + " code({}) isUseExistedTable({}), finished call register esp service result({})", new Object[]{code, useExistedTable, regResult});
                }
            } else {
                log.debug("code({}) isUseExistedTable({})", (Object)code, (Object)useExistedTable);
            }
            createSuccess = true;
        }
        return DWServiceResultBuilder.build((boolean)createSuccess, (String)"", null);
    }

    public DBTableNameCheckResult getTableNamesGeneratedByModelDriven(String sql) throws JSQLParserException {
        List<String> queryTableNames = ModelSqlParserUtil.getTables(sql);
        List<String> distinctTableNames = this.dbExecuteService.getTableNamesGeneratedByModelDriven(queryTableNames);
        DBTableNameCheckResult checkResult = new DBTableNameCheckResult();
        if (queryTableNames.size() != distinctTableNames.size()) {
            checkResult.setSqlTableNames(queryTableNames);
            checkResult.setModelTableNames(distinctTableNames);
            checkResult.setPassed(false);
        }
        return checkResult;
    }

    public ModelTable getModelTableFromDB(String tableName) throws JSQLParserException {
        ModelTable actualModelTable = null;
        boolean isTableExist = this.dbExecuteService.checkTableExist(tableName);
        if (isTableExist) {
            List data = this.dbExecuteService.getCreateTableSqlByDBFunc(tableName);
            if (CollectionUtils.isEmpty((Collection)data)) {
                String errorMessage = String.format("[getModelTableFromDB] table(%s) existed but no create table sql data", tableName);
                log.error("{}[getModelTableFromDB] {}", (Object)_CLASSTAG, (Object)errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            log.info("[ModelTableHelperExpress][getModelTableFromDB] --> table({}) is existed", (Object)tableName);
            actualModelTable = new ModelTable();
            CreateTable ccjCreateTable = ModelSqlParserUtil.fetchCCJCreateTable(data);
            List createOptStrs = ccjCreateTable.getTableOptionsStrings();
            Table ccjTable = ccjCreateTable.getTable();
            String pureTableName = DBTableUtil.removeBackQuoteSymbol(ccjTable.getName());
            actualModelTable.setName(pureTableName);
            actualModelTable.setComment(ModelSqlParserUtil.getComment(ccjCreateTable));
            List ccjColumnDefinitions = ccjCreateTable.getColumnDefinitions();
            List ccjIndexes = Optional.ofNullable(ccjCreateTable.getIndexes()).orElse(new ArrayList());
            List<TableColumn> actualTableColumns = ModelSqlParserUtil.getTableColumns(ccjColumnDefinitions, ccjIndexes);
            actualModelTable.setColumns(actualTableColumns);
            List<TableIndex> existedTableIndexes = ModelSqlParserUtil.getTableIndexes(ccjIndexes);
            actualModelTable.setIndexes(existedTableIndexes);
            TableIndex pkTableIndex = existedTableIndexes.stream().filter(tableIndex -> tableIndex.getName().equals("PRIMARY KEY")).findFirst().orElse(null);
            if (pkTableIndex != null) {
                actualModelTable.setPk(pkTableIndex.getMember().stream().collect(Collectors.joining(",")));
            }
        }
        return actualModelTable;
    }

    public Map<String, Object> getModelTableFromDatabase(List<String> tableNames) throws JSQLParserException {
        HashMap<String, Object> actualModelTables = new HashMap<String, Object>();
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        for (String tableName : tableNames) {
            ModelTable actualModelTable = this.getModelTableFromDB(tableName);
            if (actualModelTable == null) continue;
            actualModelTables.put(tableName, actualModelTable);
            ModelTableSchemaCache publishedTableSchemaCache = ModelSchemaUtil.getModelTableSchemaCache(actualModelTable);
            publishedTableCache.put(tableName, publishedTableSchemaCache);
        }
        return actualModelTables;
    }
}

