/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenCommonsAutoConfiguration;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEaiRegProdSrvCondition;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenStandardEaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.listener.ModelDrivenApplicationListener;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMappingProvider;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDrivenEAIMappingService;
import com.digiwin.lcdp.modeldriven.utils.service.ServiceMappingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@AutoConfigureAfter(value={ModelDrivenCommonsAutoConfiguration.class})
public class ModelDrivenEAIRestfulUrlRegisterAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenEAIRestfulUrlRegisterAutoConfiguration.class);
    private static final String _CLASSTAG = "[" + ModelDrivenEAIRestfulUrlRegisterAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"dw-modeldriven-service-commons-mapping-provider"})
    @DependsOn(value={"dw-service-commons-provider"})
    public DWServiceMappingProvider eaiMappingProvider(@Qualifier(value="dw-modeldriven-commons-eai-mapping-service") ModelDrivenEAIMappingService eaiMappingService, @Qualifier(value="DWEAIServiceParser") DWEAIServiceDefinitionParser dwEaiServiceDefinitionParser, @Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider, @Qualifier(value="DWEAIHeaderRepository") DWEAIHeaderRepository dwEAIHeaderRepository, @Qualifier(value="modeldriven-tech-eaiheader") TechEaiData techEaiData, ModelDrivenStandardEaiHeaderUtil modelDrivenStandardEaiHeaderUtil) throws Exception {
        DWServiceMappingProvider eaiMappingProvider = new DWServiceMappingProvider();
        BMProperties properties = BMProperties.getProperties();
        if (properties == null || !properties.isEnabled()) {
            List serviceMappings = (List)eaiMappingService.getEAIList();
            log.info("{} serviceMapping: dw_service_mapping count:{} ", (Object)_CLASSTAG, (Object)serviceMappings.size());
            List<MappingModelInfo> mappingModelInfos = new ArrayList<MappingModelInfo>();
            if (serviceMappings.size() > 0) {
                mappingModelInfos = (List)eaiMappingService.getChildrenTable();
            }
            ServiceMappingUtil.updateProd(serviceMappings, mappingModelInfos);
            List<DWEAIHeader> newHeaders = modelDrivenStandardEaiHeaderUtil.updateAndGetModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
            HashMap<String, List<DWEAIHeader>> techEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
            techEaiHeaders.put(RegisterServiceTechTypeEnum.ESP.getTechType(), newHeaders);
            List espHeaders = techEaiData.getTechHeaders().getOrDefault(RegisterServiceTechTypeEnum.ESP.getTechType(), new ArrayList());
            espHeaders.addAll(espHeaders);
            log.info("{} serviceMapping: refreshed ModelDriven DWEAIHeader count:{} ", (Object)_CLASSTAG, (Object)newHeaders.size());
        }
        return eaiMappingProvider;
    }

    @Conditional(value={ModelDrivenEaiRegProdSrvCondition.class})
    @Bean
    public ModelDrivenApplicationListener buildModelDrivenApplicationListener() {
        return new ModelDrivenApplicationListener();
    }
}

