/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.registry;

import com.digiwin.lcdp.modeldriven.customize.config.NacosServiceRegisterEvent;
import com.digiwin.lcdp.modeldriven.customize.registry.BMAbstractRegistryApplicationListener;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.scheduling.annotation.Async;

public class BMBusinessLayerRegistryApplicationListener
extends BMAbstractRegistryApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(BMBusinessLayerRegistryApplicationListener.class);
    private static final String _CLASSTAG = "[" + BMBusinessLayerRegistryApplicationListener.class.getSimpleName() + "]";

    @Async
    public void onApplicationEvent(ApplicationEvent event) {
        log.debug("{}[onApplicationEvent] start ({})", (Object)_CLASSTAG, event.getClass());
        if (event instanceof NacosServiceRegisterEvent) {
            try {
                log.debug("{} process NacosServiceRegisterEvent", (Object)_CLASSTAG);
                this.nacosRegisterUtils.nacosServiceRegister((List)event.getSource());
            }
            catch (Exception e) {
                String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                log.error("{} nacos service register failed:{}", (Object)_CLASSTAG, (Object)errorRootCauseMessage);
                throw new RuntimeException("nacos service register failed", e);
            }
        }
        log.debug("{}[onApplicationEvent] end ({})", (Object)_CLASSTAG, event.getClass());
    }
}

