/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.extend.dap.documentId;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.data.exceptions.DWDataOptimisticLockingException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.dto.DocumentIdInfo;
import com.digiwin.exception.DWSerialLengthOutOfBoundsException;
import com.digiwin.lcdp.modeldriven.extend.dap.documentId.ModelDrivenDocumentIdFormatter;
import com.digiwin.lcdp.modeldriven.extend.dap.documentId.ModelDrivenDocumentIdSetting;
import com.digiwin.lcdp.modeldriven.utils.DBExecuteHandler;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.util.DocumentIdFinder;
import com.digiwin.util.DocumentIdSetting;
import com.digiwin.utils.DWTenantUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.transaction.annotation.Transactional;

public class ModelDrivenDocumentIdGenerator {
    private static final Log logger = LogFactory.getLog(ModelDrivenDocumentIdGenerator.class);
    private ModelDrivenDocumentIdFormatter formatter = new ModelDrivenDocumentIdFormatter();
    private String appId;
    @Autowired(required=false)
    private DocumentIdFinder finder;
    @Autowired(required=false)
    private DWRedisService redisTemplate;
    private String redisPrefixFolder = "DAP:DocumentId";

    @Value(value="${appId:}")
    public void setAppId(String appId) {
        this.appId = appId;
    }

    public ModelDrivenDocumentIdGenerator() {
        DWDao dao = this.getDefaultDao();
        DBExecuteHandler dbExecuteHandler = this.getDBExecuteHandler();
        boolean existedDocumentidTable = dbExecuteHandler.checkTableExist("dw_lcdp_documentid");
        if (!existedDocumentidTable) {
            String rdbmsTableSql = "insert into dw_rdbms_tables  (table_name, table_display_name, table_description, delete_constraint) values(?, ?, ?, 'N')";
            dao.update((IDWSQLOptions)ModelDataUtil.getDisabledCommonDataSetOperationOption(), rdbmsTableSql, new Object[]{"dw_lcdp_documentid", "dw_lcdp_documentid", "\u53d6\u53f7\u4e2d\u95f4\u8868"});
            String rdbmsFieldSql = "insert into dw_rdbms_fields  (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, default_value, nullable, is_version, size, scale, is_auto_increment)  values (?, ?, ?, ?, ?, 'Y', ?, ?, ?, ? , ?, ?, ?),(?, ?, ?, ?, ?, 'Y', ?, ?, ?, ? , ?, ?, ?),(?, ?, ?, ?, ?, 'Y', ?, ?, ?, ? , ?, ?, ?)";
            ArrayList params = new ArrayList();
            params.addAll(Arrays.stream(new Object[]{"dw_lcdp_documentid", 1, "groupkey", "Y", "VARCHAR", "\u952e\u540d", "null", "N", "N", 20, 0, "N", "dw_lcdp_documentid", 2, "groupvalue", "N", "BIGINT", "\u79df\u6236sid", "null", "Y", "N", 20, 0, "N", "dw_lcdp_documentid", 3, "version", "N", "VARCHAR", "\u6a02\u89c0\u9396", "null", "Y", "Y", 50, 0, "N"}).collect(Collectors.toList()));
            if (DWTenantUtils.isTenantenabled()) {
                rdbmsFieldSql = rdbmsFieldSql + ",(?, ?, ?, ?, ?, 'Y', ?, ?, ?, ? , ?, ?, ?)";
                params.addAll(Arrays.stream(new Object[]{"dw_lcdp_documentid", 4, DWTenantUtils.getTenantColumnName(), "Y", "BIGINT", "\u79df\u6236sid", "null", "Y", "N", 20, 0, "N"}).collect(Collectors.toList()));
            }
            dao.update((IDWSQLOptions)ModelDataUtil.getDisabledCommonDataSetOperationOption(), rdbmsFieldSql, params.toArray());
            String createDocumentidTable = String.format(" CREATE TABLE IF NOT EXISTS `dw_lcdp_documentid` ( `groupkey` VARCHAR(500) NOT NULL COMMENT '\u952e\u540d' COLLATE '%s',`groupvalue` BIGINT(20) NOT NULL DEFAULT 0 COMMENT '\u952e\u503c' COLLATE '%s',`version` VARCHAR(50) NOT NULL DEFAULT 1 COMMENT '\u6a02\u89c0\u9396' COLLATE '%s'," + (DWTenantUtils.isTenantenabled() ? "`" + DWTenantUtils.getTenantColumnName() + "` BIGINT(20) NULL DEFAULT NULL COMMENT '\u79df\u6236sid'," : "") + "PRIMARY KEY (`groupkey`) USING BTREE, " + "UNIQUE KEY (`groupkey`" + (DWTenantUtils.isTenantenabled() ? ", `" + DWTenantUtils.getTenantColumnName() + "`" : "") + ") USING BTREE) " + "COMMENT '\u53d6\u53f7\u4e2d\u95f4\u8868' COLLATE '%s' ", "utf8mb4_bin", "utf8mb4_bin", "utf8mb4_bin", "utf8mb4_bin");
            dao.update((IDWSQLOptions)ModelDataUtil.getDisabledCommonDataSetOperationOption(), createDocumentidTable, new Object[0]);
        }
    }

    public String getId(ModelDrivenDocumentIdSetting setting) throws Exception {
        if (setting != null && setting.getNumber() > 1) {
            throw new DWDataException("setting.setNumber can't greater than 1");
        }
        String result = this.generateId(setting).get(0);
        return result;
    }

    public List<String> getIdList(ModelDrivenDocumentIdSetting setting) throws Exception {
        List<String> result = this.generateId(setting);
        return result;
    }

    private List<String> generateId(ModelDrivenDocumentIdSetting setting) throws Exception {
        if (setting == null) {
            throw new DWDataException("DocumentIdSetting can'n be null ");
        }
        ArrayList<String> result = new ArrayList<String>();
        List<Long> serialIds = this.generateSerialId(setting);
        for (long serialId : serialIds) {
            result.add(this.formatter.format(serialId, setting));
            logger.debug((Object)("serialId:" + serialId));
        }
        return result;
    }

    @Transactional
    private List<Long> generateSerialId(DocumentIdSetting setting) throws Exception {
        long startId;
        long currentId;
        ArrayList<Long> result = new ArrayList<Long>();
        String redisKeyGroup = this.generateRedisKeyGroup(setting);
        if (this.redisTemplate == null) {
            int maxSeriaNo = 0;
            DWDao dao = this.getDefaultDao();
            DWQueryInfo queryInfo = new DWQueryInfo("dw_lcdp_documentid");
            queryInfo.addEqualInfo("groupkey", (Object)redisKeyGroup);
            DWDataSet daoResult = dao.select(queryInfo);
            DWDataTable documentidTable = daoResult.getTable("dw_lcdp_documentid");
            if (documentidTable.getRows() != null && documentidTable.getRows().size() > 0) {
                DWDataRow documentidRow = documentidTable.getRows().get(0);
                maxSeriaNo = ((Long)documentidRow.get("groupvalue")).intValue();
                currentId = maxSeriaNo + setting.getNumber();
                documentidRow.setState("U");
                documentidRow.set("groupvalue", (Object)currentId);
                try {
                    dao.execute(daoResult);
                }
                catch (Exception e) {
                    if (e instanceof DWDataOptimisticLockingException) {
                        this.generateSerialId(setting);
                    }
                    throw e;
                }
            } else {
                String documentId = this.finder.getMaxSerialNo(setting.getGroup(), setting);
                if (documentId != null && !documentId.equals("")) {
                    Method fetchSerialNoMethod = ((Object)((Object)this.formatter)).getClass().getDeclaredMethod("fetchSerialNo", String.class, DocumentIdSetting.class);
                    fetchSerialNoMethod.setAccessible(true);
                    maxSeriaNo = (Integer)fetchSerialNoMethod.invoke((Object)this.formatter, documentId, setting);
                }
                currentId = maxSeriaNo + setting.getNumber();
                try {
                    DWDataSetOperationOption option = new DWDataSetOperationOption();
                    option.setManagementFieldEnabled(false);
                    dao.update((IDWSQLOptions)option, String.format("insert into `dw_lcdp_documentid` (`groupkey`,`groupvalue` ${tenantName}) values(?,? ${tenantValue})", new Object[0]), new Object[]{redisKeyGroup, currentId});
                }
                catch (Exception e) {
                    if (e instanceof DWDataOptimisticLockingException) {
                        this.generateSerialId(setting);
                    }
                    throw e;
                }
            }
        } else {
            RedisTemplate origRedisTemplate = (RedisTemplate)this.redisTemplate.getOperator();
            String redisGroupLock = redisKeyGroup + ":lock";
            while (true) {
                DefaultRedisScript defaultRedisScript = new DefaultRedisScript();
                defaultRedisScript.setResultType(Long.class);
                defaultRedisScript.setScriptText("if redis.call('setnx', KEYS[1], ARGV[1]) == 1 then redis.call('pexpire', KEYS[1], ARGV[2]) return 1 else return 0 end");
                List<String> keyList = Arrays.asList(redisGroupLock);
                Long getLock = (Long)origRedisTemplate.execute((RedisScript)defaultRedisScript, keyList, new Object[]{1, 30000});
                if (getLock == 1L) {
                    if (!this.redisTemplate.hasKey(redisKeyGroup).booleanValue()) {
                        int maxSeriaNo = 0;
                        String documentId = this.finder.getMaxSerialNo(setting.getGroup(), setting);
                        if (documentId != null && !documentId.equals("")) {
                            Method fetchSerialNoMethod = ((Object)((Object)this.formatter)).getClass().getDeclaredMethod("fetchSerialNo", String.class, DocumentIdSetting.class);
                            fetchSerialNoMethod.setAccessible(true);
                            maxSeriaNo = (Integer)fetchSerialNoMethod.invoke((Object)this.formatter, documentId, setting);
                        }
                        if (!this.redisTemplate.set(redisKeyGroup, (Object)maxSeriaNo).booleanValue()) {
                            throw new Exception(String.format("%s generate documentid exception caused by redis set operation error", redisKeyGroup));
                        }
                    }
                    if (setting.isSerialLengthOutOfBoundsExceptionEnable()) {
                        Integer maxSeriaNo = Integer.parseInt(this.redisTemplate.get(redisKeyGroup).toString());
                        if ((maxSeriaNo = Integer.valueOf(maxSeriaNo + setting.getNumber())).toString().length() > setting.getSerialIdLength()) {
                            throw new DWSerialLengthOutOfBoundsException("serial length was out of bounds");
                        }
                    }
                    currentId = this.redisTemplate.incrBy(redisKeyGroup, (long)setting.getNumber());
                    origRedisTemplate.delete((Object)redisGroupLock);
                    break;
                }
                Thread.sleep(500L);
            }
        }
        for (long i = startId = currentId - (long)setting.getNumber() + 1L; i <= currentId; ++i) {
            result.add(i);
            logger.debug((Object)("Fetch redis serialNo=" + i));
        }
        return result;
    }

    public List<Map<String, Object>> deleteIdList(List<DocumentIdInfo> params) throws Exception {
        this.paramVarify(params);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (DocumentIdInfo param : params) {
            List ids = param.getIds();
            DocumentIdSetting setting = param.getSetting();
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (ids == null || ids.size() <= 0) continue;
            String redisKeyGroup = this.generateRedisKeyGroup(setting);
            Integer maxSeriaNo = 0;
            if (!this.redisTemplate.hasKey(redisKeyGroup).booleanValue()) {
                String documentId = this.finder.getMaxSerialNo(setting.getGroup(), setting);
                if (documentId != null && !documentId.equals("")) {
                    Method fetchSerialNoMethod = ((Object)((Object)this.formatter)).getClass().getDeclaredMethod("fetchSerialNo", String.class, DocumentIdSetting.class);
                    fetchSerialNoMethod.setAccessible(true);
                    maxSeriaNo = (Integer)fetchSerialNoMethod.invoke((Object)this.formatter, documentId, setting);
                }
                if (maxSeriaNo != 0) {
                    this.redisTemplate.set(redisKeyGroup, (Object)maxSeriaNo);
                }
            } else {
                maxSeriaNo = (Integer)this.redisTemplate.get(redisKeyGroup);
            }
            String[] keys = redisKeyGroup.split(":");
            if (maxSeriaNo == 0) {
                result.put("group", String.format("%s{%s}", keys[keys.length - 1], setting.getSerialIdLength()));
                result.put("maxSerialNo", maxSeriaNo);
                results.add(result);
                continue;
            }
            List idLst = ids.stream().map(id -> {
                try {
                    Method fetchSerialNoMethod = ((Object)((Object)this.formatter)).getClass().getDeclaredMethod("fetchSerialNo", String.class, DocumentIdSetting.class);
                    fetchSerialNoMethod.setAccessible(true);
                    return (Integer)fetchSerialNoMethod.invoke((Object)this.formatter, id, setting);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).sorted(Comparator.comparing(id -> id, (id1, id2) -> Integer.compare(id2, id1))).collect(Collectors.toList());
            Iterator iterator = idLst.iterator();
            boolean startMatchFlag = false;
            while (iterator.hasNext()) {
                if (iterator.next().equals(maxSeriaNo)) {
                    startMatchFlag = true;
                    Integer n = maxSeriaNo;
                    Integer n2 = maxSeriaNo = Integer.valueOf(maxSeriaNo - 1);
                    continue;
                }
                if (!startMatchFlag) continue;
            }
            this.redisTemplate.set(redisKeyGroup, (Object)maxSeriaNo);
            result.put("group", String.format("%s{%s}", keys[keys.length - 1], setting.getSerialIdLength()));
            result.put("maxSerialNo", maxSeriaNo);
            results.add(result);
        }
        return results;
    }

    private String generateRedisKeyGroup(DocumentIdSetting setting) throws Exception {
        StringBuilder redisKeyGroup = new StringBuilder();
        redisKeyGroup.append(this.redisPrefixFolder).append(":").append(this.appId).append(":");
        redisKeyGroup.append(setting.getTableName()).append(":").append(setting.getColumnName()).append(":");
        if (setting.isTenant()) {
            Map profile = DWServiceContext.getContext().getProfile();
            redisKeyGroup.append(profile.get(DWTenantUtils.getIAMTenantSidKey())).append(":");
        }
        String group = setting.getGroup();
        if (setting.isAccurateRuleMatchEnable()) {
            redisKeyGroup.append(group).append("{" + setting.getSerialIdLength() + "}").append(setting.getSuffix());
        } else {
            redisKeyGroup.append(group).append(setting.getSuffix());
        }
        logger.debug((Object)("current redisKeyGroup is " + redisKeyGroup.toString()));
        return redisKeyGroup.toString();
    }

    private void paramVarify(List<DocumentIdInfo> params) {
        if (params != null & params.size() > 0) {
            for (DocumentIdInfo param : params) {
                DocumentIdSetting setting = param.getSetting();
                String tableName = setting.getTableName();
                String columnName = setting.getColumnName();
                if (tableName == null || columnName == null) {
                    throw new RuntimeException("setting tableName or columnName can't be null");
                }
                param.getIds().forEach(id -> {
                    String settingGroup = "";
                    try {
                        settingGroup = setting.getGroup();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    String idGroup = id.substring(0, settingGroup.length());
                    String idSerialNoStr = id.substring(settingGroup.length(), id.lastIndexOf(setting.getSuffix()));
                    if (!idGroup.equals(settingGroup) || setting.isSerialLengthOutOfBoundsExceptionEnable() && idSerialNoStr.length() != setting.getSerialIdLength()) {
                        throw new RuntimeException(String.format("id :%s not match the setting pattern:%s{%s}", id, settingGroup, setting.getSerialIdLength()));
                    }
                });
            }
        }
    }

    private DWDao getDefaultDao() {
        DWDao defaultDao = (DWDao)SpringContextUtils.getBean((String)"dw-dao");
        return defaultDao;
    }

    private DBExecuteHandler getDBExecuteHandler() {
        DBExecuteHandler dbExecuteHandler = (DBExecuteHandler)SpringContextUtils.getBean((String)"DBExecuteHandler");
        return dbExecuteHandler;
    }
}

