/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.utils.ApiTypeUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class BMCodeUtil {
    public static BMCode getBMCodeByServiceName(Map<String, BMCode> bmCodes, String serviceName) {
        Optional<String> optionalMatchedServiceName = bmCodes.keySet().stream().filter(bmCodeServiceName -> StringUtils.equals((CharSequence)bmCodeServiceName, (CharSequence)serviceName)).findFirst();
        if (optionalMatchedServiceName.isPresent()) {
            return bmCodes.get(serviceName);
        }
        return null;
    }

    public static BMCode getBMCodeByModelCode(Map<String, BMCode> bmCodes, String modelCode) {
        BMCode returnValue = null;
        Collection<BMCode> allBMCodes = bmCodes.values();
        Optional<BMCode> optionalMatchedBMCode = allBMCodes.stream().filter(bmCode -> StringUtils.equals((CharSequence)modelCode, (CharSequence)bmCode.getCode())).findFirst();
        if (optionalMatchedBMCode.isPresent()) {
            returnValue = optionalMatchedBMCode.get();
        }
        return returnValue;
    }

    public static Map<String, BMCode> getBMDataLayerBMCodes(DWServiceMapping eaiService, List<DWEAIHeader> eaiHeaders, List<BindApi> apiListConfig, BMRole bmRole) {
        HashMap<String, BMCode> returnValue = new HashMap<String, BMCode>();
        String modelCode = eaiService.getCode();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String eaiTableName = eaiService.getTableName();
        boolean hasBindApiList = ModelDataUtil.hasBindApiConfig(apiListConfig);
        eaiHeaders.stream().forEach(eaiHeader -> {
            BMCode bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, bmRole);
            String apiType = ApiTypeUtil.getApiTypeForBMDataLayer(eaiHeader, apiListConfig, hasBindApiList);
            bmCode.setApiType(apiType);
            String eaiServiceId = eaiHeader.getEAIServiceId();
            returnValue.put(eaiServiceId, bmCode);
        });
        return returnValue;
    }

    public static Map<String, BMCode> getBMBusinessLayerBMCodes(DWServiceMapping eaiService, List<DWEAIHeader> eaiHeaders, List<BindApi> apiListConfig, BMRole bmRole) {
        HashMap<String, BMCode> returnValue = new HashMap<String, BMCode>();
        String modelCode = eaiService.getCode();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String eaiTableName = eaiService.getTableName();
        boolean hasBindApiList = ModelDataUtil.hasBindApiConfig(apiListConfig);
        eaiHeaders.stream().forEach(eaiHeader -> {
            BMCode bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, bmRole);
            String apiType = ApiTypeUtil.getApiTypeForBMDataLayer(eaiHeader, apiListConfig, hasBindApiList);
            bmCode.setApiType(apiType);
            String eaiServiceId = eaiHeader.getEAIServiceId();
            returnValue.put(eaiServiceId, bmCode);
        });
        return returnValue;
    }
}

