/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class SqlParserUtil {
    private static final Logger logger = LoggerFactory.getLogger(SqlParserUtil.class);
    private static final String _CLASSTAG = "[" + SqlParserUtil.class.getSimpleName() + "]";

    public static List<String> getSql(String sqlFilePath) {
        List<String> sqlArr = new ArrayList<String>();
        try {
            InputStreamReader isr = new InputStreamReader(SqlParserUtil.class.getClassLoader().getResourceAsStream(sqlFilePath), "UTF-8");
            String sqlStr = FileCopyUtils.copyToString((Reader)isr);
            sqlArr = Arrays.asList(sqlStr.split(";\r\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sqlArr;
    }

    public static Table getTableObj(String sql) throws Exception {
        Table targetTable = null;
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Select) {
            PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
            FromItem fromItem = select.getFromItem();
            if (fromItem instanceof Table) {
                targetTable = (Table)fromItem;
            } else {
                while (fromItem instanceof SubSelect && ((SubSelect)fromItem).getSelectBody() != null) {
                    SubSelect subSelect = (SubSelect)fromItem;
                    PlainSelect ssubSelect = (PlainSelect)subSelect.getSelectBody();
                    if (ssubSelect.getFromItem() instanceof Table) {
                        targetTable = (Table)ssubSelect.getFromItem();
                        break;
                    }
                    if (!(ssubSelect.getFromItem() instanceof SubSelect)) continue;
                    fromItem = ssubSelect.getFromItem();
                }
            }
        } else {
            throw new RuntimeException(String.format("sql is not a select statement:'%s'", sql));
        }
        logger.debug("{} get tableName '{}' from sql '{}'", new Object[]{_CLASSTAG, targetTable, sql});
        return targetTable;
    }

    public static String getMainTable(String sql) throws Exception {
        String tableName = "";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Select) {
            Table table = SqlParserUtil.getTableObj(sql);
            tableName = table.getName();
            logger.debug("{} get tableName '{}' from sql '{}'", new Object[]{_CLASSTAG, tableName, sql});
            return tableName;
        }
        throw new RuntimeException(String.format("%s sql is not a select statement:'%s'", _CLASSTAG, sql));
    }
}

