/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config.condition;

import com.digiwin.app.common.DWApplicationConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ModelDrivenEnabledLoadBalanceCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenEnabledLoadBalanceCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean isEnabledLoadBalance = ModelDrivenEnabledLoadBalanceCondition.isEnabledLoadBalance();
        return isEnabledLoadBalance;
    }

    public static boolean isEnabledLoadBalance() {
        String appPropertiesKey = "dwloadBalanceEnable";
        String appPropertiesValue = DWApplicationConfigUtils.getProperty((String)appPropertiesKey, (String)"false");
        boolean isLoadBalanceEnabled = Boolean.parseBoolean(appPropertiesValue);
        log.debug("[ModelDrivenLoadBalanceEnabledCondition] condition={} ({}={})", new Object[]{isLoadBalanceEnabled, appPropertiesKey, appPropertiesValue});
        return isLoadBalanceEnabled;
    }
}

