/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.dataview.utils;

import com.digiwin.app.service.DWEAIResult;
import com.digiwin.lcdp.modeldriven.eoc.ModelDrivenEocService;
import com.digiwin.lcdp.modeldriven.eoc.pojo.EmpInfoData;
import com.digiwin.lcdp.modeldriven.utils.QueryConditionUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganizationUtil {
    private static final Logger log = LoggerFactory.getLogger(QueryConditionUtils.class);
    @Autowired
    private ModelDrivenEocService modelDrivenEocService;

    public List getEmpId() {
        Object empInfoDataObject = null;
        String eocEmpId = null;
        try {
            empInfoDataObject = this.modelDrivenEocService.getEmpInfo();
            if (empInfoDataObject instanceof EmpInfoData) {
                EmpInfoData empInfoData = (EmpInfoData)empInfoDataObject;
                eocEmpId = empInfoData.getId();
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)empInfoDataObject;
                log.debug("eoc error code({}), message({})", (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(eocEmpId);
        return result;
    }

    public List getDeptId() {
        Object empInfoDataObject = null;
        String eocEmpDeptId = null;
        try {
            empInfoDataObject = this.modelDrivenEocService.getEmpInfo();
            if (empInfoDataObject instanceof EmpInfoData) {
                EmpInfoData empInfoData = (EmpInfoData)empInfoDataObject;
                eocEmpDeptId = empInfoData.getDepts().get(0).getId();
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)empInfoDataObject;
                log.debug("eoc error code({}), message({})", (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(eocEmpDeptId);
        return result;
    }

    public List getDeptIdAll() {
        Object deptIdsAllObject = null;
        try {
            deptIdsAllObject = this.modelDrivenEocService.getDeptIdAll();
            if (deptIdsAllObject instanceof List) {
                log.debug("eoc deptIds({}))", deptIdsAllObject);
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)deptIdsAllObject;
                log.debug("eoc error code({}), message({})", (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList result = new ArrayList();
        result.addAll((List)deptIdsAllObject);
        return result;
    }
}

