/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.dataview.utils;

import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.dataview.constant.DataViewConstant;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoSecondlyQueryConditionDTO;
import com.digiwin.lcdp.modeldriven.dataview.utils.DataViewDataTimeUtil;
import com.digiwin.lcdp.modeldriven.dataview.utils.OrganizationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemVariableUtil {
    @Autowired
    private DataViewDataTimeUtil dateTimeUtil;
    @Autowired
    private OrganizationUtil organizationUtil;

    public List<DWQueryField> getSystemVariableValue(DataViewInfoSecondlyQueryConditionDTO searchInfo) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        Iterator iterator = searchInfo.getSearch_value().iterator();
        while (iterator.hasNext()) {
            String searchValue = iterator.next().toString();
            String searchOperator = searchInfo.getSearch_operator();
            String searchField = searchInfo.getSearch_field();
            switch (searchValue) {
                case "{@SYSTEM_DATE_TODAY}": {
                    DWQueryField notEqualQueryField;
                    List currentDate = this.dateTimeUtil.getCurrentDate();
                    switch (searchOperator) {
                        case "equal": {
                            String format = "DATE_FORMAT(" + searchField + ", '%Y-%m-%d')";
                            DWQueryField equalQueryField = new DWQueryField(format, DWQueryValueOperator.Equals, new Object[]{currentDate});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            String formatNotEqual = "DATE_FORMAT(" + searchField + ", '%Y-%m-%d')";
                            notEqualQueryField = new DWQueryField(formatNotEqual, DWQueryValueOperator.NotEquals, new Object[]{currentDate});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot '%s' or '%s' operator", "{@SYSTEM_DATE_TODAY}", "equal", "not_equal"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_WEEK}": {
                    List currentWeek = this.dateTimeUtil.getCurrentWeek();
                    switch (searchOperator) {
                        case "equal": {
                            String formatDateWeek = "DATE_FORMAT(" + searchField + ", '%Y-%m-%d')";
                            DWQueryField equalQueryField = new DWQueryField(formatDateWeek, DWQueryValueOperator.Between, currentWeek.toArray(new Object[1]));
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            DWQueryField lessQueryField = new DWQueryField("DATE_FORMAT(" + searchField + ", '%Y-%m-%d')", DWQueryValueOperator.LessThan, new Object[]{currentWeek.get(0)});
                            DWQueryField greaterQueryField = new DWQueryField("DATE_FORMAT(" + searchField + ", '%Y-%m-%d')", DWQueryValueOperator.GreaterThan, new Object[]{currentWeek.get(1)});
                            result.add(lessQueryField);
                            result.add(greaterQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only support '%s' or '%s' operator", "{@SYSTEM_DATE_WEEK}", "equal", "not_equal"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_MONTH}": {
                    DWQueryField notEqualQueryField;
                    List currentMonth = this.dateTimeUtil.getCurrentMonth();
                    switch (searchOperator) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField("DATE_FORMAT(" + searchField + ", '%Y-%m')", DWQueryValueOperator.Equals, new Object[]{currentMonth});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            notEqualQueryField = new DWQueryField("DATE_FORMAT(" + searchField + ", '%Y-%m')", DWQueryValueOperator.NotEquals, new Object[]{currentMonth});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only support '%s' or '%s' operator", "{@SYSTEM_DATE_MONTH}", "equal", "not_equal"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_IN_7}": {
                    List valueDateIn7 = this.dateTimeUtil.getLast7Days();
                    switch (searchOperator) {
                        case "equal": {
                            String equalQueryField = new DWQueryField(searchField, DWQueryValueOperator.Between, valueDateIn7.toArray(new Object[1]));
                            result.add((DWQueryField)equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            DWQueryField lessQueryField = new DWQueryField(searchField, DWQueryValueOperator.LessThan, new Object[]{valueDateIn7.get(0)});
                            DWQueryField greaterQueryField = new DWQueryField(searchField, DWQueryValueOperator.GreaterThan, new Object[]{valueDateIn7.get(1)});
                            result.add(lessQueryField);
                            result.add(greaterQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only support '%s' or '%s' operator", "{@SYSTEM_DATE_IN_7}", "equal", "not_equal"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_TENANT_SID}": {
                    Object valueTenantSid = this.getTenantSid();
                    String formatTenantSid = searchField;
                    switch (searchOperator) {
                        case "equal": {
                            String equalQueryField = new DWQueryField(formatTenantSid, DWQueryValueOperator.Equals, new Object[]{valueTenantSid});
                            result.add((DWQueryField)equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            String notEqualQueryField = new DWQueryField(formatTenantSid, DWQueryValueOperator.NotEquals, new Object[]{valueTenantSid});
                            result.add((DWQueryField)notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only support '%s' or '%s' operator", "{@SYSTEM_TENANT_SID}", "equal", "not_equal"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_USER_ID}": {
                    Object valueUserId = this.getUserId();
                    String formatUserId = searchField;
                    switch (searchOperator) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField(formatUserId, DWQueryValueOperator.Equals, new Object[]{valueUserId});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            DWQueryField notEqualQueryField = new DWQueryField(formatUserId, DWQueryValueOperator.NotEquals, new Object[]{valueUserId});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only support '%s' or '%s' operator", "{@SYSTEM_USER_ID}", "equal", "not_equal"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_ID}": {
                    switch (searchOperator) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField(searchField, DWQueryValueOperator.In, this.organizationUtil.getEmpId().toArray(new Object[1]));
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            String[] fields = searchField.split("\\.");
                            DWQueryField notEqualQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, this.organizationUtil.getEmpId().toArray(new Object[1]));
                            notEqualQueryField.setTableName(searchInfo.getTable_name());
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only support '%s' or '%s' operator", "{@SYSTEM_EMPLOYEE_ID}", "equal", "not_equal"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID}": {
                    Object[] deptIdObjs = this.organizationUtil.getDeptId().toArray(new Object[1]);
                    switch (searchOperator) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField(searchField, DWQueryValueOperator.In, deptIdObjs);
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            String[] fields = searchField.split("\\.");
                            DWQueryField notEqualQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, deptIdObjs);
                            notEqualQueryField.setTableName(searchInfo.getTable_name());
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only support '%s' or '%s' operator", "{@SYSTEM_EMPLOYEE_DEPTID}", "equal", "not_equal"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID_ALL}": {
                    Object[] deptIdAllObjs = this.organizationUtil.getDeptIdAll().toArray(new Object[1]);
                    switch (searchOperator) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField(searchField, DWQueryValueOperator.In, deptIdAllObjs);
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            String[] fields = searchField.split("\\.");
                            DWQueryField notEqualQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, deptIdAllObjs);
                            notEqualQueryField.setTableName(searchInfo.getTable_name());
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only support '%s' or '%s' operator", "{@SYSTEM_EMPLOYEE_DEPTID_ALL}", "equal", "not_equal"));
                        }
                    }
                    iterator.remove();
                    break;
                }
            }
        }
        return result;
    }

    public void replaceSystemVariable(StringBuilder sql) {
        String shouldModifySql2 = sql.toString();
        block22: for (String systemVar : DataViewConstant.SQL_QUERY_PROJECT_SYSTEM_VAR) {
            if (!shouldModifySql2.contains(systemVar)) continue;
            switch (systemVar) {
                case "{@SYSTEM_DATE_TODAY}": {
                    Object systemTodayValue = this.getValueSystemVariable(systemVar);
                    String targetTodayValue = systemTodayValue == null ? "null" : (systemTodayValue instanceof String ? "'" + systemTodayValue + "'" : (systemTodayValue instanceof Date ? "'" + DataViewConstant.sqlDateTimeFormat.format(systemTodayValue) + "'" : systemTodayValue.toString()));
                    Matcher systemTodayMatcher = DataViewConstant.SYSTEM_DATE_TODAY_PATTERN.matcher(shouldModifySql2);
                    if (!systemTodayMatcher.find()) break;
                    shouldModifySql2 = systemTodayMatcher.replaceAll(targetTodayValue);
                    break;
                }
                case "{@SYSTEM_DATE_WEEK}": {
                    List valueWeek = (List)this.getValueSystemVariable(systemVar);
                    String weekConditionStart = String.format("%s '%s' AND '%s'", DWQueryValueOperator.Between, valueWeek.get(0), valueWeek.get(1));
                    Matcher systemDateWeekMatcher = DataViewConstant.SYSTEM_DATE_WEEK_PATTERN.matcher(shouldModifySql2);
                    if (!systemDateWeekMatcher.find()) break;
                    shouldModifySql2 = systemDateWeekMatcher.replaceAll(weekConditionStart);
                    break;
                }
                case "{@SYSTEM_DATE_MONTH}": {
                    Object valueMonth = this.getValueSystemVariable(systemVar);
                    String targetMonthValue = valueMonth == null ? "null" : (valueMonth instanceof String ? "'" + valueMonth + "'" : (valueMonth instanceof Date ? "'" + DataViewConstant.sqlDateTimeFormat.format(valueMonth) + "'" : valueMonth.toString()));
                    Matcher systemDateMonthMatcher = DataViewConstant.SYSTEM_DATE_MONTH_PATTERN.matcher(shouldModifySql2);
                    if (!systemDateMonthMatcher.find()) break;
                    shouldModifySql2 = systemDateMonthMatcher.replaceAll(targetMonthValue);
                    break;
                }
                case "{@SYSTEM_DATE_IN_7}": {
                    List valueDateIn7 = (List)this.getValueSystemVariable(systemVar);
                    String dateIn7ConditionStart = String.format("%s '%s' AND '%s'", DWQueryValueOperator.Between, valueDateIn7.get(0), valueDateIn7.get(1));
                    Matcher dateIn7Matcher = DataViewConstant.SYSTEM_DATE_IN_7_PATTERN.matcher(shouldModifySql2);
                    if (!dateIn7Matcher.find()) break;
                    shouldModifySql2 = dateIn7Matcher.replaceAll(dateIn7ConditionStart);
                    break;
                }
                case "{@SYSTEM_TENANT_SID}": {
                    Object valueTenantSid = this.getValueSystemVariable(systemVar);
                    String targetTenantSidValue = valueTenantSid == null ? "null" : (valueTenantSid instanceof String ? "'" + valueTenantSid + "'" : (valueTenantSid instanceof Date ? "'" + DataViewConstant.sqlDateTimeFormat.format(valueTenantSid) + "'" : valueTenantSid.toString()));
                    Matcher systemTenantSidMatcher = DataViewConstant.SYSTEM_TENANT_SID_PATTERN.matcher(shouldModifySql2);
                    if (!systemTenantSidMatcher.find()) break;
                    shouldModifySql2 = systemTenantSidMatcher.replaceAll(targetTenantSidValue);
                    break;
                }
                case "{@SYSTEM_USER_ID}": {
                    Object value = this.getValueSystemVariable(systemVar);
                    String targetValue = value == null ? "null" : (value instanceof String ? "'" + value + "'" : (value instanceof Date ? "'" + DataViewConstant.sqlDateTimeFormat.format(value) + "'" : value.toString()));
                    Matcher systemUserIdMatcher = DataViewConstant.SYSTEM_USER_ID_PATTERN.matcher(shouldModifySql2);
                    if (!systemUserIdMatcher.find()) break;
                    shouldModifySql2 = systemUserIdMatcher.replaceAll(targetValue);
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_ID}": {
                    Matcher systemEmpIdMatcher;
                    Object valueEmpIdParam = this.getValueSystemVariable(systemVar);
                    String targetEmpIdValue = "";
                    if (valueEmpIdParam instanceof Object[]) {
                        Object empData = ((Object[])valueEmpIdParam)[0];
                        String string = targetEmpIdValue = empData == null ? "null" : "'" + empData + "'";
                    }
                    if (!(systemEmpIdMatcher = DataViewConstant.SYSTEM_EMPLOYEE_ID_PATTERN.matcher(shouldModifySql2)).find()) break;
                    shouldModifySql2 = systemEmpIdMatcher.replaceAll(targetEmpIdValue);
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID}": {
                    Object valueEmpDeptIdParam = this.getValueSystemVariable(systemVar);
                    String targetEmpDeptIdValue = "";
                    if (!(valueEmpDeptIdParam instanceof Object[])) break;
                    Object empDeptData = ((Object[])valueEmpDeptIdParam)[0];
                    String string = targetEmpDeptIdValue = empDeptData == null ? "null" : "'" + empDeptData + "'";
                    Matcher systemEmpDeptIdMatcher = DataViewConstant.SYSTEM_EMPLOYEE_DEPTID_PATTERN.matcher(shouldModifySql2);
                    if (!systemEmpDeptIdMatcher.find()) continue block22;
                    shouldModifySql2 = systemEmpDeptIdMatcher.replaceAll(targetEmpDeptIdValue);
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID_ALL}": {
                    Object valueEmpDeptIdAll = this.getValueSystemVariable(systemVar);
                    List<Object> empDeptIdAll = new ArrayList();
                    if (valueEmpDeptIdAll instanceof Object[]) {
                        empDeptIdAll = Arrays.asList((Object[])valueEmpDeptIdAll);
                    }
                    ArrayList<String> targetEmpDeptAll = new ArrayList<String>();
                    for (Object empDeptId : empDeptIdAll) {
                        String empDeptIdValuePartial = empDeptId == null ? "null" : (empDeptId instanceof String ? "'" + empDeptId + "'" : empDeptId.toString());
                        targetEmpDeptAll.add(empDeptIdValuePartial);
                    }
                    if (!CollectionUtils.isNotEmpty(targetEmpDeptAll)) break;
                    String targetEmpDeptIdAllValue = String.join((CharSequence)", ", targetEmpDeptAll);
                    Matcher systemEmpDeptIdAllMatcher = DataViewConstant.SYSTEM_EMPLOYEE_DEPTID_ALL_PATTERN.matcher(shouldModifySql2);
                    if (!systemEmpDeptIdAllMatcher.find()) continue block22;
                    shouldModifySql2 = systemEmpDeptIdAllMatcher.replaceAll(targetEmpDeptIdAllValue);
                    break;
                }
            }
        }
        sql.setLength(0);
        sql.append(shouldModifySql2);
    }

    public Object getValueSystemVariable(String systemVariable) {
        Object returnValue = null;
        switch (systemVariable) {
            case "{@SYSTEM_TENANT_SID}": {
                returnValue = this.getTenantSid();
                break;
            }
            case "{@SYSTEM_USER_ID}": {
                returnValue = this.getUserId();
                break;
            }
            case "{@SYSTEM_EMPLOYEE_ID}": {
                returnValue = this.getEmpId();
                break;
            }
            case "{@SYSTEM_EMPLOYEE_DEPTID}": {
                returnValue = this.getEmpDeptId();
                break;
            }
            case "{@SYSTEM_EMPLOYEE_DEPTID_ALL}": {
                returnValue = this.getEmpDeptIdAll();
                break;
            }
            case "{@SYSTEM_DATE_TODAY}": {
                returnValue = this.dateTimeUtil.getCurrentDate().get(0);
                break;
            }
            case "{@SYSTEM_DATE_WEEK}": {
                returnValue = this.dateTimeUtil.getCurrentWeek();
                break;
            }
            case "{@SYSTEM_DATE_MONTH}": {
                returnValue = this.dateTimeUtil.getCurrentMonth().get(0);
                break;
            }
            case "{@SYSTEM_DATE_IN_7}": {
                returnValue = this.dateTimeUtil.getLast7Days();
                break;
            }
        }
        return returnValue;
    }

    public Object getTenantSid() {
        Object tenantSid = DWServiceContext.getContext().getProfile().get(ModelDBConstants.IAM_PROFILE_TENANT_SID);
        return tenantSid;
    }

    public Object getUserId() {
        Object userId = DWServiceContext.getContext().getProfile().get("userId");
        return userId;
    }

    public Object getEmpId() {
        Object[] empId = this.organizationUtil.getEmpId().toArray(new Object[1]);
        return empId;
    }

    public Object getEmpDeptId() {
        Object[] empId = this.organizationUtil.getDeptId().toArray(new Object[1]);
        return empId;
    }

    public Object getEmpDeptIdAll() {
        Object[] empId = this.organizationUtil.getDeptIdAll().toArray(new Object[1]);
        return empId;
    }
}

