/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.service.ServiceMappingUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EaiHeaderUtil {
    private static final Logger log = LoggerFactory.getLogger(EaiHeaderUtil.class);
    private static final String _CLASSTAG = "[" + EaiHeaderUtil.class.getSimpleName() + "]";
    @Autowired
    DWEAIHeaderRepository dwEAIHeaderRepository;
    @Autowired
    DWEAIServiceDefinitionParser dwEaiServiceDefinitionParser;
    @Autowired
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;
    @Autowired
    @Qualifier(value="dw-modeldriven-crud-eai-builder")
    ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-crud-eai-builder")
    EaiHeaderBuilder customizeEAIHeaderBuilder;
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bmmix-builder")
    EaiHeaderBuilder bmMixEAIHeaderBuilder;

    public Map<String, List<DWEAIHeader>> genServiceDiscoveryModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        Map<String, List<DWEAIHeader>> techEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
        List<Object> newEaiHeaders = new ArrayList();
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties == null || !bmProperties.isEnabled()) {
            newEaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.modelStandardEAIHeaderBuilder);
            return techEaiHeaders;
        }
        techEaiHeaders = this.genServiceDiscoveryModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.customizeEAIHeaderBuilder);
        return techEaiHeaders;
    }

    public List<TechEaiData> genTechDataServiceDiscoveryModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        List<TechEaiData> techEaiHeaders = this.genTechEaiDataServiceDiscoveryModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.customizeEAIHeaderBuilder);
        return techEaiHeaders;
    }

    public List<DWEAIHeader> genModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        List<Object> newEaiHeaders = new ArrayList();
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties == null || !bmProperties.isEnabled()) {
            newEaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.modelStandardEAIHeaderBuilder);
            return newEaiHeaders;
        }
        newEaiHeaders = bmProperties.getRole() == BMRole.mix ? this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.bmMixEAIHeaderBuilder) : this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.customizeEAIHeaderBuilder);
        return newEaiHeaders;
    }

    public List<DWEAIHeader> genModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos, EaiHeaderBuilder eaiHeaderBuilder) throws Exception {
        log.info("{} genEaiHeaders using {}", (Object)_CLASSTAG, (Object)eaiHeaderBuilder.toString());
        List<DWEAIHeader> newEaiHeaders = eaiHeaderBuilder.getEaiHeaders(serviceMappings, mappingModelInfos);
        return newEaiHeaders;
    }

    public Map<String, List<DWEAIHeader>> genServiceDiscoveryModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos, EaiHeaderBuilder eaiHeaderBuilder) throws Exception {
        log.info("{} genEaiHeaders using {}", (Object)_CLASSTAG, (Object)eaiHeaderBuilder.toString());
        Map<String, List<DWEAIHeader>> allProdEaiHeaders = eaiHeaderBuilder.getTechEaiHeaders(serviceMappings, mappingModelInfos);
        return allProdEaiHeaders;
    }

    public List<TechEaiData> genTechEaiDataServiceDiscoveryModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos, EaiHeaderBuilder eaiHeaderBuilder) throws Exception {
        log.info("{} genEaiHeaders using {}", (Object)_CLASSTAG, (Object)eaiHeaderBuilder.toString());
        List<TechEaiData> allProdEaiHeaders = eaiHeaderBuilder.getTechEaiData(serviceMappings, mappingModelInfos);
        return allProdEaiHeaders;
    }

    public List<DWEAIHeader> updateAndGetModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        List<DWEAIHeader> newEaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
        if (CollectionUtils.isNotEmpty(newEaiHeaders)) {
            this.addAndUpdateCommonsHeaders(newEaiHeaders);
        }
        return newEaiHeaders;
    }

    public void addAndUpdateCommonsHeaders(List<DWEAIHeader> candidateEaiHeaders) throws Exception {
        if (CollectionUtils.isNotEmpty(candidateEaiHeaders)) {
            List orgModelDrivenDWEAIHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
            int candidateEaiHeaderCount = candidateEaiHeaders.size();
            int orgInitHeaderCount = orgModelDrivenDWEAIHeaders.size();
            List existedOrgDWHeaders = orgModelDrivenDWEAIHeaders.stream().filter(orgDWHeader -> candidateEaiHeaders.stream().anyMatch(candiHeader -> StringUtils.equals((CharSequence)((DWEAIHeader)orgDWHeader).getEAIServiceId(), (CharSequence)candiHeader.getEAIServiceId()))).collect(Collectors.toList());
            List existedEaiHeaderNames = existedOrgDWHeaders.stream().map(oldEaiHeader -> ((DWEAIHeader)oldEaiHeader).getEAIServiceId()).collect(Collectors.toList());
            int duplicatedCount = existedEaiHeaderNames.size();
            log.info("{} duplicate dwEaiHeader names size:{}({})", new Object[]{_CLASSTAG, existedEaiHeaderNames.size(), existedEaiHeaderNames});
            log.info("{}[init] orgHeaderCount({}), candidateHeaderCount({}), duplicatedCount({})", new Object[]{_CLASSTAG, orgModelDrivenDWEAIHeaders.size(), candidateEaiHeaderCount, duplicatedCount});
            List newEaiHeaders = candidateEaiHeaders.stream().filter(candiHeader -> !existedEaiHeaderNames.contains(candiHeader.getEAIServiceId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newEaiHeaders)) {
                orgModelDrivenDWEAIHeaders.addAll(newEaiHeaders);
                Method registerHeaderMethod = ModelDrivenMethodHelper.getRegisterHeaderAccessibleOfDWEAIServiceDefinitionParser();
                registerHeaderMethod.invoke((Object)this.dwEaiServiceDefinitionParser, "commons", orgModelDrivenDWEAIHeaders);
                log.debug("{}[addAndUpdateDWEaiHeaders] added to eai repo({}): {}", new Object[]{_CLASSTAG, newEaiHeaders.size(), newEaiHeaders.stream().map(newEaiHeader -> newEaiHeader.getEAIServiceId()).collect(Collectors.toList())});
                log.info("{}[addAndUpdateDWEaiHeaders] refreshed eai repo, total({}) = org({}) + (candidateEaiHeader({}) - duplicated({}))", new Object[]{_CLASSTAG, orgModelDrivenDWEAIHeaders.size(), orgInitHeaderCount, candidateEaiHeaderCount, duplicatedCount});
            } else {
                log.debug("{}[addAndUpdateDWEaiHeaders] ignored to add to eai repo(filtered new:{}, cadidate:{})", new Object[]{_CLASSTAG, newEaiHeaders.size(), candidateEaiHeaderCount});
            }
            log.info("{}[addAndUpdateDWEaiHeaders] orgHeaderCount({})= initOrgHeaderCount({}) + newEaiHeaders({})", new Object[]{_CLASSTAG, orgModelDrivenDWEAIHeaders.size(), orgInitHeaderCount, newEaiHeaders.size()});
        } else {
            log.info("{}[addAndUpdateDWEaiHeaders] ignored to refresh eai repo, cause empty newEaiHeaders.", (Object)_CLASSTAG);
        }
    }

    public List<DWHeader> getDropEaiHeaders(List<DWEAIHeader> draftEaiHeaders, List<DWHeader> actualHeaders) {
        List<Object> dropEaiHeaders = new ArrayList<DWHeader>();
        if (CollectionUtils.isNotEmpty(actualHeaders)) {
            dropEaiHeaders = actualHeaders.stream().filter(actual -> draftEaiHeaders.stream().noneMatch(draft -> ((DWEAIHeader)actual).getEAIServiceId().equals(draft.getEAIServiceId()))).collect(Collectors.toList());
            int dropHeaderCount = dropEaiHeaders.size();
            log.info("{}[addAndUpdateDWEaiHeaders] drop size({}) ({})", new Object[]{_CLASSTAG, dropHeaderCount, dropEaiHeaders});
        } else {
            log.info("{} ignored drop any DWEAIHeader", (Object)_CLASSTAG);
        }
        return dropEaiHeaders;
    }

    public void executeDropExistedEaiHeaders(List<DWHeader> dropEaiHeaders) {
        List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
        int repoBefore = orgDWHeaders.size();
        dropEaiHeaders.stream().forEach(dropDWHeader -> orgDWHeaders.remove(dropDWHeader));
        List dropList = dropEaiHeaders.stream().map(dropEaiHeader -> ((DWEAIHeader)dropEaiHeader).getEAIServiceId()).collect(Collectors.toList());
        int repoAfter = orgDWHeaders.size();
        log.info("{} drop DWEAIHeaderRepository--> dropped({},{})(dwEAIHeaderRepo: before({}), after({}))", new Object[]{_CLASSTAG, dropList.size(), dropList, repoBefore, orgDWHeaders.size()});
    }

    public List<DWEAIHeader> getAddEaiHeaders(List<DWEAIHeader> draftEaiHeaders, List<DWHeader> actualHeaders) {
        List<Object> addEaiHeaders = new ArrayList();
        addEaiHeaders = draftEaiHeaders.stream().filter(draft -> actualHeaders.stream().noneMatch(actual -> Objects.equals(draft.getEAIServiceId(), ((DWEAIHeader)actual).getEAIServiceId()))).collect(Collectors.toList());
        int dropHeaderCount = addEaiHeaders.size();
        log.info("{} drop size({}) ({})", new Object[]{_CLASSTAG, dropHeaderCount, addEaiHeaders});
        return addEaiHeaders;
    }

    public List<DWEAIHeader> genServiceModelInfoData(ModelSchemaDTO masterModelSchema, String modelDrivenProdPrefix, String code) throws Exception {
        String masterTableName = masterModelSchema.getName();
        String userExposePrefixEaiId = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, masterTableName);
        String modelSchemaStr = ModelDataUtil.getModelSchemaStr(masterModelSchema);
        List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(masterModelSchema.getChildren());
        DWServiceMapping serviceMapping = new DWServiceMapping();
        serviceMapping.setTableName(masterTableName);
        serviceMapping.setExposeEaiId(userExposePrefixEaiId);
        serviceMapping.setModelSchema(modelSchemaStr);
        serviceMapping.setCode(code);
        ArrayList<DWServiceMapping> serviceMappings = new ArrayList<DWServiceMapping>();
        serviceMappings.add(serviceMapping);
        List<MappingModelInfo> mappingModelInfos = ModelDataUtil.getChildrenMappingModelInfo(allChildrenSchemas, masterTableName, userExposePrefixEaiId, code);
        ServiceMappingUtil.updateProd(serviceMappings, mappingModelInfos);
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties != null && bmProperties.isEnabled()) {
            BMCenterUtil.modifyServiceMapping(serviceMappings);
            BMCenterUtil.modifyMappingModelInfo(mappingModelInfos);
        }
        List<DWEAIHeader> eaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
        return eaiHeaders;
    }

    public List<DWHeader> getExistedEaiHeaders(List<DWEAIHeader> dweaiHeaders) {
        List<Object> existedEaiHeaders = new ArrayList<DWHeader>();
        if (CollectionUtils.isNotEmpty(dweaiHeaders)) {
            List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
            existedEaiHeaders = orgDWHeaders.stream().filter(orgDWHeader -> orgDWHeader instanceof DWEAIHeader && dweaiHeaders.stream().anyMatch(dweaiHeader -> ((DWEAIHeader)orgDWHeader).getEAIServiceId().equals(dweaiHeader.getEAIServiceId()))).collect(Collectors.toList());
            log.info("{} get existedEaiHeaders({} from DWEAIHeaderRepository({}({})))", new Object[]{_CLASSTAG, existedEaiHeaders.size(), "commons", orgDWHeaders.size()});
        } else {
            log.info("{} ignored get existedEaiHeaders  from DWEAIHeaderRepository", (Object)_CLASSTAG);
        }
        return existedEaiHeaders;
    }

    public String getTableName(String serviceName, String serviceProdfix) {
        BMCode bmCode = this.bmCodes.getOrDefault(serviceName, null);
        String tableName = bmCode != null ? bmCode.getTableName() : "";
        return tableName;
    }

    public List<DWEAIHeader> refreshEaiService(ModelSchemaDTO masterModelSchema, String modelDrivenProdPrefix, String code) throws Exception {
        List<DWEAIHeader> newEaiHeaders = this.genServiceModelInfoData(masterModelSchema, modelDrivenProdPrefix, code);
        this.addAndUpdateCommonsHeaders(newEaiHeaders);
        return newEaiHeaders;
    }

    public List<DWHeader> getCommonsEaiHeaders() {
        List modelDrivenGroupHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
        return modelDrivenGroupHeaders;
    }

    public List<DWEAIHeader> getNacosHeadersCombindCommons(Map<String, List<DWEAIHeader>> prodEaiHeaders, String prod) throws Exception {
        String nacosTech = RegisterServiceTechTypeEnum.NACOS.getTechType();
        List nacosEaiHeaders = prodEaiHeaders.computeIfAbsent(nacosTech, key -> new ArrayList());
        List<DWHeader> modelDrivenGroupHeaders = this.getCommonsEaiHeaders();
        modelDrivenGroupHeaders.stream().filter(commonsEaiHeader -> nacosEaiHeaders.stream().noneMatch(newNacosHeader -> ((DWEAIHeader)commonsEaiHeader).getEAIServiceId().equals(newNacosHeader.getEAIServiceId()))).forEach(commonsEaiHeader -> nacosEaiHeaders.add((DWEAIHeader)commonsEaiHeader));
        return nacosEaiHeaders;
    }
}

