/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.pojo.ExceptionSQLInfo;
import com.digiwin.lcdp.modeldriven.report.model.SqlValueFields;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDataEntryService;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenCCJParserUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.SqlParserUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModelSqlParserUtil {
    private static final Logger logger = LoggerFactory.getLogger(ModelSqlParserUtil.class);
    private static final String _CLASSTAG = "[" + ModelSqlParserUtil.class.getSimpleName() + "]";
    private static final SimpleDateFormat bindedSqlDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static List<String> getTables(String sql) throws JSQLParserException {
        Statement ccjStatement = CCJSqlParserUtil.parse((String)sql);
        Select selectStatement = (Select)ccjStatement;
        TablesNamesFinder tableFinder = new TablesNamesFinder();
        List tables = tableFinder.getTableList((Statement)selectStatement);
        return tables;
    }

    public static CreateTable fetchCCJCreateTable(List data) throws JSQLParserException {
        Map rowMap = (Map)data.get(0);
        String createTableSql = (String)rowMap.get("Create Table");
        Statement statement = CCJSqlParserUtil.parse((String)createTableSql);
        CreateTable ccjCreateTable = (CreateTable)statement;
        return ccjCreateTable;
    }

    public static boolean fetchCCJNullable(List<String> cjColumnDefSpecs) {
        String columnSpecsString = "";
        if (CollectionUtils.isNotEmpty(cjColumnDefSpecs)) {
            columnSpecsString = cjColumnDefSpecs.stream().collect(Collectors.joining(" "));
        }
        return !StringUtils.containsIgnoreCase((CharSequence)columnSpecsString, (CharSequence)"not null");
    }

    public static void processSizeScale(ColumnDefinition columnDefinition, TableColumn tableColumn) {
        List argumentsStringList = columnDefinition.getColDataType().getArgumentsStringList();
        if (CollectionUtils.isNotEmpty((Collection)argumentsStringList)) {
            if (argumentsStringList.size() == 1 && NumberUtils.isDigits((String)((String)argumentsStringList.get(0)))) {
                tableColumn.setSize(Integer.valueOf((String)argumentsStringList.get(0)));
            }
            if (argumentsStringList.size() == 2) {
                if (NumberUtils.isDigits((String)((String)argumentsStringList.get(0)))) {
                    tableColumn.setSize(Integer.valueOf((String)argumentsStringList.get(0)));
                }
                if (NumberUtils.isDigits((String)((String)argumentsStringList.get(1)))) {
                    tableColumn.setScale(Integer.valueOf((String)argumentsStringList.get(1)));
                }
            }
        }
    }

    public static void setDefaultValue(List<String> cjColumnDefSpecs, TableColumn tableColumn) {
        String defaultKey = "DEFAULT";
        String dataTypeName = tableColumn.getDataType().getName();
        if (cjColumnDefSpecs.contains(defaultKey)) {
            String defaultValue;
            int defaultPosition = cjColumnDefSpecs.indexOf(defaultKey);
            String defaultTypeDef = cjColumnDefSpecs.get(defaultPosition + 1);
            if (dataTypeName.toUpperCase().equals(DataTypeEnum.BIT.getName()) && defaultTypeDef != null && defaultTypeDef.startsWith("b'") && defaultTypeDef.endsWith("'")) {
                defaultTypeDef = defaultTypeDef.replaceFirst("b", "");
            }
            if ("NULL".equalsIgnoreCase(defaultValue = DBTableUtil.removeApostropheSymbol(defaultTypeDef))) {
                defaultValue = null;
            }
            tableColumn.setDefaultValue(defaultValue);
            if (StringUtils.containsIgnoreCase((CharSequence)defaultValue, (CharSequence)"current_timestamp")) {
                tableColumn.setDefaultValueIsExpr(true);
                tableColumn.setDefaultValueType("expression");
                logger.debug("{} columnName({}) {}={}", new Object[]{_CLASSTAG, tableColumn.getColumnName(), defaultKey, defaultValue});
            }
        }
    }

    public static String getComment(CreateTable ccjCreateTable) {
        List createOptStrs = ccjCreateTable.getTableOptionsStrings();
        String commentKey = "COMMENT";
        String comment = "";
        if (createOptStrs.contains(commentKey)) {
            int commentPosition = createOptStrs.indexOf(commentKey);
            comment = DBTableUtil.removeApostropheSymbol((String)createOptStrs.get(commentPosition + 2));
            logger.debug(_CLASSTAG + "comment={}", (Object)comment);
        }
        return comment;
    }

    public static List<String> getTableColumnNames(CreateTable ccjCreateTable) {
        List ccjColumnDefinitions = ccjCreateTable.getColumnDefinitions();
        List ccjIndexes = Optional.ofNullable(ccjCreateTable.getIndexes()).orElse(new ArrayList());
        List<TableColumn> existedTableColumns = ModelSqlParserUtil.getTableColumns(ccjColumnDefinitions, ccjIndexes);
        List<String> existedTableColumnNames = existedTableColumns.stream().map(tableColumn -> tableColumn.getColumnName()).collect(Collectors.toList());
        return existedTableColumnNames;
    }

    public static boolean checkColumnUniqueIndex(Index index, String columnName) {
        columnName = DBTableUtil.removeBackQuoteSymbol(columnName);
        String ccjIndexName = DBTableUtil.removeBackQuoteSymbol(index.getName());
        String ccjIndexType = index.getType();
        if (StringUtils.isEmpty((CharSequence)ccjIndexName) || !ccjIndexType.equals("UNIQUE KEY") || index.getColumnsNames().size() > 1) {
            return false;
        }
        return index.getColumnsNames().size() == 1 && ccjIndexName.equals(columnName) && ccjIndexType.equals("UNIQUE KEY");
    }

    public static List<TableIndex> getTableIndexes(List<Index> ccjIndexes) {
        List<TableIndex> existedTableIndexes = ccjIndexes.stream().map(ModelSqlParserUtil::convertToTableIndex).collect(Collectors.toList());
        return existedTableIndexes;
    }

    public static TableIndex convertToTableIndex(Index ccjIndex) {
        String indexTypeName;
        TableIndex tableIndex = new TableIndex();
        String indexName = StringUtils.isNotBlank((CharSequence)ccjIndex.getName()) ? DBTableUtil.removeBackQuoteSymbol(ccjIndex.getName()) : IndexTypeEnum.PRIMARY_KEY.getIndexCommandChar();
        tableIndex.setName(indexName);
        List<String> members = ccjIndex.getColumnsNames().stream().map(member -> DBTableUtil.removeBackQuoteSymbol(member)).collect(Collectors.toList());
        tableIndex.setMember(members);
        switch (indexTypeName = ccjIndex.getType()) {
            case "UNIQUE KEY": {
                tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
                break;
            }
            case "KEY": {
                tableIndex.setType(IndexTypeEnum.INDEX);
                break;
            }
            case "PRIMARY KEY": {
                tableIndex.setType(IndexTypeEnum.PRIMARY_KEY);
                break;
            }
        }
        return tableIndex;
    }

    public static TableColumn convertToTableColumn(ColumnDefinition columnDefinition, List<Index> indexes) {
        if (columnDefinition == null) {
            return null;
        }
        TableColumn tableColumn = new TableColumn();
        String ccjColumnName = columnDefinition.getColumnName();
        List cjColumnDefSpecs = columnDefinition.getColumnSpecs();
        tableColumn.setColumnName(DBTableUtil.removeBackQuoteSymbol(ccjColumnName));
        tableColumn.setComment(ModelDrivenCCJParserUtil.getComment(columnDefinition));
        ColDataType colDataType = columnDefinition.getColDataType();
        tableColumn.setDataType(DataTypeEnum.valueOf((String)colDataType.getDataType().toUpperCase()));
        List dataTypeArgs = colDataType.getArgumentsStringList();
        if (CollectionUtils.isNotEmpty((Collection)cjColumnDefSpecs)) {
            ModelSqlParserUtil.setDefaultValue(cjColumnDefSpecs, tableColumn);
        }
        if (cjColumnDefSpecs.contains("AUTO_INCREMENT")) {
            tableColumn.setAutoIncrement(true);
            if (dataTypeArgs != null && NumberUtils.isDigits((String)((String)dataTypeArgs.get(0)))) {
                tableColumn.setSize(Integer.valueOf((String)dataTypeArgs.get(0)));
            }
            tableColumn.setNullable(false);
        } else {
            boolean columnNullable = ModelSqlParserUtil.fetchCCJNullable(cjColumnDefSpecs);
            tableColumn.setNullable(columnNullable);
            ModelSqlParserUtil.processSizeScale(columnDefinition, tableColumn);
        }
        ArrayList columnUniqueIndexOfIndexes = new ArrayList();
        indexes.stream().forEach(idx -> {
            String ccjIndexName = idx.getName();
            String ccjIndexType = idx.getType();
            if (StringUtils.isEmpty((CharSequence)ccjIndexName) && ccjIndexType.equals("PRIMARY KEY") && idx.getColumnsNames().contains(ccjColumnName)) {
                tableColumn.setPK(true);
            }
            if (ModelSqlParserUtil.checkColumnUniqueIndex(idx, ccjColumnName)) {
                tableColumn.setUnique(true);
                columnUniqueIndexOfIndexes.add(idx);
            }
        });
        indexes.removeAll(columnUniqueIndexOfIndexes);
        return tableColumn;
    }

    public static List<TableColumn> getTableColumns(List<ColumnDefinition> ccjColumnDefinitions, List<Index> ccjIndexes) {
        List<TableColumn> existedTableColumns = ccjColumnDefinitions.stream().map(ccjColumnDef -> ModelSqlParserUtil.convertToTableColumn(ccjColumnDef, ccjIndexes)).collect(Collectors.toList());
        return existedTableColumns;
    }

    public static Map<String, Object> getModifyColumn(String sql) throws Exception {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        String tableName = "";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Alter) {
            Alter alterScript = (Alter)statement;
            Table table = alterScript.getTable();
            String sqlTableName = table.getName();
            tableName = DBTableUtil.removeBackQuoteSymbol(sqlTableName);
            List alterExpressions = alterScript.getAlterExpressions();
            ArrayList<String> alterColumnNames = new ArrayList<String>();
            for (AlterExpression alterExpression : alterExpressions) {
                List dataTypeList;
                if (alterExpression.getOperation() != AlterOperation.MODIFY || !CollectionUtils.isNotEmpty((Collection)(dataTypeList = alterExpression.getColDataTypeList()))) continue;
                String columnName = ((AlterExpression.ColumnDataType)dataTypeList.get(0)).getColumnName();
                alterColumnNames.add(DBTableUtil.removeBackQuoteSymbol(columnName));
            }
            if (CollectionUtils.isNotEmpty(alterColumnNames)) {
                returnValue.put("exceptionAlterDDLTable", tableName);
                returnValue.put("exceptionAlterDDLColumns", alterColumnNames);
            }
            logger.debug("get tableName '{}' alter columns({})", (Object)tableName, alterColumnNames);
        }
        return returnValue;
    }

    public static ExceptionSQLInfo getExceptionSQLInfo(Throwable throwable) throws Exception {
        String errorMessage = throwable.getMessage();
        ExceptionSQLInfo exceptionSQLInfo = new ExceptionSQLInfo();
        exceptionSQLInfo.setErrorMessage(errorMessage);
        Matcher sqlMatcher = ModelDBConstants.PATTERN_SQL.matcher(errorMessage);
        if (sqlMatcher.find()) {
            Matcher paramsMatcher;
            SqlParam sqlParam = new SqlParam();
            String sqlCommand = sqlMatcher.group(1);
            sqlParam.setSql(sqlCommand);
            Table table = ModelSqlParserUtil.getJSqlTable(sqlCommand);
            if (table != null) {
                String tableName = table.getName();
                exceptionSQLInfo.setTableName(DBTableUtil.removeBackQuoteSymbol(tableName));
            }
            if ((paramsMatcher = ModelDBConstants.PATTERN_PARAMS.matcher(errorMessage)).find()) {
                Object[] paramsArray = paramsMatcher.group(1).split(", ");
                sqlParam.setParams(paramsArray);
            }
            exceptionSQLInfo.setSqlParam(sqlParam);
        }
        return exceptionSQLInfo;
    }

    public static Map<String, Object> getSqlCommandInfo(SqlParam sqlParam) throws JSQLParserException {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        String sqlCommand = sqlParam.getSql();
        Object[] sqlParameters = sqlParam.getParams();
        Statement statement = CCJSqlParserUtil.parse((String)sqlCommand, null);
        String sqlTableName = null;
        HashMap<String, String> insertKeyValueMap = new HashMap<String, String>();
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            Table targetTable = insert.getTable();
            if (Objects.nonNull(targetTable)) {
                sqlTableName = targetTable.getName();
                returnValue.put("tableName", sqlTableName);
            }
            List insertColumns = insert.getColumns();
            ItemsList itemsList = insert.getItemsList();
            ExpressionList expressionList = (ExpressionList)itemsList;
            List expressList = expressionList.getExpressions();
            int paramIndex = 0;
            for (Expression expression : expressList) {
                if (expression instanceof JdbcParameter) {
                    int i = ((JdbcParameter)expression).getIndex();
                    int objIndex = i - 1;
                    Object value = sqlParameters[objIndex];
                    String validValue = value == null ? "null" : (value instanceof String ? value : (value instanceof Date ? bindedSqlDateTimeFormat.format(value) : value.toString()));
                    insertKeyValueMap.put(((Column)insertColumns.get(objIndex)).getColumnName(), validValue);
                    logger.debug("get paramIndex({}) org({}) , new({})", new Object[]{paramIndex, "?", validValue == null ? "null" : "'" + validValue.toString()});
                } else if (expression instanceof StringValue) {
                    SimpleNode node = expression.getASTNode();
                    logger.debug("process paramIndex({}) node({})", (Object)paramIndex, node.jjtGetValue());
                } else if (expression instanceof NullValue) {
                    logger.debug("process paramIndex({}) node({})", (Object)paramIndex, (Object)"NULL/null");
                }
                ++paramIndex;
            }
            returnValue.put("indexKeyInfo", insertKeyValueMap);
        }
        return returnValue;
    }

    public static Table getJSqlTable(String sql) throws Exception {
        Table table = null;
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            table = insert.getTable();
        } else if (statement instanceof Update) {
            Update update = (Update)statement;
            table = update.getTable();
        } else if (statement instanceof Delete) {
            Delete delete = (Delete)statement;
            table = delete.getTable();
        } else if (statement instanceof Alter) {
            Alter alter = (Alter)statement;
            table = alter.getTable();
        } else if (statement instanceof CreateTable) {
            CreateTable createTable = (CreateTable)statement;
            table = createTable.getTable();
        } else if (statement instanceof Select) {
            table = SqlParserUtil.getTableObj(sql);
        }
        return table;
    }

    @Deprecated
    public static String getDuplicateKey(String throwSQLErrorMessage) {
        Matcher matcherDuplicateEntry = ModelDBConstants.PATTERN_DUPLICATE_ENTRY.matcher(throwSQLErrorMessage);
        if (matcherDuplicateEntry.find()) {
            String duplicateEntry = matcherDuplicateEntry.group(1);
            String key = matcherDuplicateEntry.group(2);
            return key;
        }
        return null;
    }

    public static void processDataPermissionSql(String sql, SqlValueFields sqlValueFields, ModelDataEntryService modelDataEntryService) throws Exception {
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Select) {
            String appId = Optional.ofNullable(sqlValueFields.getAppId()).orElseThrow(() -> new RuntimeException("appId of view_info can not be null"));
            String actionId = Optional.ofNullable(sqlValueFields.getActionId()).orElseThrow(() -> new RuntimeException("actionId of view_info can not be null"));
            String moduleId = Optional.ofNullable(sqlValueFields.getModuleId()).orElseThrow(() -> new RuntimeException("moduleId of view_info can not be null"));
            String tenantId = Optional.ofNullable(sqlValueFields.getTenantId()).orElseThrow(() -> new RuntimeException("tenantId of view_info can not be null"));
            String userId = Optional.ofNullable(sqlValueFields.getUserId()).orElseThrow(() -> new RuntimeException("userId of view_info can not be null"));
            DWUserPermission dataPermData = (DWUserPermission)modelDataEntryService.getTBBDataPermission(appId, moduleId, actionId, tenantId, userId);
            PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
            FromItem fromItem = select.getFromItem();
            if (fromItem instanceof Table) {
                String rowConditionSql = ModelSqlGenerator.getUserRowPermissionConditionSql(dataPermData, select);
                Expression conditions = CCJSqlParserUtil.parseCondExpression((String)rowConditionSql);
                Expression where = select.getWhere();
                if (conditions != null) {
                    if (where == null) {
                        select.setWhere(conditions);
                    } else {
                        AndExpression expression = new AndExpression(where, conditions);
                        select.setWhere((Expression)expression);
                    }
                    sql = select.toString();
                }
            } else {
                while (fromItem instanceof SubSelect && ((SubSelect)fromItem).getSelectBody() != null) {
                    SubSelect subSelect = (SubSelect)fromItem;
                    PlainSelect ssubSelect = (PlainSelect)subSelect.getSelectBody();
                    if (ssubSelect.getFromItem() instanceof Table) {
                        PlainSelect subPlanSelect = (PlainSelect)subSelect.getSelectBody();
                        String rowConditionSql = ModelSqlGenerator.getUserRowPermissionConditionSql(dataPermData, subPlanSelect);
                        if (!StringUtils.isNotEmpty((CharSequence)rowConditionSql)) break;
                        Expression conditions = CCJSqlParserUtil.parseCondExpression((String)rowConditionSql);
                        Expression where = subPlanSelect.getWhere();
                        if (conditions == null) break;
                        if (where == null) {
                            subPlanSelect.setWhere(conditions);
                        } else {
                            AndExpression expression = new AndExpression(where, conditions);
                            subPlanSelect.setWhere((Expression)expression);
                        }
                        sql = select.toString();
                        break;
                    }
                    if (!(ssubSelect.getFromItem() instanceof SubSelect)) continue;
                    fromItem = ssubSelect.getFromItem();
                }
            }
        }
    }
}

