/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenProperties;
import com.digiwin.lcdp.modeldriven.customize.config.NacosServiceRegisterEvent;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderByProdUtil;
import com.digiwin.loadbalance.service.UpdateMetadataService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class NacosRegisterUtils {
    private static final Logger log = LoggerFactory.getLogger(NacosRegisterUtils.class);
    private static final String _CLASSTAG = "[" + NacosRegisterUtils.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-properties")
    private ModelDrivenProperties modelDrivenProperties;
    @Autowired(required=false)
    UpdateMetadataService updateMetadataService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private EaiHeaderByProdUtil eaiHeaderByProdUtil;

    public void autoRegisterNacos(List<DWEAIHeader> newEaiHeaders) throws Exception {
        this.registerService(newEaiHeaders);
    }

    public void registerService(List<DWEAIHeader> newEaiHeaders) throws Exception {
        if (!this.modelDrivenProperties.isNacosEnabledRegistration()) {
            log.warn("{}[registerService] 1 ignored reg nacos, cause disabled(properties:dwloadBalanceEnable)", (Object)_CLASSTAG);
            return;
        }
        NacosServiceRegisterEvent nacosServiceRegisterEvent = new NacosServiceRegisterEvent(newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)nacosServiceRegisterEvent);
    }

    public void registerService(List<DWEAIHeader> newEaiHeaders, String prod) throws Exception {
        if (!this.modelDrivenProperties.isNacosEnabledRegistration()) {
            log.warn("{}[registerService] 2 ignored reg esp, cause disabled(properties:dwloadBalanceEnable)", (Object)_CLASSTAG);
            return;
        }
        List<String> eaiServiceIdList = newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        this.nacosServiceRegister(eaiServiceIdList, prod);
    }

    public void nacosServiceRegister(List<String> eaiIds) throws Exception {
        if (!this.modelDrivenProperties.isNacosEnabledRegistration()) {
            log.warn("{}[registerService] 3 ignored reg nacos, cause disabled(properties:dwloadBalanceEnable)", (Object)_CLASSTAG);
            return;
        }
        if (this.updateMetadataService != null) {
            HashMap eaiIdsMap = new HashMap();
            eaiIds.forEach(eaiId -> eaiIdsMap.put(eaiId, new int[]{132}));
            this.updateMetadataService.updateInstanceMetadata(eaiIdsMap);
            this.updateMetadataService.updateServiceMetadataIfNeed();
            log.debug("{}<<< nacos service register successfully , service ids :{}", (Object)_CLASSTAG, eaiIds);
        } else {
            log.warn("{} ignored to register nacos service. Please check nacos config if you have any questions.", (Object)_CLASSTAG);
        }
    }

    private void nacosServiceRegister(List<String> eaiIds, String prod) throws Exception {
        if (this.updateMetadataService != null) {
            HashMap eaiIdsMap = new HashMap();
            eaiIds.forEach(eaiId -> eaiIdsMap.put(eaiId, new int[]{132}));
            this.updateMetadataService.updateInstanceMetadata(prod, eaiIdsMap);
            this.updateMetadataService.updateServiceMetadataIfNeed(prod);
            log.debug("{}<<< nacos service register successfully, prod({}) service ids :{}", new Object[]{_CLASSTAG, prod, eaiIds});
        } else {
            log.warn("{} ignored to register nacos service, prod({}). Please check nacos config if you have any questions.", (Object)prod, (Object)_CLASSTAG);
        }
    }

    public void executeRegistryService(Map<String, List<DWEAIHeader>> prodEaiHeaders, String prod) {
        log.info("{}[executeRegistyService] *** BM(mix) prod({}) *** process ...", (Object)_CLASSTAG, (Object)prod);
        if (prodEaiHeaders.containsKey(RegisterServiceTechTypeEnum.NACOS.getTechType())) {
            String nacosStartLog = String.format("%s *** BM(mix) prod(%s) *** NACOS service", _CLASSTAG, prod);
            List<DWEAIHeader> currentProdEaiHeadersForNacos = prodEaiHeaders.get(RegisterServiceTechTypeEnum.NACOS.getTechType());
            if (CollectionUtils.isNotEmpty(currentProdEaiHeadersForNacos)) {
                int nacosServiceSize = currentProdEaiHeadersForNacos.size();
                log.debug("{} bmDataEAIServiceIdsForNacos size:{}", (Object)nacosStartLog, (Object)nacosServiceSize);
                try {
                    Thread.sleep(2000L);
                    List currentProdEaiServiceIdsForNacos = currentProdEaiHeadersForNacos.stream().map(espEaiService -> espEaiService.getEAIServiceId()).collect(Collectors.toList());
                    log.info("{} start to register, size:{}({})", new Object[]{nacosStartLog, nacosServiceSize, currentProdEaiServiceIdsForNacos});
                    if (CollectionUtils.isNotEmpty(currentProdEaiHeadersForNacos)) {
                        this.eaiHeaderByProdUtil.addAndUpdateDWEaiHeaders(currentProdEaiHeadersForNacos);
                    }
                    this.registerService(currentProdEaiHeadersForNacos, prod);
                    log.info("{} finished", (Object)nacosStartLog);
                }
                catch (Exception e) {
                    String errorMessage = String.format("%s register failed", nacosStartLog);
                    log.error("{}:{}", (Object)errorMessage, (Object)e);
                    throw new RuntimeException(errorMessage, e);
                }
            } else {
                log.info("{} ignored to register, size(0)", (Object)nacosStartLog);
            }
        }
    }

    public void registerServiceWithUpdateNacos(List<DWEAIHeader> newEaiHeaders, String prod) throws Exception {
        if (!this.modelDrivenProperties.isNacosEnabledRegistration()) {
            log.warn("{}[registerService] 2 ignored reg nacos, cause disabled(properties:dwloadBalanceEnable)", (Object)_CLASSTAG);
            return;
        }
        List<String> eaiServiceIdList = newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        this.updateNacosService(eaiServiceIdList, prod);
    }

    public void updateNacosService(List<String> eaiIds, String prod) throws Exception {
        if (this.updateMetadataService != null) {
            HashMap eaiIdsMap = new HashMap();
            eaiIds.forEach(eaiId -> eaiIdsMap.put(eaiId, new int[]{132}));
            this.updateMetadataService.updateInstanceMetadata(prod, eaiIdsMap);
            this.updateMetadataService.updateServiceMetadataIfNeed(prod);
            log.debug("{}<<< nacos service register successfully, prod({}) service ids :{}", new Object[]{_CLASSTAG, prod, eaiIds});
        } else {
            log.warn("{} ignored to register nacos service, prod({}). Please check nacos config if you have any questions.", (Object)prod, (Object)_CLASSTAG);
        }
    }
}

