/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.dataview.utils.DataViewFieldUtil;
import com.digiwin.lcdp.modeldriven.eoc.ModelDrivenEocService;
import com.digiwin.lcdp.modeldriven.eoc.pojo.EmpInfoData;
import com.digiwin.lcdp.modeldriven.pojo.QueryConditionDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryConditionUtils {
    private static final Logger log = LoggerFactory.getLogger(QueryConditionUtils.class);
    @Autowired
    private ModelDrivenEocService modelDrivenEocService;

    public DWQueryCondition generateCondition(Iterator it, DWQueryCondition condition, String logic) {
        while (it.hasNext()) {
            QueryConditionDTO currentSearchInfo = (QueryConditionDTO)it.next();
            if ("(".equals(currentSearchInfo.getBracket())) {
                DWQueryCondition childCondition = new DWQueryCondition();
                condition.addCondition(childCondition);
                this.dealQueryConditions(childCondition, currentSearchInfo, logic);
                this.generateCondition(it, childCondition, currentSearchInfo.getLogic());
                continue;
            }
            if (")".equals(currentSearchInfo.getBracket())) {
                this.dealQueryConditions(condition, currentSearchInfo, logic);
                this.generateCondition(it, condition.getParentCondition(), currentSearchInfo.getLogic());
                continue;
            }
            this.dealQueryConditions(condition, currentSearchInfo, logic);
            this.generateCondition(it, condition, currentSearchInfo.getLogic());
        }
        return condition;
    }

    public DWQueryCondition generateCondition(Iterator it, DWQueryCondition condition, List<Map> customizedConditionValues) {
        return this.generateCondition(it, condition, null, customizedConditionValues);
    }

    public DWQueryCondition generateCondition(Iterator it, DWQueryCondition condition, String logic, List<Map> customizedConditionValues) {
        while (it.hasNext()) {
            QueryConditionDTO currentSearchInfo = (QueryConditionDTO)it.next();
            if ("(".equals(currentSearchInfo.getBracket())) {
                DWQueryCondition childCondition = new DWQueryCondition();
                condition.addCondition(childCondition);
                this.dealVariables(childCondition, currentSearchInfo, logic, customizedConditionValues);
                this.generateCondition(it, childCondition, currentSearchInfo.getLogic(), customizedConditionValues);
                continue;
            }
            if (")".equals(currentSearchInfo.getBracket())) {
                if (!StringUtils.isEmpty((CharSequence)currentSearchInfo.getLogic())) {
                    this.dealVariables(condition, currentSearchInfo, logic, customizedConditionValues);
                    this.generateCondition(it, condition.getParentCondition(), currentSearchInfo.getLogic(), customizedConditionValues);
                    continue;
                }
                this.dealVariables(condition, currentSearchInfo, logic, customizedConditionValues);
                this.generateCondition(it, condition.getParentCondition(), currentSearchInfo.getLogic(), customizedConditionValues);
                continue;
            }
            this.dealVariables(condition, currentSearchInfo, logic, customizedConditionValues);
            this.generateCondition(it, condition, currentSearchInfo.getLogic(), customizedConditionValues);
        }
        return condition;
    }

    public void dealQueryConditions(DWQueryCondition condition, QueryConditionDTO searchInfo, String logic) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        result.add(this.generateQueryFields(searchInfo));
        result.forEach(item -> condition.addFieldInfo(item.getName(), item.getOperator(), item.getValues()));
        if ("OR".equals(logic)) {
            condition.ORJoin();
        } else {
            condition.ANDJoin();
        }
    }

    public void dealVariables(DWQueryCondition condition, QueryConditionDTO searchInfo, String logic, List<Map> customizedConditionValues) {
        List<Object> result = new ArrayList<DWQueryField>();
        if ("equal".equals(searchInfo.getSearch_operator()) || "not_equal".equals(searchInfo.getSearch_operator())) {
            if (CollectionUtils.isNotEmpty((Collection)searchInfo.getSearch_value())) {
                result.addAll(this.generateQueryFieldsBySystemVariables(searchInfo));
                result.addAll(this.generateQueryFieldsByCustomVariables(searchInfo, customizedConditionValues));
            }
        } else {
            result = this.generateQueryFieldsByCustomVariables(searchInfo, customizedConditionValues);
        }
        result.forEach(item -> condition.addFieldInfo(item.getName(), item.getOperator(), item.getValues()));
        if ("OR".equals(logic)) {
            condition.ORJoin();
        } else {
            condition.ANDJoin();
        }
    }

    public List<DWQueryField> generateQueryFieldsByCustomVariables(QueryConditionDTO searchInfo, List<Map> customizedConditionValues) {
        if (CollectionUtils.isNotEmpty((Collection)searchInfo.getSearch_value())) {
            List searchValues = searchInfo.getSearch_value();
            if (CollectionUtils.isNotEmpty(customizedConditionValues)) {
                customizedConditionValues.get(0).forEach((key, val) -> {
                    if (searchValues.contains(key)) {
                        if (val instanceof List) {
                            searchInfo.setSearch_value((List)val);
                        } else {
                            searchInfo.setSearch_value(Arrays.asList(val));
                        }
                    }
                });
            }
            return Arrays.asList(this.generateQueryFields(searchInfo));
        }
        return new ArrayList<DWQueryField>();
    }

    public DWQueryField generateQueryFields(QueryConditionDTO searchInfo) {
        DWQueryField dwQueryField = null;
        String searchField = DataViewFieldUtil.getQueryField(searchInfo);
        switch (searchInfo.getSearch_operator()) {
            case "equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Equals, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "not_equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.NotEquals, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "greater_equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.GreaterThanOrEqualTo, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "less_equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.LessThanOrEqualTo, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "greater": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.GreaterThan, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "less": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.LessThan, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "like_r": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Like, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                break;
            }
            case "like": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Like, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                break;
            }
            case "l_like": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Like, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%")});
                break;
            }
            case "not_like": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.NotLike, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                break;
            }
            case "exist": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.In, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            case "not exist": {
                String[] fields = searchField.split("\\.");
                dwQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            case "between": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Between, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            default: {
                throw new RuntimeException(String.format("operator '%s' is not supported", searchInfo.getSearch_operator()));
            }
        }
        return dwQueryField;
    }

    public List<DWQueryField> generateQueryFieldsBySystemVariables(QueryConditionDTO searchInfo) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        Iterator iterator = searchInfo.getSearch_value().iterator();
        while (iterator.hasNext()) {
            switch (iterator.next().toString()) {
                case "{@SYSTEM_DATE_TODAY}": {
                    DWQueryField notEqualQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m-%d')", DWQueryValueOperator.Equals, new Object[]{this.getCurrentDate()});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            notEqualQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m-%d')", DWQueryValueOperator.NotEquals, new Object[]{this.getCurrentDate()});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_DATE_TODAY}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_WEEK}": {
                    DWQueryField greaterQueryField;
                    DWQueryField lessQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m-%d')", DWQueryValueOperator.Between, this.getCurrentWeek().toArray(new Object[1]));
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            lessQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m-%d')", DWQueryValueOperator.LessThan, new Object[]{this.getCurrentWeek().get(0)});
                            greaterQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m-%d')", DWQueryValueOperator.GreaterThan, new Object[]{this.getCurrentWeek().get(1)});
                            result.add(lessQueryField);
                            result.add(greaterQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_DATE_WEEK}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_MONTH}": {
                    DWQueryField notEqualQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m')", DWQueryValueOperator.Equals, new Object[]{this.getCurrentMonth()});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            notEqualQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m')", DWQueryValueOperator.NotEquals, new Object[]{this.getCurrentMonth()});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_DATE_MONTH}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_IN_7}": {
                    DWQueryField greaterQueryField;
                    DWQueryField lessQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.Between, this.getLast7Days().toArray(new Object[1]));
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            lessQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.LessThan, new Object[]{this.getLast7Days().get(0)});
                            greaterQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.GreaterThan, new Object[]{this.getLast7Days().get(1)});
                            result.add(lessQueryField);
                            result.add(greaterQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_DATE_IN_7}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_USER_ID}": {
                    DWQueryField equalQueryField;
                    ArrayList users = new ArrayList();
                    users.add(DWServiceContext.getContext().getProfile().get("userId"));
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            equalQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.Equals, new Object[]{DWServiceContext.getContext().getProfile().get("userId")});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            DWQueryField notEqualQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.NotEquals, new Object[]{DWServiceContext.getContext().getProfile().get("userId")});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_USER_ID}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_ID}": {
                    DWQueryField notEqualQueryField;
                    String[] fields;
                    DWQueryField equalQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            equalQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.In, this.getEmpId().toArray(new Object[1]));
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            fields = searchInfo.getSearch_field().split("\\.");
                            notEqualQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, this.getEmpId().toArray(new Object[1]));
                            notEqualQueryField.setTableName(searchInfo.getTable_name());
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_EMPLOYEE_ID}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID}": {
                    DWQueryField notEqualQueryField;
                    String[] fields;
                    DWQueryField equalQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            equalQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.In, this.getDeptId().toArray(new Object[1]));
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            fields = searchInfo.getSearch_field().split("\\.");
                            notEqualQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, this.getDeptId().toArray(new Object[1]));
                            notEqualQueryField.setTableName(searchInfo.getTable_name());
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_EMPLOYEE_DEPTID}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID_ALL}": {
                    DWQueryField notEqualQueryField;
                    String[] fields;
                    DWQueryField equalQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            equalQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.In, this.getDeptIdAll().toArray(new Object[1]));
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            fields = searchInfo.getSearch_field().split("\\.");
                            notEqualQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, this.getDeptIdAll().toArray(new Object[1]));
                            notEqualQueryField.setTableName(searchInfo.getTable_name());
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_EMPLOYEE_DEPTID_ALL}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
            }
        }
        return result;
    }

    public List getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> result = new ArrayList<String>();
        result.add(format.format(date));
        return result;
    }

    public List getCurrentWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String monday = format.format(calendar.getTime());
        calendar.add(5, 6);
        String sunday = format.format(calendar.getTime());
        ArrayList<String> result = new ArrayList<String>();
        result.add(monday);
        result.add(sunday);
        return result;
    }

    public List getCurrentMonth() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String currentMonth = format.format(calendar.getTime());
        ArrayList<String> result = new ArrayList<String>();
        result.add(currentMonth);
        return result;
    }

    public List getLast7Days() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String lastDay = format.format(calendar.getTime()) + " 23:59:59";
        calendar.add(6, -6);
        String firstDay = format.format(calendar.getTime()) + " 00:00:00";
        ArrayList<String> result = new ArrayList<String>();
        result.add(firstDay);
        result.add(lastDay);
        return result;
    }

    public List getEmpId() {
        Object empInfoDataObject = null;
        String eocEmpId = null;
        try {
            empInfoDataObject = this.modelDrivenEocService.getEmpInfo();
            if (empInfoDataObject instanceof EmpInfoData) {
                EmpInfoData empInfoData = (EmpInfoData)empInfoDataObject;
                eocEmpId = empInfoData.getId();
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)empInfoDataObject;
                log.debug("eoc error code({}), message({})", (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(eocEmpId);
        return result;
    }

    public List getDeptId() {
        Object empInfoDataObject = null;
        String eocEmpDeptId = null;
        try {
            empInfoDataObject = this.modelDrivenEocService.getEmpInfo();
            if (empInfoDataObject instanceof EmpInfoData) {
                EmpInfoData empInfoData = (EmpInfoData)empInfoDataObject;
                eocEmpDeptId = empInfoData.getDepts().get(0).getId();
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)empInfoDataObject;
                log.debug("eoc error code({}), message({})", (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(eocEmpDeptId);
        return result;
    }

    public List getDeptIdAll() {
        Object deptIdsAllObject = null;
        try {
            deptIdsAllObject = this.modelDrivenEocService.getDeptIdAll();
            if (deptIdsAllObject instanceof List) {
                log.debug("eoc deptIds({}))", deptIdsAllObject);
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)deptIdsAllObject;
                log.debug("eoc error code({}), message({})", (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList result = new ArrayList();
        result.addAll((List)deptIdsAllObject);
        return result;
    }
}

