/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.registry;

import com.digiwin.lcdp.modeldriven.customize.config.NacosServiceRegisterEvent;
import com.digiwin.lcdp.modeldriven.customize.registry.BMAbstractRegistryApplicationListener;
import com.digiwin.lcdp.modeldriven.customize.utils.BMMixAppUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.scheduling.annotation.Async;

public class BMMixRegistryApplicationListener
extends BMAbstractRegistryApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(BMMixRegistryApplicationListener.class);
    private static final String _CLASSTAG = "[" + BMMixRegistryApplicationListener.class.getSimpleName() + "]";
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-genEaiHeaders")
    Object prodTechEaiDataObj;
    @Autowired(required=false)
    private NacosRegisterUtils nacosRegisterUtils;
    @Autowired
    EaiHeaderUtil eaiHeaderUtil;

    @Async
    public void onApplicationEvent(ApplicationEvent event) {
        log.debug("{}[onApplicationEvent] start ({})", (Object)_CLASSTAG, event.getClass());
        if (event instanceof InstanceRegisteredEvent) {
            if (BooleanUtils.isTrue((Boolean)this.bmProperties.isInitRegEvent())) {
                log.debug("{} ignore InstanceRegisteredEvent", (Object)_CLASSTAG);
                return;
            }
            log.debug("{} process InstanceRegisteredEvent", (Object)_CLASSTAG);
            try {
                List<String> mergedAppNames = BMMixAppUtil.getMergedAppNames();
                Map prodTechEaiData = (Map)this.prodTechEaiDataObj;
                for (String prod : prodTechEaiData.keySet()) {
                    if (!mergedAppNames.contains(prod)) {
                        log.info("{} *** BM(mix) prod({}) *** ignored process, cause not match merged source info", (Object)_CLASSTAG, (Object)prod);
                        continue;
                    }
                    Map techEaiHeader = (Map)prodTechEaiData.get(prod);
                    this.eaiHeaderUtil.getNacosHeadersCombindCommons(techEaiHeader, prod);
                    this.nacosRegisterUtils.executeRegistryService(techEaiHeader, prod);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.bmProperties.setInitRegEvent(true);
            log.info("{}[onApplicationEvent] finished ({})", (Object)_CLASSTAG, event.getClass());
        } else if (event instanceof NacosServiceRegisterEvent) {
            try {
                log.debug("{} process NacosServiceRegisterEvent", (Object)_CLASSTAG);
                this.nacosRegisterUtils.nacosServiceRegister((List)event.getSource());
            }
            catch (Exception e) {
                log.error("{} nacos service register failed:{}", (Object)_CLASSTAG, (Object)e);
                throw new RuntimeException("nacos service register failed", e);
            }
        }
        log.debug("{}[onApplicationEvent] end ({})", (Object)_CLASSTAG, event.getClass());
    }
}

