/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eai;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenMessageInfo;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenMessageLang;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelDrivenMessageUtils {
    private static final String MESSAGE_API_NAME = "bm.ommsc.message.get";
    private static Map<String, ModelDrivenMessageInfo> messageInfoCache = new HashMap<String, ModelDrivenMessageInfo>();

    public static String getMessage(String messageCode, Object ... params) throws Exception {
        String locale = ((Object)((Object)DWServiceContext.getContext().getRequestHeader().getOrDefault("locale", ModelDrivenMessageLang.ZH_CN))).toString();
        return ModelDrivenMessageUtils.getMessageByLang(ModelDrivenMessageLang.valueOf(locale.toUpperCase()), messageCode, params);
    }

    public static String getMessageByLang(ModelDrivenMessageLang lang, String messageCode, Object ... params) throws Exception {
        Map<String, String> messageData = ModelDrivenMessageUtils.getMessageByLang(lang, Arrays.asList(messageCode));
        if (messageData != null && messageData.size() > 0) {
            String message = messageData.get(messageCode);
            return String.format(message, params);
        }
        return null;
    }

    public static Map<String, String> getMessageByLang(ModelDrivenMessageLang lang, List<String> messageCodeList) throws Exception {
        HashMap<String, String> messageResult = new HashMap<String, String>();
        return messageResult;
    }

    public static String appIdWithoutPrefix() {
        String appId = DWApplicationConfigUtils.getProperty((String)"appId");
        int index = appId.indexOf(45);
        return index > 0 ? appId.substring(index + 1) : appId;
    }

    public static String buildBmpFullMessageCode(String messageCode) {
        String code = messageCode.substring(0, 3) + "." + messageCode.substring(3);
        return "BM." + ModelDrivenMessageUtils.appIdWithoutPrefix() + "." + code;
    }

    public static String get0900001Code() {
        return ModelDrivenMessageUtils.buildBmpFullMessageCode("0900001");
    }
}

