/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.event;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.event.EaiServiceRegisterEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class EaiRegisterEventPublisher {
    private static final Logger _log = LoggerFactory.getLogger(EaiRegisterEventPublisher.class);
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public void publishDataChangeEvent(EaiServiceRegisterEvent eaiServiceRegisterEvent) throws Exception {
        _log.debug("[EaiRegisterEventPublisher] enter publishDataChangeEvent");
        Map extraInfo = eaiServiceRegisterEvent.getDataInfo().getExtraInfo();
        HashMap profile = new HashMap(DWServiceContext.getContext().getProfile());
        if (MapUtils.isNotEmpty(profile)) {
            eaiServiceRegisterEvent.getDataInfo().getExtraInfo().put("extra_profile", profile);
        }
        extraInfo.put("token", EaiRegisterEventPublisher.getToken());
        extraInfo.put("traceId", DWServiceContext.getContext().getTraceId());
        _log.debug("[EaiRegisterEventPublisher] applicationEventPublisher.publishEvent ({})", (Object)eaiServiceRegisterEvent.toString());
        this.applicationEventPublisher.publishEvent((ApplicationEvent)eaiServiceRegisterEvent);
    }

    public static String getToken() {
        String token = DWServiceContext.getContext().getToken();
        if (!StringUtils.isBlank((CharSequence)token)) {
            return token;
        }
        String _token = "";
        return !StringUtils.isBlank((CharSequence)_token) ? _token : _token;
    }
}

