/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(ApTokenUtil.class);

    public static String getCurrentAppId() {
        String currnetAppId = (String)DWServiceContext.getContext().getRequestHeader().get("digi-middleware-appid");
        if (!StringUtils.isNotEmpty((CharSequence)currnetAppId)) {
            throw new DWRuntimeException("ApTokenUtil", "common_wrong_profile_appid.Covert request header and get digi-middleware-appid=" + currnetAppId);
        }
        currnetAppId = ApTokenUtil.getLcdpAppId(currnetAppId);
        return currnetAppId;
    }

    public static String getLcdpAppId(String inputAppId) {
        return inputAppId.toLowerCase();
    }

    public static String getIAMTenantId() {
        return DWServiceContext.getContext().getProfile().getOrDefault(DWTenantUtils.getIamTenantIdKey(), "");
    }

    public static String getLcdpTenantId(String tenantId) {
        return tenantId.toLowerCase();
    }

    public static String getIAMTenantId(Map profile) {
        return profile.getOrDefault(DWTenantUtils.getIamTenantIdKey(), "");
    }

    public static String getCurrentTenantId() {
        String tenantId = ApTokenUtil.getIAMTenantId();
        if (!StringUtils.isNotEmpty((CharSequence)tenantId)) {
            boolean bTenantEnabled = DWTenantUtils.isTenantenabled();
            throw new DWRuntimeException("ApTokenUtil", "common_wrong_profile_tenantid. Current tenantEnabled=" + bTenantEnabled);
        }
        tenantId = ApTokenUtil.getLcdpTenantId(tenantId);
        return tenantId;
    }

    public static String getAppTokenByRequest() {
        String requestApToken = (String)DWServiceContext.getContext().getRequestHeader().get("digi-middleware-auth-app");
        return requestApToken;
    }

    public static String getAppIdByApplicationConfig() {
        String appIdOfSite = DWApplicationConfigUtils.getProperty((String)"appId");
        return appIdOfSite;
    }

    public static boolean checkAppId(String actualAppId) {
        return true;
    }
}

