/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.merge.DWAppMergedInfo;
import com.digiwin.app.merge.DWSourceAppAwareUtils;
import com.digiwin.app.merge.DWSourceAppInfo;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderByProdUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MixEaiRegisterUtil {
    private static final Logger log = LoggerFactory.getLogger(MixEaiRegisterUtil.class);
    private static final String _CLASSTAG = "[" + MixEaiRegisterUtil.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="modeldriven-bm-properties")
    private BMProperties bmProperties;
    @Autowired(required=false)
    private NacosRegisterUtils nacosRegisterUtils;
    @Autowired
    private EaiRegisterUtil eaiRegisterUtil;
    @Autowired
    private EaiHeaderByProdUtil eaiHeaderByProdUtil;

    public void registerService(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        BMRole currentBMRole = this.bmProperties.getRole();
        if (CollectionUtils.isNotEmpty(serviceMappings)) {
            Map<String, Map<String, List<DWEAIHeader>>> bmMixEaiHeaders = this.eaiHeaderByProdUtil.updateAndGetModelDrivenEaiHeadersByProd(serviceMappings, mappingModelInfos);
            DWAppMergedInfo appMergedInfo = DWSourceAppAwareUtils.getAppMergedInfo();
            DWSourceAppInfo targetAppInfo = appMergedInfo.getTargetAppInfo();
            ArrayList<String> mergedAppNames = new ArrayList<String>();
            if (targetAppInfo != null) {
                mergedAppNames.add(targetAppInfo.getAppId());
            }
            List mergedSourceInfo = appMergedInfo.getSourceAppList();
            mergedSourceInfo.stream().forEach(dwSourceAppInfo -> mergedAppNames.add(dwSourceAppInfo.getAppId()));
            for (String prod : bmMixEaiHeaders.keySet()) {
                if (!mergedAppNames.contains(prod)) {
                    log.info("{} *** BM({}) prod({}) *** ignored process, cause not match merged source info", new Object[]{_CLASSTAG, currentBMRole.getRole(), prod});
                    continue;
                }
                Map<String, List<DWEAIHeader>> prodEaiHeaders = bmMixEaiHeaders.get(prod);
                this.executeRegAllTech(prodEaiHeaders, prod);
            }
        }
    }

    public void executeRegAllTech(Map<String, List<DWEAIHeader>> prodEaiHeaders, String prod) {
        log.info("{}[executeReg] *** BM(mix) prod({}) *** process ...", (Object)_CLASSTAG, (Object)prod);
        this.executeRegEspService(prodEaiHeaders, prod);
        if (prodEaiHeaders.containsKey(RegisterServiceTechTypeEnum.NACOS.getTechType())) {
            String nacosStartLog = String.format("%s *** BM prod(%s) *** NACOS service", _CLASSTAG, prod);
            List<DWEAIHeader> currentProdEaiHeadersForNacos = prodEaiHeaders.get(RegisterServiceTechTypeEnum.NACOS.getTechType());
            if (CollectionUtils.isNotEmpty(currentProdEaiHeadersForNacos)) {
                this.nacosRegisterUtils.executeRegistryService(prodEaiHeaders, prod);
            } else {
                log.info("{} ignored to register, size(0)", (Object)nacosStartLog);
            }
        }
    }

    public void executeRegEspService(Map<String, List<DWEAIHeader>> prodEaiHeaders, String prod) {
        String espStartLog = String.format("%s *** BM prod(%s) *** ESP service", _CLASSTAG, prod);
        log.info("{}[executeReg] *** BM(mix) prod({}) *** process ...", (Object)_CLASSTAG, (Object)prod);
        List<Object> currentProdEaiHeadersForEsp = new ArrayList();
        if (prodEaiHeaders.containsKey(RegisterServiceTechTypeEnum.ESP.getTechType())) {
            currentProdEaiHeadersForEsp = prodEaiHeaders.get(RegisterServiceTechTypeEnum.ESP.getTechType());
        }
        boolean isBmdRegistryNacosToEsp = BMProperties.getProperties().isBmdRegistryNacosToEsp();
        log.debug("{}[executeReg] BmdRegistryNacosToEsp={}", (Object)_CLASSTAG, (Object)isBmdRegistryNacosToEsp);
        if (isBmdRegistryNacosToEsp) {
            String nacosTech = RegisterServiceTechTypeEnum.NACOS.getTechType();
            List nacosEaiHeaders = prodEaiHeaders.getOrDefault(nacosTech, new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)nacosEaiHeaders)) {
                try {
                    currentProdEaiHeadersForEsp.addAll(nacosEaiHeaders);
                    log.info("{} *** BMD *** nacos updated espEaiHeaders, size:{} when BmdRegistryNacosToEsp={})", new Object[]{_CLASSTAG, nacosEaiHeaders.size(), isBmdRegistryNacosToEsp});
                }
                catch (Exception e) {
                    String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                    log.error("{} *** BMD *** nacos updated espEaiHeaders failed:{}  when BmdRegistryNacosToEsp={}", new Object[]{_CLASSTAG, errorRootCauseMessage, isBmdRegistryNacosToEsp});
                }
            } else {
                log.debug("{} *** BMD *** ignored nacos espEaiHeaders, size:{} when BmdRegistryNacosToEsp={})", new Object[]{_CLASSTAG, nacosEaiHeaders.size(), isBmdRegistryNacosToEsp});
            }
        }
        if (CollectionUtils.isNotEmpty(currentProdEaiHeadersForEsp)) {
            int espServiceSize = currentProdEaiHeadersForEsp.size();
            try {
                this.eaiHeaderByProdUtil.addAndUpdateDWEaiHeaders(currentProdEaiHeadersForEsp);
                List currentProdEaiServiceIdsForEsp = currentProdEaiHeadersForEsp.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
                log.info("{} start register, size({})({})", new Object[]{espStartLog, espServiceSize, currentProdEaiServiceIdsForEsp});
                DWEAIProperties prodEaiProperties = new DWEAIProperties();
                prodEaiProperties.setHostProd(prod);
                this.eaiRegisterUtil.registerService(currentProdEaiHeadersForEsp, prodEaiProperties);
                log.info("{} invoked ESP registerService", (Object)espStartLog);
            }
            catch (Exception e) {
                String errorMessage = String.format("%s register failed", espStartLog);
                log.error("{}:{}", (Object)errorMessage, (Object)e);
                throw new RuntimeException(errorMessage, e);
            }
        } else {
            log.info("{} ignored to register, size(0)", (Object)espStartLog);
        }
    }
}

