/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.generator.DWSQLTimestampValueGenerator;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.DWValueAttribute;
import com.digiwin.app.metadata.rdbms.DWRdbmsAttributes;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.model.ModelAppInfoDTO;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelInfoDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.DataEntryTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMetadataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ModelDataUtil {
    public static void preCheckSchema(ModelSchemaDTO modelSchema) {
        Assert.notNull((Object)modelSchema, (String)"'modelSchema' must not be null");
        Assert.hasText((String)modelSchema.getName(), (String)"'modelSchema.name' must not be empty");
        Assert.hasText((String)modelSchema.getComment(), (String)"'modelSchema.tableComment' must not be empty");
        Assert.notEmpty(modelSchema.getFields(), (String)"'modelSchema.fields' must not be empty");
        for (int i = 0; i < modelSchema.getFields().size(); ++i) {
            ModelFieldDTO modelFieldDTO = modelSchema.getFields().get(i);
            Assert.hasText((String)modelFieldDTO.getFieldId(), (String)String.format("'modelSchema.fields[%d].fieldId' must not be empty", i));
            Assert.hasText((String)modelFieldDTO.getFieldType(), (String)String.format("'modelSchema.fields[%d].fieldType' must not be empty", i));
        }
    }

    public static Map<String, Object> convertToJson(String databaseTableName, Map<String, Object> dataInfo) {
        DWMetadata<?> masterTableRdbmsMetadata = ModelDrivenMetadataUtil.loadRdbmsMetadata(databaseTableName);
        for (String columnName : dataInfo.keySet()) {
            DWValueAttribute fieldValueAttr;
            Object fieldValueObject = dataInfo.get(columnName);
            if (!masterTableRdbmsMetadata.hasField(columnName) || fieldValueObject == null || !(fieldValueAttr = (DWValueAttribute)masterTableRdbmsMetadata.getField(columnName).getAttribute(DWRdbmsAttributes.RDBMS_VALUE_TYPE)).getValue().equals("JSON")) continue;
            String fieldJsonObj = DWGsonProvider.getGson().toJson(fieldValueObject, Object.class);
            dataInfo.replace(columnName, fieldJsonObj);
        }
        return dataInfo;
    }

    public static List<Map<String, Object>> convertFromJson(DWDataTable dataTable) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        DWMetadata<?> tempTableRdbmsMetadata = ModelDrivenMetadataUtil.loadRdbmsMetadata(dataTable.getName());
        Iterator rowIt = dataTable.getRows().iterator();
        boolean isFirstTime = true;
        HashSet<String> checkedSpecialField = new HashSet<String>();
        while (rowIt.hasNext()) {
            Map rowMap = ((DWDataRow)rowIt.next()).getData();
            for (String columnName : rowMap.keySet()) {
                DWValueAttribute fieldValueAttr;
                Object fieldValueObject = rowMap.get(columnName);
                if (!isFirstTime && checkedSpecialField.contains(columnName)) {
                    if (fieldValueObject == null) continue;
                    Object fieldJsonObj = DWGsonProvider.getGson().fromJson((String)fieldValueObject, Object.class);
                    rowMap.replace(columnName, fieldJsonObj);
                    continue;
                }
                if (!isFirstTime || !tempTableRdbmsMetadata.hasField(columnName) || !(fieldValueAttr = (DWValueAttribute)tempTableRdbmsMetadata.getField(columnName).getAttribute(DWRdbmsAttributes.RDBMS_VALUE_TYPE)).getValue().equals("JSON")) continue;
                checkedSpecialField.add(columnName);
                if (fieldValueObject == null) continue;
                Object fieldJsonObj = DWGsonProvider.getGson().fromJson((String)fieldValueObject, Object.class);
                rowMap.replace(columnName, fieldJsonObj);
            }
            isFirstTime = false;
            dataList.add(rowMap);
        }
        return dataList;
    }

    public static Map<String, Object> convertMapFromJson(DWDataTable dataTable, Map<String, Object> dataInfo) {
        DWMetadata<?> masterTableRdbmsMetadata = ModelDrivenMetadataUtil.loadRdbmsMetadata(dataTable.getName());
        for (String columnName : dataInfo.keySet()) {
            DWValueAttribute fieldValueAttr;
            Object fieldValueObject = dataInfo.get(columnName);
            if (!masterTableRdbmsMetadata.hasField(columnName) || fieldValueObject == null || !(fieldValueAttr = (DWValueAttribute)masterTableRdbmsMetadata.getField(columnName).getAttribute(DWRdbmsAttributes.RDBMS_VALUE_TYPE)).getValue().equals("JSON")) continue;
            Object fieldJsonObj = DWGsonProvider.getGson().fromJson((String)fieldValueObject, Object.class);
            dataInfo.replace(columnName, fieldJsonObj);
        }
        return dataInfo;
    }

    public static List<String> getChildrenName(ModelSchemaDTO modelSchemaDTO) {
        List<String> childrenTableNames = modelSchemaDTO.getChildren().stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
        return childrenTableNames;
    }

    public static List<String> getChildrenName(List<ModelSchemaDTO> childrenModelSchemaDTO) {
        List<String> childrenTableNames = childrenModelSchemaDTO.stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
        return childrenTableNames;
    }

    public static DWDataSetOperationOption getDisabledCommonDataSetOperationOption() {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        return option;
    }

    public static String replaceLast(String string, String substring, String replacement) {
        int index = string.lastIndexOf(substring);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index) + replacement + string.substring(index + substring.length());
    }

    public static Map<String, Object> buildModelData(ModelDTO model) {
        HashMap<String, Object> dataRow = new HashMap<String, Object>();
        dataRow.put("code", model.getCode());
        dataRow.put("app_id", model.getAppId());
        dataRow.put("description", model.getDescription());
        if (model.getSchema() != null) {
            Gson gson = new GsonBuilder().create();
            dataRow.put("model_schema", gson.toJson((Object)model.getSchema()));
        }
        return dataRow;
    }

    @Deprecated
    public static List<Map<String, Object>> buildModelInfoData(ModelDTO model) {
        List<ModelSchemaDTO> getChildrenModelSchema;
        String appId = model.getAppId();
        String code = model.getCode();
        Object userSid = DWServiceContext.getContext().getProfile().get("userSid");
        ArrayList<ModelInfoDTO> targetModelInfos = new ArrayList<ModelInfoDTO>();
        ModelSchemaDTO masterSchemaDTO = model.getSchema();
        ModelInfoDTO masterModelInfo = new ModelInfoDTO();
        masterModelInfo.setTableName(masterSchemaDTO.getName());
        targetModelInfos.add(masterModelInfo);
        List<ModelSchemaDTO> childrenSchemas = model.getSchema().getChildren();
        if (!CollectionUtils.isEmpty(childrenSchemas) && !CollectionUtils.isEmpty(getChildrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas))) {
            for (ModelSchemaDTO childrenSchemaDTO : getChildrenModelSchema) {
                String subTableName = childrenSchemaDTO.getName();
                ModelInfoDTO subModelInfo = new ModelInfoDTO();
                subModelInfo.setTableName(subTableName);
                targetModelInfos.add(subModelInfo);
            }
        }
        ArrayList<Map<String, Object>> returnValue = new ArrayList<Map<String, Object>>();
        for (ModelInfoDTO modelInfoDTO : targetModelInfos) {
            HashMap<String, String> dataRow = new HashMap<String, String>();
            dataRow.put("code", code);
            dataRow.put("table_name", modelInfoDTO.getTableName());
            dataRow.put("app_id", appId);
            dataRow.put("create_user_sid", (String)userSid);
            returnValue.add(dataRow);
        }
        return returnValue;
    }

    public static Map<String, Object> buildUpdateDraftDataRow(ModelDTO model) {
        String tenantId = model.getTargetTenantId();
        Object userSid = DWServiceContext.getContext().getProfile().get("userSid");
        HashMap<String, Object> dataRow = new HashMap<String, Object>();
        dataRow.put("code", model.getCode());
        dataRow.put("target_tenant_id", tenantId);
        dataRow.put("app_id", model.getAppId());
        dataRow.put("description", model.getDescription());
        dataRow.put("update_user_sid", userSid);
        if (model.getSchema() != null) {
            Gson gson = new GsonBuilder().create();
            dataRow.put("model_schema", gson.toJson((Object)model.getSchema()));
        }
        return dataRow;
    }

    public static Map<String, Object> dealInsertMgmtFields(Map<String, Object> param) {
        Object userId = DWServiceContext.getContext().getProfile().get("userId");
        Object userName = DWServiceContext.getContext().getProfile().get("userName");
        String tenantId = DataEntryTokenUtil.getIAMTenantId();
        if (StringUtils.isEmpty((CharSequence)((String)param.get("create_by")))) {
            param.put("create_by", userId);
        }
        if (StringUtils.isEmpty((CharSequence)((String)param.get("create_date")))) {
            param.put("create_date", DWSQLTimestampValueGenerator.generate());
        }
        if (StringUtils.isEmpty((CharSequence)((String)param.get("creator_name")))) {
            param.put("creator_name", userName);
        }
        if (StringUtils.isEmpty((CharSequence)((String)param.get("tenant_id")))) {
            param.put("tenant_id", tenantId);
        }
        return param;
    }

    public static Map<String, Object> dealUpdateMgmtFields(Map<String, Object> param) {
        Object userId = DWServiceContext.getContext().getProfile().get("userId");
        Object userName = DWServiceContext.getContext().getProfile().get("userName");
        if (StringUtils.isEmpty((CharSequence)((String)param.get("modified_by")))) {
            param.put("modified_by", userId);
        }
        if (StringUtils.isEmpty((CharSequence)((String)param.get("modified_date")))) {
            param.put("modified_date", DWSQLTimestampValueGenerator.generate());
        }
        if (StringUtils.isEmpty((CharSequence)((String)param.get("modifier_name")))) {
            param.put("modifier_name", userName);
        }
        return param;
    }

    public static List<MappingModelInfo> getChildrenMappingModelInfo(List<ModelSchemaDTO> allChildrenSchemas, String masterTableName, String userExposePrefixEaiId, String code) {
        ArrayList<MappingModelInfo> mappingModelInfos = new ArrayList<MappingModelInfo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(allChildrenSchemas)) {
            for (ModelSchemaDTO childModelSchema : allChildrenSchemas) {
                String childTableName = childModelSchema.getName();
                if (StringUtils.equals((CharSequence)childTableName, (CharSequence)masterTableName)) continue;
                MappingModelInfo childMappingModelInfo = new MappingModelInfo();
                childMappingModelInfo.setTablename(masterTableName);
                childMappingModelInfo.setChildtbl(childTableName);
                childMappingModelInfo.setEaiid(userExposePrefixEaiId);
                childMappingModelInfo.setCode(code);
                mappingModelInfos.add(childMappingModelInfo);
            }
        }
        return mappingModelInfos;
    }

    public static String getDraftModelSchemaFromContextDraftJson() {
        String modelStr = (String)ModelDrivenContext.getContext().getExtraMap().get("modelStr");
        Assert.hasText((String)modelStr, (String)"modelStr of ModelDriven Context is null or empty");
        String modelSchemaStr = ModelDataUtil.getModelSchemaFromJsonModel(modelStr);
        return modelSchemaStr;
    }

    public static String getModelSchemaFromJsonModel(String modelStr) {
        Map orgModelMap = (Map)DWGsonProvider.getGson().fromJson(modelStr, Map.class);
        Object orgModelSchemaMap = orgModelMap.get("schema");
        String modelSchemaStr = DWGsonProvider.getGson().toJson(orgModelSchemaMap);
        return modelSchemaStr;
    }

    public static String getModelSchemaStr(ModelSchemaDTO modelSchema) {
        String modelSchemaStr = DWGsonProvider.getGson().toJson((Object)modelSchema);
        return modelSchemaStr;
    }

    public static String getModelStr(DWDataRow dataRow) {
        ModelDTO modelDto = new ModelDTO();
        modelDto.setTargetTenantId((String)dataRow.get("target_tenant_id"));
        modelDto.setCode((String)dataRow.get("code"));
        modelDto.setDescription((String)dataRow.get("description"));
        modelDto.setAppId((String)dataRow.get("app_id"));
        ModelSchemaDTO modelSchemaDTO = ModelSchemaUtil.parseModelSchema(dataRow);
        modelDto.setSchema(modelSchemaDTO);
        String modelStr = DWGsonProvider.getGson().toJson((Object)modelDto);
        return modelStr;
    }

    public static List<String> getBindApiNames(List<BindApi> bindApiListConfig) {
        ArrayList<String> bindApiNames = new ArrayList<String>();
        if (Objects.nonNull(bindApiListConfig)) {
            bindApiListConfig.stream().filter(bindApi -> bindApi.getApiName() != null).forEach(bindApi -> bindApiNames.add(bindApi.getApiName()));
        }
        return bindApiNames;
    }

    public static boolean hasBindApiConfig(List<BindApi> bindApiListConfig) {
        List<String> bindApis;
        boolean isBindApiList = false;
        if (Objects.nonNull(bindApiListConfig) && org.apache.commons.collections.CollectionUtils.isNotEmpty(bindApis = ModelDataUtil.getBindApiNames(bindApiListConfig))) {
            isBindApiList = true;
        }
        return isBindApiList;
    }

    public static boolean isDataEmpty(Object tableData) {
        boolean isEmptyData = false;
        if (Objects.nonNull(tableData)) {
            if (tableData instanceof List) {
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((List)tableData))) {
                    isEmptyData = true;
                }
            } else if (MapUtils.isEmpty((Map)((Map)tableData))) {
                isEmptyData = true;
            }
        }
        return isEmptyData;
    }

    public static String getProd(ModelDTO model, String prod) {
        ModelAppInfoDTO modelAppInfo = model.getAppInfo();
        String modelProd = "";
        modelProd = modelAppInfo != null && StringUtils.isNotBlank((CharSequence)modelAppInfo.getProd()) ? modelAppInfo.getProd() : prod;
        return modelProd;
    }
}

