/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.model.ModelApiField;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.utils.BindedApiUtil;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import io.jsonwebtoken.lang.Assert;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamFilterUtil {
    private static final Logger log = LoggerFactory.getLogger(ParamFilterUtil.class);
    private static final String _CLASSTAG = "[" + ParamFilterUtil.class.getSimpleName() + "]";

    public static void filterRequestParam(Map<String, Object> rowData, List<ModelApiField> fields) {
        ParamFilterUtil.filterMgmtParam(rowData, fields);
    }

    public static void filterMgmtParam(Map<String, Object> rowData, List<ModelApiField> modelApiFields) {
        if (CollectionUtils.isEmpty(modelApiFields)) {
            return;
        }
        Iterator<Map.Entry<String, Object>> iterator = rowData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String fieldNameOfRowData = next.getKey();
            if (!ModelDBConstants.APICONFIG_MGMT_FIELD.contains(fieldNameOfRowData)) continue;
            Optional<ModelApiField> optionModelApiField = modelApiFields.stream().filter(modelApiField -> modelApiField.getData_name().equals(fieldNameOfRowData)).findFirst();
            if (optionModelApiField.isPresent()) {
                ModelApiField matchedModelApiField = optionModelApiField.get();
                if (!matchedModelApiField.getShow() && !matchedModelApiField.getRequired()) {
                    iterator.remove();
                    log.warn("{} removed mgmt field({}) from requestData, cause apiConfig(show:{},required:{})", new Object[]{_CLASSTAG, fieldNameOfRowData, matchedModelApiField.getShow(), matchedModelApiField.getRequired()});
                    continue;
                }
                if (matchedModelApiField.getShow() && matchedModelApiField.getRequired() && StringUtils.isEmpty((CharSequence)((String)next.getValue()))) {
                    String mgmtErrorMessage = String.format(ResourceBundleUtils.getString("paramValidate.apiConfig.mgmt.empty"), fieldNameOfRowData);
                    log.error("{} {}", (Object)_CLASSTAG, (Object)mgmtErrorMessage);
                    throw new RuntimeException(mgmtErrorMessage);
                }
                log.debug("{} retained mgmt field({}) of requestData, cause apiConfig(show:{},required:{})", new Object[]{_CLASSTAG, fieldNameOfRowData, matchedModelApiField.getShow(), matchedModelApiField.getRequired()});
                continue;
            }
            if (optionModelApiField.isPresent()) continue;
            iterator.remove();
            log.warn("{} removed mgmt field({}) from requestData, cause apiConfig doesn't hava field", (Object)_CLASSTAG, (Object)fieldNameOfRowData);
        }
    }

    public static void filterRequestParam(Map<String, Object> rowData, ModelSchemaDTO modelSchema) {
        Map<String, Object> modelDrivenContextExtraMap = ModelDrivenContext.getContext().getExtraMap();
        String apiName = (String)modelDrivenContextExtraMap.get("currentServiceName");
        ParamFilterUtil.filterMgmtParam(rowData, modelSchema, apiName);
    }

    public static void filterMgmtParam(Map<String, Object> rowData, ModelSchemaDTO modelSchema, String apiName) {
        Map<String, List<ModelApiField>> tileApiConfig;
        Assert.hasText((String)apiName, (String)"missing apiName");
        List<BindApi> bindApiListConfigs = modelSchema.getBindApiListConfig();
        if (CollectionUtils.isNotEmpty(bindApiListConfigs) && (tileApiConfig = BindedApiUtil.getBindApiFields(modelSchema, apiName)) != null) {
            List<ModelApiField> modelApiFields = tileApiConfig.get(modelSchema.getName());
            ParamFilterUtil.filterMgmtParam(rowData, modelApiFields);
        }
    }
}

