/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.app.autoconfigure.DWEAIRestfulUrlRegisterAutoConfiguration;
import com.digiwin.app.autoconfigure.DWHttpClientAutoConfiguration;
import com.digiwin.app.autoconfigure.DWRestfulCommonsServiceAutoConfiguration;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.aop.DWEAICommonCrudInterceptor;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListenerRegistry;
import com.digiwin.lcdp.modeldriven.aop.ModelDrivenChangeDataVerifyInterceptor;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenDaoProperties;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenProperties;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEnabledCondition;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEnabledLoadBalanceCondition;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.database.ModelDrivenDatabasePatch;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.utils.EaiMethodRepoUtil;
import com.digiwin.lcdp.modeldriven.eai.utils.ModelDrivenESPUtil;
import com.digiwin.lcdp.modeldriven.environment.version.VersionSourceEnum;
import com.digiwin.lcdp.modeldriven.eoc.EocHttpRequester;
import com.digiwin.lcdp.modeldriven.eoc.EocProperties;
import com.digiwin.lcdp.modeldriven.eoc.ModelDrivenEocService;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDrivenEAIMappingService;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenCommonsServiceUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sf.jsqlparser.JSQLParserException;
import org.aopalliance.aop.Advice;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={ModelDrivenEnabledCondition.class})
@ComponentScan(basePackages={"com.digiwin.lcdp.modeldriven"})
@ConditionalOnClass(value={DWServiceCommonsProvider.class})
@AutoConfigureBefore(value={DWRestfulCommonsServiceAutoConfiguration.class, DWEAIRestfulUrlRegisterAutoConfiguration.class, DWHttpClientAutoConfiguration.class})
public class ModelDrivenCommonsAutoConfiguration {
    private static final Logger _log = LoggerFactory.getLogger(ModelDrivenCommonsAutoConfiguration.class);
    private static final String CLASS_LOG_TAG = "[" + ModelDrivenCommonsAutoConfiguration.class.getSimpleName() + "]";
    private static final String BEAN_CREATED_LOG_TAG = "{} bean:eai {} created!";

    @Bean(name={"bmCodes"})
    public Map<String, BMCode> getBMCodes() {
        return new HashMap<String, BMCode>();
    }

    @Bean(name={"dw-modeldriven-properties"})
    public ModelDrivenProperties getModelDrivenProperties(Environment environment) {
        ModelDrivenProperties modelDrivenProperties = new ModelDrivenProperties();
        String modelDrivenCurrentVersion = ModelDrivenCommonsAutoConfiguration.class.getPackage().getImplementationVersion();
        if (StringUtils.isBlank((CharSequence)modelDrivenCurrentVersion)) {
            modelDrivenCurrentVersion = environment.getProperty("lcdp.modeldriven.env.current.version");
            if (StringUtils.isBlank((CharSequence)modelDrivenCurrentVersion)) {
                _log.warn("{} modeldriven current version:can't get in jar and env, can set {} of application.properties in dev environment", (Object)CLASS_LOG_TAG, (Object)"lcdp.modeldriven.env.current.version");
            } else {
                modelDrivenProperties.setCurrentSource(VersionSourceEnum.PROPERTIES);
                _log.info("{} modeldriven current version:{} in application.properties", (Object)CLASS_LOG_TAG, (Object)modelDrivenCurrentVersion);
            }
        } else {
            modelDrivenProperties.setCurrentSource(VersionSourceEnum.JAR);
            URL codeSourceLocation = ModelDrivenCommonsAutoConfiguration.class.getProtectionDomain().getCodeSource().getLocation();
            if (codeSourceLocation != null) {
                modelDrivenProperties.getCurrentMap().put("file", codeSourceLocation.getFile());
            }
            _log.info("{} modeldriven current version:{} in jar", (Object)CLASS_LOG_TAG, (Object)modelDrivenCurrentVersion);
        }
        modelDrivenProperties.setCurrentVersion(modelDrivenCurrentVersion);
        modelDrivenProperties.setEspEnabledRegistration(ModelDrivenESPUtil.enabledEAIAutoRegistration());
        modelDrivenProperties.setNacosEnabledRegistration(ModelDrivenEnabledLoadBalanceCondition.isEnabledLoadBalance());
        ModelDrivenProperties.setProperties(modelDrivenProperties);
        _log.trace(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"dw-modeldriven-properties");
        return modelDrivenProperties;
    }

    @Bean(name={"dw-modeldriven-service-commons-eai-registry"})
    public DWEAICrudInvocationListenerRegistry getRegistry() {
        DWEAICommonCrudInterceptor interceptor = new DWEAICommonCrudInterceptor();
        _log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"dw-modeldriven-service-commons-eai-registry");
        return interceptor;
    }

    @Bean(name={"dw-modeldriven-commons-eai-crud-advisor"})
    @ConditionalOnBean(name={"dw-modeldriven-service-commons-eai-registry"})
    @ConditionalOnMissingBean(name={"dw-modeldriven-commons-eai-crud-advisor"})
    public Advisor dwEAICommonServiceAdvisor(@Qualifier(value="dw-modeldriven-service-commons-eai-registry") DWEAICrudInvocationListenerRegistry registry) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getList(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.get(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.put(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putValid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putInvalid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.delete(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.post(..)) ");
        DWEAICommonCrudInterceptor dweaiCommonCrudInterceptor = (DWEAICommonCrudInterceptor)registry;
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dweaiCommonCrudInterceptor);
        _log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"dw-modeldriven-commons-eai-crud-advisor");
        return advisor;
    }

    @Bean(name={"dw-modeldriven-commons-eai-mapping-service"})
    public ModelDrivenEAIMappingService eaiMappingService(@Qualifier(value="dw-dao") DWDao dwdao, @Qualifier(value="dw-modeldriven-db-patch") ModelDrivenDatabasePatch modelDrivenDatabasePatch) throws JSQLParserException {
        if (dwdao != null) {
            modelDrivenDatabasePatch.upgrade();
        }
        ModelDrivenEAIMappingService eaiMappingService = new ModelDrivenEAIMappingService();
        _log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"dw-modeldriven-commons-eai-mapping-service");
        return eaiMappingService;
    }

    @Bean(name={"dw-modeldriven-db-patch"})
    public ModelDrivenDatabasePatch modelDrivenDatabasePatch(@Qualifier(value="dw-modeldriven-properties") ModelDrivenProperties modelDrivenProperties) {
        ModelDrivenDatabasePatch modelDrivenDatabasePatch = new ModelDrivenDatabasePatch();
        _log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"dw-modeldriven-db-patch");
        return modelDrivenDatabasePatch;
    }

    @Primary
    @Bean(value={"dw-service-commons-provider"})
    public DWServiceCommonsProvider getModelDrivenServiceCommonProvider(@Qualifier(value="modeldriven-bm-properties") BMProperties bmProperties) {
        Map<String, List<Class<?>>> commonsInterfaces = ModelDrivenCommonsServiceUtil.getCommonsServiceInterfaces();
        Map<String, List<DWServiceInfo>> commonsImplements = ModelDrivenCommonsServiceUtil.getCommonsServiceImplements();
        return new DWServiceCommonsProvider(commonsInterfaces, commonsImplements);
    }

    @Bean(value={"dw-modeldriven-eoc-properties"})
    public EocProperties getProperties(Environment environment) {
        EocProperties properties = new EocProperties();
        properties.setUrl(environment.getProperty("eocUrl"));
        properties.setContentType(environment.getProperty("eocContentType", "application/json; charset=UTF-8"));
        properties.setConnectionRequestTimeout(Integer.parseInt(environment.getProperty("eocHttpConnectionPoolRequestTimeout", "20000")));
        properties.setConnectionTimeout(Integer.parseInt(environment.getProperty("eocHttpConnectionTimeout", "60000")));
        properties.setRequestSocketTimeout(Integer.parseInt(environment.getProperty("eocSoTimeout", "30000")));
        properties.setEncode(environment.getProperty("eocEncode", "UTF-8"));
        properties.setConnectionMaxTotal(Integer.parseInt(environment.getProperty("eocHttpMaxConnections", "100")));
        properties.setKeepAliveTimeout(Long.parseLong(environment.getProperty("eocKeepAliveTimeout", "-1")));
        properties.setApiPathEmpInfo(environment.getProperty("eocUrlEmpInfo", "/api/eoc/v2/emp/info"));
        properties.setApiPathEmpDeptAll(environment.getProperty("eocUrlEmpDeptAll", "/api/eoc/v2/emp/direct/dept/all"));
        EocHttpRequester.setProperties(properties);
        _log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"dw-modeldriven-eoc-properties");
        return properties;
    }

    @Bean(value={"dw-modeldriven-eocService"})
    public ModelDrivenEocService getModelDrivenEocService(@Qualifier(value="dw-modeldriven-eoc-properties") EocProperties eocProperties) {
        ModelDrivenEocService modelDrivenEocService = new ModelDrivenEocService();
        _log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"dw-modeldriven-eocService");
        return modelDrivenEocService;
    }

    @Bean(name={"dw-modeldriven-crud-eai-builder"})
    public ModelStandardEaiHeaderBuilder modelStandardEaiHeaderBuilder(@Qualifier(value="dw-modeldriven-eai-repo") ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo) {
        return new ModelStandardEaiHeaderBuilder();
    }

    @Bean(name={"lcdp-modeldriven-std-crud-update-verify-interceptor"})
    public ModelDrivenChangeDataVerifyInterceptor modelDrivenChangeDataVerifyInterceptor() {
        ModelDrivenChangeDataVerifyInterceptor interceptor = new ModelDrivenChangeDataVerifyInterceptor();
        _log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"lcdp-modeldriven-std-crud-update-verify-interceptor");
        return interceptor;
    }

    @Bean(name={"lcdp-modeldriven-std-crud-update-verify-advisor"})
    @ConditionalOnBean(name={"lcdp-modeldriven-std-crud-update-verify-interceptor"})
    @ConditionalOnMissingBean(name={"lcdp-modeldriven-std-crud-update-verify-advisor"})
    public Advisor modeldrivenStdUpdateVerifyAdvisor(@Qualifier(value="lcdp-modeldriven-std-crud-update-verify-interceptor") ModelDrivenChangeDataVerifyInterceptor updateTypeServiceVerifyInterceptor) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.put(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putValid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putInvalid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.delete(..)) ");
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)updateTypeServiceVerifyInterceptor);
        _log.info(BEAN_CREATED_LOG_TAG, (Object)CLASS_LOG_TAG, (Object)"lcdp-modeldriven-std-crud-update-verify-advisor");
        return advisor;
    }

    @Bean(name={"modeldrivenDaoProperties"})
    public ModelDrivenDaoProperties modelDrivenDaoProperties() {
        _log.info("{} bean:{} created!", (Object)CLASS_LOG_TAG, (Object)"modeldrivenDaoProperties");
        return new ModelDrivenDaoProperties();
    }

    @Bean(name={"dw-modeldriven-eai-repo"})
    public ModelDrivenEaiMethodRepository getModelDrivenEaiMethodRepository(@Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider) {
        Map commonsInterfaces = serviceCommonsProvider.getInterfaceServices();
        List interfList = (List)commonsInterfaces.get("commons");
        Optional<Class<?>> eaiClazz = interfList.stream().filter(p -> p.getTypeName().equals("com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService")).findFirst();
        ModelDrivenEaiMethodRepository mdEaiMethodRepo = EaiMethodRepoUtil.getMethodRepo(eaiClazz);
        _log.debug("{} bean:{} created!", (Object)CLASS_LOG_TAG, (Object)"dw-modeldriven-eai-repo");
        return mdEaiMethodRepo;
    }

    @Bean(name={"modeldriven-tech-eaiheader"})
    public TechEaiData<DWEAIHeader> techEaiData() {
        return new TechEaiData<DWEAIHeader>();
    }
}

