/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eai.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterCustomizeHandler;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenMessageInfo;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenMessageLang;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenMessageUtils;
import com.digiwin.lcdp.modeldriven.eai.utils.ESPStdDataBuilder;
import com.digiwin.lcdp.modeldriven.pojo.ESPStdData;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EaiServiceInvoker {
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bm-adapter-handler")
    private BMAdapterCustomizeHandler bmAdapterHandler;
    private static final Logger log = LoggerFactory.getLogger(EaiServiceInvoker.class);
    private static final String CLASS_LOG_TAG = "[" + EaiServiceInvoker.class.getSimpleName() + "]";
    public static final String ERROR_CODE_NUMBER = "0400001";
    private static Map<String, ModelDrivenMessageInfo> messageInfoCache = new HashMap<String, ModelDrivenMessageInfo>();

    public Object invokeInnerService(DWEAIHeader header, Map<String, Object> headers, Map<String, Object> messageBody, boolean opException) throws Exception {
        try {
            String eaiServiceName = header.getEAIServiceId();
            DWContainerContext containerContext = DWContainerContext.getInstance();
            log.debug("{} invokeInnerService({}) start", (Object)CLASS_LOG_TAG, (Object)eaiServiceName);
            DWTargetAPI api = new DWTargetAPI((DWHeader)header, header.getMappingMethod());
            DWDefaultParameters apiParameters = new DWDefaultParameters();
            apiParameters.put("headers", headers);
            apiParameters.put("messageBody", messageBody);
            Map profile = DWServiceContext.getContext().getProfile();
            Object executeResult = containerContext.invoke(api, (DWParameters)apiParameters, profile);
            Gson gson = DWGsonProvider.getGson();
            if (executeResult instanceof DWEAIResult) {
                DWEAIResult eaiResult = (DWEAIResult)executeResult;
                String message = gson.toJson((Object)eaiResult);
                log.debug("{} invokeThisDapService end, response parameter(DWEAIResult) is: {}", (Object)CLASS_LOG_TAG, (Object)message);
            } else if (executeResult instanceof String) {
                log.debug("{} invokeThisDapService end ,response parameter(String) is:{}", (Object)CLASS_LOG_TAG, executeResult);
                executeResult = this.bmAdapterHandler != null ? this.bmAdapterHandler.processBMDataResult((String)executeResult) : gson.fromJson((String)executeResult, DWEAIResult.class);
            }
            return executeResult;
        }
        catch (Exception e) {
            Throwable ex = e.getCause();
            log.error("invokeInnerService error.", ex);
            if (opException) {
                String code = EaiServiceInvoker.buildBmpFullMessageCode("0601054");
                String message = EaiServiceInvoker.getRootCauseMessage(ex);
                String content = EaiServiceInvoker.getMessage("0601054", message);
                throw new DWEaiException(code, content);
            }
            String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            throw new DWRuntimeException(errorMessage);
        }
    }

    public static Map<String, Object> buildReqStdData(Map<String, Object> para) {
        HashMap<String, Map<String, Object>> paraMap = new HashMap<String, Map<String, Object>>();
        paraMap.put("parameter", para);
        HashMap<String, Object> stdPara = new HashMap<String, Object>();
        stdPara.put("std_data", paraMap);
        return stdPara;
    }

    public static String getRootCauseMessage(Throwable exception) {
        Throwable targetCause = null;
        Throwable rootCause = EaiServiceInvoker.getRootCause(exception);
        targetCause = rootCause != null ? rootCause : exception;
        String message = targetCause.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = targetCause.toString();
        }
        return message;
    }

    public static Throwable getRootCause(Throwable exception) {
        return ExceptionUtils.getRootCause((Throwable)exception);
    }

    public static String buildBmpFullMessageCode(String messageCode) {
        String code = messageCode.substring(0, 3) + "." + messageCode.substring(3);
        return "B." + EaiServiceInvoker.appIdWithoutPrefix() + "." + code;
    }

    public static String appIdWithoutPrefix() {
        String appId = DWApplicationConfigUtils.getProperty((String)"appId");
        int index = appId.indexOf(45);
        return index > 0 ? appId.substring(index + 1) : appId;
    }

    public static String getMessage(String messageCode) throws Exception {
        String locale = ((Object)((Object)DWServiceContext.getContext().getRequestHeader().getOrDefault("locale", ModelDrivenMessageLang.ZH_CN))).toString();
        return EaiServiceInvoker.getMessageByLang(ModelDrivenMessageLang.valueOf(locale.toUpperCase()), messageCode, new Object[0]);
    }

    public static String getMessage(String messageCode, Object ... params) throws Exception {
        String locale = ((Object)((Object)DWServiceContext.getContext().getRequestHeader().getOrDefault("locale", ModelDrivenMessageLang.ZH_CN))).toString();
        return EaiServiceInvoker.getMessageByLang(ModelDrivenMessageLang.valueOf(locale.toUpperCase()), messageCode, params);
    }

    public static String getMessageByLang(ModelDrivenMessageLang lang, String messageCode, Object ... params) throws Exception {
        Map<String, String> messageData = EaiServiceInvoker.getMessageByLang(lang, Arrays.asList(messageCode));
        if (MapUtils.isNotEmpty(messageData)) {
            String message = messageData.get(messageCode);
            return String.format(message, params);
        }
        return "";
    }

    public static Map<String, String> getMessageByLang(ModelDrivenMessageLang lang, List<String> messageCodeList) throws Exception {
        List<ModelDrivenMessageInfo> infos = EaiServiceInvoker.getMessageInfo(messageCodeList);
        if (CollectionUtils.isEmpty(infos)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> messageResult = new HashMap<String, String>();
        for (ModelDrivenMessageInfo item : infos) {
            messageResult.put(item.getMessageNo(), item.getMessage(lang));
        }
        return messageResult;
    }

    public static List<ModelDrivenMessageInfo> getMessageInfo(List<String> messageCodeList) throws Exception {
        ArrayList<ModelDrivenMessageInfo> result = new ArrayList<ModelDrivenMessageInfo>();
        ArrayList messageList = new ArrayList();
        for (String item : messageCodeList) {
            ModelDrivenMessageInfo messageInfo = messageInfoCache.get(item);
            if (messageInfo != null) {
                result.add(messageInfo);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("message_no", item);
            messageList.add(map);
        }
        if (CollectionUtils.isNotEmpty(messageList)) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("message_data", messageList);
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("digi-host", "{}");
            ESPStdData stdData = EaiServiceInvoker.invokeSyncApi(headers, "bm.ommsc.message.get", parameter, true);
            if (stdData != null) {
                List codeResult = (List)stdData.getParameter().get("message_data");
                for (Map item : codeResult) {
                    ModelDrivenMessageInfo info = new ModelDrivenMessageInfo(item);
                    messageInfoCache.put(info.getMessageNo(), info);
                    result.add(info);
                }
            } else {
                ModelDrivenMessageInfo info = new ModelDrivenMessageInfo();
                info.setMessageNo("P.LCDP.101.0000");
                info.setMessageEn("ESPStdData is null");
                info.setMessageChs("ESPStdData \u4e3a null");
                info.setMessageCht("ESPStdData \u70ba null");
                result.add(info);
            }
        }
        return result;
    }

    public static ESPStdData invokeSyncApi(Map<String, Object> headers, String serviceName, Map<String, Object> parameter, boolean opException) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String headersStr = mapper.writeValueAsString(headers);
        log.info("{}[invokeSyncApi] invokeESPHeader-origin:{}", (Object)CLASS_LOG_TAG, (Object)headersStr);
        ResponseModel responseModel = EaiServiceInvoker.invokeSyncStableApi(headers, serviceName, parameter);
        ESPStdData stdData = EaiServiceInvoker.toStdData(responseModel.getBodyJsonString());
        if (opException && stdData != null && !"0".equals(stdData.getCode())) {
            Object[] message = new Object[]{serviceName, stdData.getDescription()};
            throw new DWEaiException(stdData.getCode(), ModelDrivenMessageUtils.getMessage(ERROR_CODE_NUMBER, message));
        }
        return stdData;
    }

    public static ResponseModel invokeSyncStableApi(Map<String, Object> headers, String serviceName, Map<String, Object> para) throws Exception {
        String bodyStr = EaiServiceInvoker.buildReqStdJson(para);
        ResponseModel rtn = EaiServiceInvoker.invokeSyncStableApi(headers, serviceName, bodyStr);
        String message = new Gson().toJson((Object)rtn);
        log.debug("{}[invokeSyncStableApi] ResponseModel is: {}", (Object)CLASS_LOG_TAG, (Object)message);
        return rtn;
    }

    public static ResponseModel invokeSyncStableApi(Map<String, Object> headers, String serviceName, String bodyJsonStr) throws Exception {
        RequestModel requestModel = new RequestModel();
        return Invoker.invokeRestSync((RequestModel)requestModel);
    }

    public static String buildReqStdJson(Map<String, Object> para) {
        Map<String, Object> map = EaiServiceInvoker.buildReqStdData(para);
        return EaiServiceInvoker.formateToJson(map);
    }

    public static String formateToJson(Map<String, Object> obj) {
        Gson gson = new Gson();
        return gson.toJson(obj);
    }

    public static ESPStdData toStdData(String jsonResult) {
        Map<String, Object> mapResult = EaiServiceInvoker.formateJson(jsonResult);
        if (mapResult == null) {
            return null;
        }
        Map stdData = (Map)mapResult.get("std_data");
        if (stdData == null) {
            return mapResult.containsKey("error") ? ESPStdDataBuilder.build(ModelDrivenMessageUtils.buildBmpFullMessageCode(ERROR_CODE_NUMBER), mapResult.get("error").toString()) : ESPStdDataBuilder.build(ModelDrivenMessageUtils.buildBmpFullMessageCode(ERROR_CODE_NUMBER), jsonResult);
        }
        Map execution = (Map)stdData.get("execution");
        if (!"0".equals(execution.get("code"))) {
            return ESPStdDataBuilder.build(execution.get("code").toString(), execution.get("description").toString(), execution.getOrDefault("stacktrace", "").toString());
        }
        ESPStdData data = ESPStdDataBuilder.build();
        data.setParameter((Map)stdData.get("parameter"));
        return data;
    }

    public static Map<String, Object> formateJson(String json) {
        Map<String, Object> obj = new HashMap<String, Object>();
        if (!"".equals(json)) {
            Gson gson = new Gson();
            obj = (Map)gson.fromJson(json, HashMap.class);
        }
        return obj;
    }
}

