/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaExtends;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMetadataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelExtendSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ModelExtendPublishHelper {
    private static final Logger log = LoggerFactory.getLogger(ModelExtendPublishHelper.class);
    private static final String CLASS_LOG_TAG = "[" + ModelExtendPublishHelper.class.getSimpleName() + "]";
    @Autowired
    private ModelTableHelperExpress modelTableHelperExpress;

    public ModelPublishedEspResult extendModelCreateOrAlterCustomizeTable() throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        log.debug("{}[extendModelCreateOrAlterCustomizeTable] code({})", (Object)CLASS_LOG_TAG, (Object)draftModel.getCode());
        ModelSchemaExtends draftModelSchema = draftModel.getSchemaExtends();
        ModelSchemaUtil.checkExtendModelSchema(draftModelSchema, true);
        Map draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables");
        List<ModelTable> draftModelTables = draftModelTableMap.values().stream().collect(Collectors.toList());
        AtomicReference<PublishStatusEnum> createStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        DWServiceResult serviceResult = this.modelTableHelperExpress.extendModelCreateCustomizeTableExpress(draftModelTables);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("[extendModelCreateOrAlterCustomizeTable] expected(%b) actual(%b), description:(%s)", createStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            createStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            createStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(createStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    public ModelPublishedEspResult alterExtendModel() throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ModelSchemaExtends draftModelSchemaExtends = draftModel.getSchemaExtends();
        List<ModelSchemaDTO> draftModelSchemas = draftModelSchemaExtends.getExtendModels();
        ModelDTO publishedModel = modelDrivenContext.getPublishedModel();
        ModelSchemaExtends publishedModelSchemaExtends = publishedModel.getSchemaExtends();
        List<ModelSchemaDTO> publishedModelSchemas = publishedModelSchemaExtends.getExtendModels();
        String modelCode = draftModel.getCode();
        log.debug("=============== alterTable ====== {} =========", (Object)modelCode);
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        Map<String, LinkedHashMap<String, List<SqlParam>>> alterTableDXLMap = ModelExtendSqlGenerator.getAlterTableCommand(draftModelSchemas, publishedModelSchemas);
        LinkedList<SqlParam> modelRelatedTableDMLs = new LinkedList<SqlParam>();
        modelRelatedTableDMLs.addAll(ModelExtendSqlGenerator.generateModelRefreshSql(draftModel));
        List<SqlParam> updateModelExtendTableParam = ModelExtendSqlGenerator.generateUpdateModelExtendSql(draftModel);
        modelRelatedTableDMLs.addAll(updateModelExtendTableParam);
        if (CollectionUtils.isNotEmpty(modelRelatedTableDMLs)) {
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        DWServiceResult serviceResult = this.modelTableHelperExpress.alterTableOnly(alterTableDXLMap, modelRelatedTableDMLs);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("create: expected(%b) actual(%b), description:(%s)", alterStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            alterStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            alterStatus.set(PublishStatusEnum.FAILURE);
        }
        alterStatus.set(PublishStatusEnum.CHANGED);
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(alterStatus.get());
        return publishedEspResult;
    }

    public DWSQLExecutionResult deleteExtendModelSchema(ModelDTO model, DWDataRow publishedDataRow) throws Exception {
        Assert.hasText((String)model.getCode(), (String)"model code must not be null or empty");
        Assert.hasText((String)model.getAppId(), (String)"model appid must not be null or empty");
        String code = model.getCode();
        DWSQLExecutionResult returnResult = new DWSQLExecutionResult();
        if (publishedDataRow != null && MapUtils.isNotEmpty((Map)publishedDataRow.getData())) {
            List<String> publishedExtendModelCodes = this.modelTableHelperExpress.getExtendPublishedModelCodes(model);
            boolean dropRunStatus = this.modelTableHelperExpress.dropExtendModels(model, publishedExtendModelCodes);
            AtomicReference<PublishStatusEnum> dropStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
            if (dropRunStatus) {
                dropStatus.set(PublishStatusEnum.SUCCESS);
                returnResult.addDeleteCount(code, 1);
            } else {
                dropStatus.set(PublishStatusEnum.FAILURE);
                returnResult.addDeleteCount(code, 0);
            }
            if (log.isDebugEnabled()) {
                log.debug("code({}) drop status: expected({}) actual({})", new Object[]{code, dropStatus, dropRunStatus});
            }
            ModelDrivenMetadataUtil.removeRdbmsMetadata(code, publishedExtendModelCodes);
        }
        return returnResult;
    }

    public DWSQLExecutionResult processExtendModelSchema(List<String> draftParentModelCodes, List<String> publishedParentModelCodes, String mainModelCode) throws Exception {
        DWSQLExecutionResult returnResult = new DWSQLExecutionResult();
        List<String> candidateDropParentModelCodes = publishedParentModelCodes.stream().filter(draftChild -> draftParentModelCodes.stream().noneMatch(publishedChild -> Objects.equals(draftChild, publishedChild))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(candidateDropParentModelCodes)) {
            List<String> candidateDropExtendModelCodes = this.modelTableHelperExpress.getExtendPublishedModelCodes(candidateDropParentModelCodes);
            Map<String, Object> dbModelTables = this.modelTableHelperExpress.getModelTableFromDatabase(candidateDropExtendModelCodes);
            List<String> needDropModelCodes = candidateDropExtendModelCodes.stream().filter(modelTable -> dbModelTables.containsKey(modelTable)).collect(Collectors.toList());
            boolean dropRunStatus = this.modelTableHelperExpress.dropExtendModelsWhenAlter(needDropModelCodes, mainModelCode);
            AtomicReference<PublishStatusEnum> dropStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
            if (dropRunStatus) {
                dropStatus.set(PublishStatusEnum.SUCCESS);
                returnResult.addDeleteCount(mainModelCode, 1);
            } else {
                dropStatus.set(PublishStatusEnum.FAILURE);
                returnResult.addDeleteCount(mainModelCode, 0);
            }
            if (log.isDebugEnabled()) {
                log.debug("code({}) drop extendCodes({}) status: expected({}) actual({})", new Object[]{mainModelCode, needDropModelCodes, dropStatus, dropRunStatus});
            }
            ModelDrivenMetadataUtil.removeRdbmsMetadata(mainModelCode, needDropModelCodes);
        }
        return returnResult;
    }
}

