/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenDaoProperties;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.database.sql.ModelActivitySql;
import com.digiwin.lcdp.modeldriven.database.sql.ModelDavaViewSql;
import com.digiwin.lcdp.modeldriven.database.sql.ModelExtendSql;
import com.digiwin.lcdp.modeldriven.database.sql.ModelServiceMappingSql;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlParserUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component
public class DBExecuteHandler {
    private static final Logger log = LoggerFactory.getLogger(DBExecuteHandler.class);
    private static final String CLASS_LOG_TAG = "[" + DBExecuteHandler.class.getSimpleName() + "]";
    private static final String RDBMS_EXECUTE_COUNT = "rdbmsExecuteCount";
    private static final String TABLE_EXECUTE_COUNT = "tableExecuteCount";
    private final ModelDrivenDaoProperties modelDrivenDaoProperties;
    private final DWDao dao;
    private static final String SQL_TABLE_EXISTED = "show TABLES LIKE '%s'";
    private static final String LOG_SQL_FORMAT = "%d type:%s sql:%s; sqlParam:%s";

    @Autowired
    public DBExecuteHandler(@Qualifier(value="dw-dao") DWDao dao, @Qualifier(value="modeldrivenDaoProperties") Optional<ModelDrivenDaoProperties> optionalModelDrivenDaoProperties) {
        this.dao = dao;
        this.modelDrivenDaoProperties = optionalModelDrivenDaoProperties.orElse(null);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ModelPublishedEspResult executeCreateTableOfCreateModelDriven(List<SqlParam> ddlSqlParams, List<SqlParam> dmlSqlParams, ModelDTO model) {
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        HashMap<String, Integer> returnValue = new HashMap<String, Integer>();
        String code = model.getCode();
        int ddlExecuteCount = 0;
        try {
            DWDataSetOperationOption daoDDLOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
            daoDDLOption.set("queryTimeout", (Object)this.modelDrivenDaoProperties.getDdlTimeout());
            for (SqlParam sqlParam : ddlSqlParams) {
                String sql = sqlParam.getSql();
                Object[] sqlParams = sqlParam.getParams();
                String sqlParamsString = Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString();
                String logMessage = String.format(LOG_SQL_FORMAT, ddlExecuteCount, "ddl", sql, sqlParamsString);
                log.info(logMessage);
                this.dao.update((IDWSQLOptions)daoDDLOption, sql, sqlParams);
                ++ddlExecuteCount;
            }
            returnValue.put("DDLExecuteCount", ddlExecuteCount);
            DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
            int dmlExecuteCount = 0;
            for (SqlParam sqlParam : dmlSqlParams) {
                String sql = sqlParam.getSql();
                Object[] sqlParams = sqlParam.getParams();
                if (log.isDebugEnabled()) {
                    log.debug(String.format(LOG_SQL_FORMAT, dmlExecuteCount, "dml", sql, Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                }
                this.dao.update((IDWSQLOptions)daoOption, sql, sqlParams);
                ++dmlExecuteCount;
            }
            returnValue.put("DMLExecuteCount", dmlExecuteCount);
        }
        catch (Exception e) {
            publishedEspResult.setPublishStatusEnum(PublishStatusEnum.FAILURE);
            publishedEspResult.setMessage(e.getMessage());
            String logMessage = String.format("[DBExecuteHandler] code(%s) exception 2", code);
            throw new IllegalArgumentException(logMessage, e);
        }
        log.info("{} finished code({}) create table", (Object)CLASS_LOG_TAG, (Object)code);
        publishedEspResult.setPublishStatusEnum(PublishStatusEnum.SUCCESS);
        return publishedEspResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWEAIResult executeAlterTable(Map<String, Object> params) throws DWEaiException {
        DWEAIResult result;
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        String code = draftModel.getCode();
        try {
            LinkedList ddlSqlParams = (LinkedList)MapUtils.getObject(params, (Object)"ddl", new LinkedList());
            if (CollectionUtils.isNotEmpty((Collection)ddlSqlParams)) {
                Map<String, Object> ddlResult = this.executeDDL(ddlSqlParams, draftModel, modelDrivenContext);
                returnValue.putAll(ddlResult);
            } else {
                log.info("{} code({}) no ddl sql", (Object)CLASS_LOG_TAG, (Object)code);
            }
            LinkedList dmlSqlParams = (LinkedList)MapUtils.getObject(params, (Object)"dml", new LinkedList());
            if (CollectionUtils.isNotEmpty((Collection)dmlSqlParams)) {
                Map<String, Object> dmlResult = this.executeDML(dmlSqlParams, modelDrivenContext);
                returnValue.putAll(dmlResult);
            }
            result = EaiResultUtil.getDWEAIResult(returnValue);
        }
        catch (Exception e) {
            DWEAIResult result2;
            String reportCurrentSql = (String)modelDrivenContext.getExtraMap().getOrDefault("executeSql", "");
            String message = e.getMessage();
            if (e instanceof SQLException) {
                SQLException sqle = (SQLException)e;
                String execCode = String.valueOf(sqle.getErrorCode());
                message = String.format("(%s %s)", message, sqle.getSQLState());
                result2 = new DWEAIResult(execCode, sqle.getSQLState(), e.getMessage(), null);
            } else {
                String execCode = "-1";
                message = String.format("%s when executing sql(%s)", message, reportCurrentSql);
                result2 = new DWEAIResult(execCode, "-1", message, null);
            }
            log.info("{} exception code({}) result({})", new Object[]{CLASS_LOG_TAG, code, result2});
            throw new DWEaiException(code, message);
        }
        return result;
    }

    private Map<String, Object> executeDDL(LinkedList<SqlParam> ddlSqlParams, ModelDTO draftModel, ModelDrivenContext modelDrivenContext) throws JSQLParserException {
        String reportCurrentSql = "dummy";
        String code = draftModel.getCode();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        int tableExecuteCount = 0;
        try {
            DWDataSetOperationOption daoDDLOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
            daoDDLOption.set("queryTimeout", (Object)this.modelDrivenDaoProperties.getDdlTimeout());
            for (SqlParam sqlParam : ddlSqlParams) {
                String sql;
                reportCurrentSql = sql = sqlParam.getSql();
                if (log.isDebugEnabled()) {
                    Object[] sqlParams = sqlParam.getParams();
                    String sqlParamString = Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString();
                    String logMessage = String.format(LOG_SQL_FORMAT, tableExecuteCount, "ddl", sql, sqlParamString);
                    log.debug(logMessage);
                }
                log.debug("code({}), option.timeout({}), current sql:{}", new Object[]{code, this.modelDrivenDaoProperties.getDdlTimeout(), sql});
                this.dao.update((IDWSQLOptions)daoDDLOption, sql, new Object[0]);
                ++tableExecuteCount;
            }
            returnValue.put(TABLE_EXECUTE_COUNT, tableExecuteCount);
        }
        catch (Exception e) {
            Map<String, Object> currentModifyColumns = ModelSqlParserUtil.getModifyColumn(reportCurrentSql);
            modelDrivenContext.getExtraMap().put("exceptionAlterDDL", currentModifyColumns);
            modelDrivenContext.getExtraMap().put("executeSql", reportCurrentSql);
            String errorMessage = String.format("%s[executeAlterTable] \u5beb\u5165 \u5931\u6557 (%s) when executing sql (%s)", CLASS_LOG_TAG, e.getMessage(), reportCurrentSql);
            throw new IllegalStateException(errorMessage, e);
        }
        return returnValue;
    }

    private Map<String, Object> executeDML(LinkedList<SqlParam> dmlSqlParams, ModelDrivenContext modelDrivenContext) {
        String reportCurrentSql = "dummy";
        int rdbmsExecuteCount = 0;
        DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        try {
            for (SqlParam sqlParam : dmlSqlParams) {
                String sql;
                reportCurrentSql = sql = sqlParam.getSql();
                Object[] sqlParams = sqlParam.getParams();
                if (log.isDebugEnabled()) {
                    String sqlParamsString = Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString();
                    String errorMessage = String.format(LOG_SQL_FORMAT, rdbmsExecuteCount, "dml", sql, sqlParamsString);
                    log.debug(errorMessage);
                }
                this.dao.update((IDWSQLOptions)daoOption, sql, sqlParams);
                ++rdbmsExecuteCount;
            }
            returnValue.put(RDBMS_EXECUTE_COUNT, rdbmsExecuteCount);
        }
        catch (Exception e) {
            modelDrivenContext.getExtraMap().put("executeSql", reportCurrentSql);
            String errorMessage = String.format("%s[executeAlterTable] \u5beb\u5165 \u5931\u6557 (%s) when executing sql (%s)", CLASS_LOG_TAG, e.getMessage(), reportCurrentSql);
            throw new IllegalStateException(errorMessage, e);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWEAIResult executeDeleteTable(Map<String, Object> params, ModelDTO model) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        String modelCodeName = model.getCode();
        String masterTableName = model.getSchema().getName();
        DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        int rdbmsExecuteCount = 0;
        String reportCurrentSql = "dummy";
        Assert.hasText((String)masterTableName, (String)"masterTableName must not be null or empty");
        DWDataSetOperationOption daoDDLOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        daoDDLOption.set("queryTimeout", (Object)this.modelDrivenDaoProperties.getDdlTimeout());
        int tableExecuteCount = 0;
        LinkedList ddlSqlParams = (LinkedList)MapUtils.getObject(params, (Object)"ddl", new LinkedList());
        for (SqlParam sqlParam : ddlSqlParams) {
            String sql;
            reportCurrentSql = sql = sqlParam.getSql();
            Object[] sqlParams = sqlParam.getParams();
            String sqlParamStr = Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString();
            String logMessage = String.format(LOG_SQL_FORMAT, rdbmsExecuteCount, "ddl", sql, sqlParamStr);
            log.info(logMessage);
            try {
                this.dao.update((IDWSQLOptions)daoDDLOption, sql, new Object[0]);
            }
            catch (Exception e) {
                log.info("{} code({}): something message({}) when execute({})", new Object[]{CLASS_LOG_TAG, modelCodeName, e.getMessage(), reportCurrentSql});
            }
            finally {
                log.debug("{} code({}) drop model code finished", (Object)CLASS_LOG_TAG, (Object)modelCodeName);
            }
            ++tableExecuteCount;
        }
        LinkedList dmlSqlParams = (LinkedList)MapUtils.getObject(params, (Object)"dml", new LinkedList());
        for (SqlParam sqlParam : dmlSqlParams) {
            String sql = sqlParam.getSql();
            Object[] sqlParams = sqlParam.getParams();
            String sqlParamStr = Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString();
            String logMessage = String.format(LOG_SQL_FORMAT, rdbmsExecuteCount, "dml", sql, sqlParamStr);
            log.info(logMessage);
            this.dao.update((IDWSQLOptions)daoOption, sql, sqlParams);
            ++rdbmsExecuteCount;
        }
        returnValue.put(RDBMS_EXECUTE_COUNT, rdbmsExecuteCount);
        returnValue.put(TABLE_EXECUTE_COUNT, tableExecuteCount);
        return EaiResultUtil.getDWEAIResult(returnValue);
    }

    public boolean checkTableExist(String dbTableName) {
        boolean tableExisted = true;
        try {
            DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
            List daoQueryResult = this.dao.select((IDWSQLOptions)option, String.format(SQL_TABLE_EXISTED, dbTableName), new Object[0]);
            if (CollectionUtils.isEmpty((Collection)daoQueryResult)) {
                tableExisted = false;
            }
            log.error("{}[checkTableExist] realTableName({}) tableExisted={}", new Object[]{CLASS_LOG_TAG, dbTableName, tableExisted});
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder();
            tableExisted = false;
            if (e.getCause() instanceof SQLException) {
                SQLException sqlException = (SQLException)e.getCause();
                String sqlMessage = String.format("sqlState(%s), sqlErrorCode(%d), sqlMessage(%s)", sqlException.getSQLState(), sqlException.getErrorCode(), sqlException.getMessage());
                message = message.append(sqlMessage);
            }
            log.error("{}[checkTableExist] realTableName({}) is not valid, message:{}", new Object[]{CLASS_LOG_TAG, dbTableName, message});
        }
        return tableExisted;
    }

    public List<Map<String, Object>> getCreateTableSqlByDBFunc(String dbTableName) {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        List returnValue = this.dao.select((IDWSQLOptions)option, "show create table `" + dbTableName + "`", new Object[0]);
        log.error("{}[getCreateTableSqlByDBFunc] realTableName({}) create table sql: {}", new Object[]{CLASS_LOG_TAG, dbTableName, returnValue});
        return returnValue;
    }

    public List<String> getTableNamesGeneratedByModelDriven(List<String> tableNames) {
        List queryTableNames = tableNames.stream().distinct().collect(Collectors.toList());
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setDistinct(true);
        queryInfo.addSelectField(new String[]{"table_name"});
        DWQueryCondition condition = new DWQueryCondition();
        condition.addFieldInfo("table_name", DWQueryValueOperator.In, queryTableNames.toArray());
        queryInfo.setCondition(condition);
        DWDataSet daoResult = this.dao.select(queryInfo, option);
        DWDataTable dataTable = daoResult.getTable("dw_lcdp_model_info");
        return dataTable.getRows().stream().map(dwDataRow -> (String)dwDataRow.get("table_name")).collect(Collectors.toList());
    }

    public List<String> getModelTableNamesFromModelInfo(String code) {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setDistinct(true);
        queryInfo.addSelectField(new String[]{"table_name"});
        DWQueryCondition condition = new DWQueryCondition();
        condition.addFieldInfo("code", DWQueryValueOperator.Equals, new Object[]{code});
        queryInfo.setCondition(condition);
        DWDataSet daoResult = this.dao.select(queryInfo, option);
        DWDataTable dataTable = daoResult.getTable("dw_lcdp_model_info");
        return dataTable.getRows().stream().map(dwDataRow -> (String)dwDataRow.get("table_name")).collect(Collectors.toList());
    }

    public List<String> getDBExistedTables(ModelSchemaDTO modelSchemaDTO) {
        ArrayList<String> tableNames = new ArrayList<String>();
        if (this.checkTableExist(modelSchemaDTO.getName())) {
            tableNames.add(modelSchemaDTO.getName());
        }
        if (CollectionUtils.isNotEmpty(modelSchemaDTO.getChildren())) {
            modelSchemaDTO.getChildren().forEach(modelSchema -> tableNames.addAll(this.getDBExistedTables((ModelSchemaDTO)modelSchema)));
        }
        return tableNames;
    }

    public void upgradeModelDrivenDatabase(List<String> dbTableNames) throws JSQLParserException {
        DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        log.info("{}[upgradeModelDrivenDatabase] process-1 {}", (Object)CLASS_LOG_TAG, (Object)"dw_service_mapping");
        this.upgradeServiceMapping(dbTableNames, daoOption);
        log.info("{}[upgradeModelDrivenDatabase] process-2 {}", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_data_view");
        this.upgradeDataView(dbTableNames, daoOption);
        log.info("{}[upgradeModelDrivenDatabase] process-3 {}", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_model_activity");
        this.upgradeActivity(dbTableNames, daoOption);
        log.info("{}[upgradeModelDrivenDatabase] process-4 {}", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_model_extend");
        this.upgradeModelExtend(dbTableNames, daoOption);
    }

    private void upgradeModelExtend(List<String> dbTableNames, DWDataSetOperationOption daoOption) {
        if (!dbTableNames.contains("dw_lcdp_model_extend")) {
            log.info("{}[upgradeModelDrivenDatabase] --> basic table({}) is not existed", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_model_extend");
            List<String> insertAndCreateSqls = ModelExtendSql.getCreateTableAndRdbmsSqls();
            for (String insertOrCreateSql : insertAndCreateSqls) {
                this.dao.update((IDWSQLOptions)daoOption, insertOrCreateSql, new Object[0]);
            }
            log.info("{} basic table({}) created!", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_model_extend");
        } else {
            log.info("{} basic table({}) existed! ignored patch", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_model_extend");
        }
    }

    private void upgradeActivity(List<String> dbTableNames, DWDataSetOperationOption daoOption) {
        if (!dbTableNames.contains("dw_lcdp_model_activity")) {
            log.info("{}[upgradeModelDrivenDatabase] --> basic table({}) is not existed", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_model_activity");
            List<String> insertAndCreateActivitySqlSqls = ModelActivitySql.getCreateTableAndRdbmsSqls();
            for (String insertOrCreateSql : insertAndCreateActivitySqlSqls) {
                this.dao.update((IDWSQLOptions)daoOption, insertOrCreateSql, new Object[0]);
            }
            log.info("{} basic table({}) created!", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_model_activity");
        } else {
            log.info("{} basic table({}) existed! ignored patch", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_model_activity");
        }
    }

    private void upgradeDataView(List<String> dbTableNames, DWDataSetOperationOption daoOption) {
        if (!dbTableNames.contains("dw_lcdp_data_view")) {
            log.info("{}[upgradeModelDrivenDatabase] --> basic table({}) is not existed", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_data_view");
            List<String> insertAndCreateDataViewSqls = ModelDavaViewSql.getCreateTableAndRdbmsSqls();
            for (String insertOrCreateSql : insertAndCreateDataViewSqls) {
                this.dao.update((IDWSQLOptions)daoOption, insertOrCreateSql, new Object[0]);
            }
            log.info("{} basic table({}) created!", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_data_view");
        } else {
            log.info("{} basic table({}) existed! ignored patch", (Object)CLASS_LOG_TAG, (Object)"dw_lcdp_data_view");
        }
    }

    private void upgradeServiceMapping(List<String> dbTableNames, DWDataSetOperationOption daoOption) throws JSQLParserException {
        if (dbTableNames.contains("dw_service_mapping")) {
            List<Map<String, Object>> data = this.getCreateTableSqlByDBFunc("dw_service_mapping");
            if (CollectionUtils.isNotEmpty(data)) {
                log.info("{}[upgradeModelDrivenDatabase] --> basic table({}) is existed", (Object)CLASS_LOG_TAG, (Object)"dw_service_mapping");
                CreateTable ccjCreateTable = ModelSqlParserUtil.fetchCCJCreateTable(data);
                List ccjColumnDefinitions = ccjCreateTable.getColumnDefinitions();
                String targetProdFullName = String.join((CharSequence)".", "dw_service_mapping", "target_prod");
                boolean hasTargetProdColumn = ccjColumnDefinitions.stream().anyMatch(ccjColumnDef -> DBTableUtil.removeBackQuoteSymbol(ccjColumnDef.getColumnName()).equalsIgnoreCase("target_prod"));
                if (!hasTargetProdColumn) {
                    SqlParam sqlParamOfServiceMappingPatch = ModelServiceMappingSql.getServiceMapppingPatchSql();
                    this.dao.update((IDWSQLOptions)daoOption, sqlParamOfServiceMappingPatch.getSql(), new Object[0]);
                    this.dao.update((IDWSQLOptions)daoOption, "insert into dw_rdbms_fields  (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, default_value, nullable, is_version, size, scale, is_auto_increment)  values (?, ?, ?, ?, ?, 'N', ?, ?, ?, 'N', ?, ?, ?)  ON DUPLICATE KEY UPDATE table_name=?, seq=?, field_name=?, is_key=?, field_type=?, status_code='N', field_display_name=?, default_value=?, nullable=?, is_version='N', size=?, scale=?, is_auto_increment=? ", sqlParamOfServiceMappingPatch.getParams());
                    log.info("{} patched column({}), cause not existed!", (Object)CLASS_LOG_TAG, (Object)targetProdFullName);
                } else {
                    log.debug("{} column{} existed, ignored patch!", (Object)CLASS_LOG_TAG, (Object)targetProdFullName);
                }
            } else {
                log.info("{}[upgradeModelDrivenDatabase] --> basic table({}) get create table sql is empty, ignored patch", (Object)CLASS_LOG_TAG, (Object)"dw_service_mapping");
            }
        } else {
            log.info("{} basic table({}) not existed!", (Object)CLASS_LOG_TAG, (Object)"dw_service_mapping");
        }
    }

    public List<String> getDBTableNames() {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        List daoQueryResult = this.dao.select((IDWSQLOptions)option, "show tables", new Object[0]);
        ArrayList<String> tableNames = new ArrayList<String>();
        daoQueryResult.stream().forEach(rowMap -> rowMap.values().forEach(row -> tableNames.add((String)row)));
        log.debug("{}[getDBTables] db table total({})", (Object)CLASS_LOG_TAG, (Object)tableNames.size());
        return tableNames;
    }

    public DWDataRow getModelDataRow(String tableName) {
        log.debug("{} starting get model from tableName {}", (Object)CLASS_LOG_TAG, (Object)tableName);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.Join, "dw_lcdp_model", new DWOnColumn[]{new DWOnColumn("code", DWQueryValueOperator.Equals, "code")});
        queryInfo.addEqualInfo("table_name", (Object)tableName);
        queryInfo.addSelectField(new String[]{"dw_lcdp_model.*"});
        return this.dao.selectOne(queryInfo, option);
    }

    public List<String> getExtendPublishedMainModelCode(String mainTableCode) {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_extend");
        queryInfo.addFieldInfo("main_table_code", DWQueryValueOperator.Equals, new Object[]{mainTableCode});
        queryInfo.addSelectField(new String[]{"extend_model_code"});
        DWDataSet dataSet = this.dao.select(queryInfo, option);
        DWDataTable dwModelTable = dataSet.getTables().getPrimaryTable();
        ArrayList<String> extendModelCodes = new ArrayList<String>();
        for (DWDataRow tempRow : dwModelTable.getRows()) {
            Map dataRowData = tempRow.getData();
            extendModelCodes.add((String)dataRowData.get("extend_model_code"));
        }
        return extendModelCodes;
    }

    public List<String> getExtendPublishedModelCodes(List<String> parentModelCodes) {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_extend");
        queryInfo.addFieldInfo("code", DWQueryValueOperator.In, (Object[])parentModelCodes.toArray(new String[0]));
        queryInfo.addSelectField(new String[]{"extend_model_code"});
        DWDataSet dataSet = this.dao.select(queryInfo, option);
        DWDataTable dwModelTable = dataSet.getTables().getPrimaryTable();
        ArrayList<String> extendModelCodes = new ArrayList<String>();
        for (DWDataRow tempRow : dwModelTable.getRows()) {
            Map dataRowData = tempRow.getData();
            extendModelCodes.add((String)dataRowData.get("extend_model_code"));
        }
        return extendModelCodes;
    }
}

