/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.validate;

import com.digiwin.lcdp.modeldriven.constants.ModelDrivenConstants;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ParameterFilterUtil {
    private ParameterFilterUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Map<String, Object>> filterParameters(ModelSchemaDTO modelSchema, List<Map<String, Object>> masterTableParams) {
        ArrayList<Map<String, Object>> newMasterTableRows = new ArrayList<Map<String, Object>>();
        List<String> childTables = ModelSchemaUtil.getCurrentLevelChildNames(modelSchema);
        for (Map<String, Object> masterTableParam : masterTableParams) {
            if (!ParameterFilterUtil.shouldIncludeRow(masterTableParam, childTables)) continue;
            newMasterTableRows.add(masterTableParam);
        }
        return newMasterTableRows;
    }

    public static boolean shouldIncludeRow(Map<String, Object> masterTableParam, List<String> childTables) {
        boolean childrenRowAllNullFlag = true;
        boolean hasUpdateTypeField = false;
        for (Map.Entry<String, Object> entry : masterTableParam.entrySet()) {
            List<Map<String, Object>> childrenTableRows;
            String paramKey = entry.getKey();
            if (!childTables.contains(paramKey) || !CollectionUtils.isNotEmpty(childrenTableRows = ParameterFilterUtil.convertRowData(entry.getValue()))) continue;
            childrenRowAllNullFlag = false;
            Object updateType = childrenTableRows.get(0).get("update_type");
            if (updateType == null || !ModelDrivenConstants.UPDATE_TYPE_SUBTABLE_PART_TYPE2.contains(updateType)) continue;
            hasUpdateTypeField = true;
            break;
        }
        return hasUpdateTypeField || childrenRowAllNullFlag;
    }

    public static List<Map<String, Object>> convertRowData(Object paramValue) {
        ArrayList<Map<String, Object>> childrenTableParamterRows = new ArrayList<Map<String, Object>>();
        if (paramValue instanceof List) {
            childrenTableParamterRows.addAll((List)paramValue);
        } else if (paramValue instanceof Map) {
            childrenTableParamterRows.add((Map)paramValue);
        }
        return childrenTableParamterRows;
    }
}

